/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.tiles;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.apiculture.gui.IGuiBeeHousingInventory;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamableGui;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.IClimatised;
import forestry.core.tiles.TileBase;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public abstract class TileBeeHousingBase
extends TileBase
implements IBeeHousing,
IClimatised,
IGuiBeeHousingInventory,
IStreamableGui {
    private final IBeekeepingLogic beeLogic = BeeManager.beeRoot.createBeekeepingLogic(this);
    private int breedingProgressPercent = 0;

    protected TileBeeHousingBase(String hintKey) {
        super(hintKey);
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beeLogic;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.beeLogic.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.beeLogic.readFromNBT(nbttagcompound);
    }

    @Override
    public Packet func_145844_m() {
        this.beeLogic.syncToClient();
        return super.func_145844_m();
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromBiome(this.getBiome(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public float getExactTemperature() {
        return this.getBiome().func_150564_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public float getExactHumidity() {
        return this.getBiome().field_76751_G;
    }

    @Override
    public void updateClientSide() {
        if (this.beeLogic.canDoBeeFX() && this.updateOnInterval(4)) {
            this.beeLogic.doBeeFX();
            if (this.updateOnInterval(50)) {
                TileBeeHousingBase.doPollenFX(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public static void doPollenFX(World world, double xCoord, double yCoord, double zCoord) {
        double fxX = xCoord + 0.5;
        double fxY = yCoord + 0.25;
        double fxZ = zCoord + 0.5;
        float distanceFromCenter = 0.6f;
        float leftRightSpreadFromCenter = distanceFromCenter * (world.field_73012_v.nextFloat() - 0.5f);
        float upSpread = world.field_73012_v.nextFloat() * 6.0f / 16.0f;
        Proxies.render.addEntitySwarmFX(world, fxX - (double)distanceFromCenter, fxY += (double)upSpread, fxZ + (double)leftRightSpreadFromCenter);
        Proxies.render.addEntitySwarmFX(world, fxX + (double)distanceFromCenter, fxY, fxZ + (double)leftRightSpreadFromCenter);
        Proxies.render.addEntitySwarmFX(world, fxX + (double)leftRightSpreadFromCenter, fxY, fxZ - (double)distanceFromCenter);
        Proxies.render.addEntitySwarmFX(world, fxX + (double)leftRightSpreadFromCenter, fxY, fxZ + (double)distanceFromCenter);
    }

    @Override
    public void updateServerSide() {
        if (this.beeLogic.canWork()) {
            this.beeLogic.doWork();
        }
    }

    @Override
    public int getHealthScaled(int i) {
        return this.breedingProgressPercent * i / 100;
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        data.writeVarInt(this.beeLogic.getBeeProgressPercent());
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        this.breedingProgressPercent = data.readVarInt();
    }

    @Override
    public BiomeGenBase getBiome() {
        return this.field_145850_b.getBiomeGenForCoordsBody(this.field_145851_c, this.field_145849_e);
    }

    @Override
    public int getBlockLightValue() {
        return this.field_145850_b.func_72957_l(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }

    @Override
    public boolean canBlockSeeTheSky() {
        return this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }

    @Override
    public GameProfile getOwner() {
        return this.getAccessHandler().getOwner();
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public Vec3 getBeeFXCoordinates() {
        return Vec3.func_72443_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5));
    }
}

