/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.entities;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.apiculture.gui.IGuiBeeHousingInventory;
import forestry.apiculture.network.packets.PacketBeeLogicEntityRequest;
import forestry.apiculture.tiles.TileBeeHousingBase;
import forestry.core.entities.EntityMinecartContainerForestry;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamableGui;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.IClimatised;
import java.io.IOException;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public abstract class EntityMinecartBeeHousingBase
extends EntityMinecartContainerForestry
implements IBeeHousing,
IGuiBeeHousingInventory,
IClimatised,
IStreamableGui {
    private static final Random random = new Random();
    private static final int beeFXInterval = 4;
    private static final int pollenFXInterval = 50;
    private final int beeFXTime = random.nextInt(4);
    private final int pollenFXTime = random.nextInt(50);
    private final IBeekeepingLogic beeLogic = BeeManager.beeRoot.createBeekeepingLogic(this);
    private final IErrorLogic errorLogic = ForestryAPI.errorStateRegistry.createErrorLogic();
    private int breedingProgressPercent = 0;
    private boolean needsActiveUpdate = true;

    public EntityMinecartBeeHousingBase(World world) {
        super(world);
    }

    public EntityMinecartBeeHousingBase(World world, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beeLogic;
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromBiome(this.getBiome(), (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getBiome().field_76751_G);
    }

    @Override
    public float getExactTemperature() {
        return this.getBiome().field_76750_F;
    }

    @Override
    public float getExactHumidity() {
        return this.getBiome().field_76751_G;
    }

    @Override
    public int getBlockLightValue() {
        return this.field_70170_p.func_72957_l((int)this.field_70165_t, (int)this.field_70163_u + 1, (int)this.field_70161_v);
    }

    @Override
    public boolean canBlockSeeTheSky() {
        return this.field_70170_p.func_72937_j((int)this.field_70165_t, (int)this.field_70163_u + 1, (int)this.field_70161_v);
    }

    @Override
    public World getWorld() {
        return this.field_70170_p;
    }

    @Override
    public BiomeGenBase getBiome() {
        return this.field_70170_p.func_72807_a((int)this.field_70165_t, (int)this.field_70161_v);
    }

    @Override
    public GameProfile getOwner() {
        return this.getAccessHandler().getOwner();
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return this.errorLogic;
    }

    @Override
    public ChunkCoordinates getCoordinates() {
        return new ChunkCoordinates((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
    }

    @Override
    public Vec3 getBeeFXCoordinates() {
        return Vec3.func_72443_a((double)this.field_70165_t, (double)(this.field_70163_u + 0.25), (double)this.field_70161_v);
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        data.writeVarInt(this.beeLogic.getBeeProgressPercent());
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        this.breedingProgressPercent = data.readVarInt();
    }

    @Override
    public int getHealthScaled(int i) {
        return this.breedingProgressPercent * i / 100;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.beeLogic.canWork()) {
                this.beeLogic.doWork();
            }
        } else {
            if (this.needsActiveUpdate) {
                PacketBeeLogicEntityRequest packet = new PacketBeeLogicEntityRequest((Entity)this);
                Proxies.net.sendToServer(packet);
                this.needsActiveUpdate = false;
            }
            if (this.beeLogic.canDoBeeFX()) {
                if (this.field_70170_p.func_82737_E() % 4L == (long)this.beeFXTime) {
                    this.beeLogic.doBeeFX();
                }
                if (this.field_70170_p.func_82737_E() % 50L == (long)this.pollenFXTime) {
                    TileBeeHousingBase.doPollenFX(this.field_70170_p, this.field_70165_t - 0.5, this.field_70163_u - 0.1, this.field_70161_v - 0.5);
                }
            }
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.beeLogic.readFromNBT(nbtTagCompound);
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        this.beeLogic.writeToNBT(nbtTagCompound);
    }
}

