/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.packets;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.UUID;
import net.aetherteam.aether.Aether;
import net.aetherteam.aether.notifications.Notification;
import net.aetherteam.aether.notifications.NotificationHandler;
import net.aetherteam.aether.notifications.NotificationType;
import net.aetherteam.aether.packets.AetherPacket;
import net.aetherteam.aether.packets.AetherPacketHandler;
import net.aetherteam.aether.party.Party;
import net.aetherteam.aether.player.PlayerAether;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;

public class PacketNotificationChange
extends AetherPacket<PacketNotificationChange> {
    public Notification notification;
    public boolean adding;
    public NotificationType type;
    public String headerText;
    public PlayerAether sendingPlayer;
    public PlayerAether receivingPlayer;

    public PacketNotificationChange() {
    }

    public PacketNotificationChange(Notification notification, boolean adding) {
        this.notification = notification;
        this.adding = adding;
        this.headerText = this.notification.getHeaderText();
        this.sendingPlayer = this.notification.getSender();
        this.receivingPlayer = this.notification.getReceiver();
    }

    public void fromBytes(ByteBuf buf) {
        this.type = NotificationType.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.adding = buf.readBoolean();
        this.headerText = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.sendingPlayer = PlayerAether.get(new UUID(buf.readLong(), buf.readLong()));
        this.receivingPlayer = PlayerAether.get(new UUID(buf.readLong(), buf.readLong()));
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.notification.getType().name());
        buf.writeBoolean(this.adding);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.headerText);
        buf.writeLong(this.sendingPlayer.getUniqueID().getMostSignificantBits());
        buf.writeLong(this.sendingPlayer.getUniqueID().getLeastSignificantBits());
        buf.writeLong(this.receivingPlayer.getUniqueID().getMostSignificantBits());
        buf.writeLong(this.receivingPlayer.getUniqueID().getLeastSignificantBits());
    }

    @Override
    public void handleClientSide(PacketNotificationChange message, EntityPlayer player) {
        message.notification = new Notification(message.type, message.headerText, message.sendingPlayer, message.receivingPlayer);
        Notification notification = new Notification(message.type, "Notification Received!", message.sendingPlayer, message.receivingPlayer);
        if (message.adding) {
            NotificationHandler.instance().receiveNotification(notification);
        } else {
            NotificationHandler.instance().removeSentNotification(notification, false);
        }
    }

    @Override
    public void handleServerSide(PacketNotificationChange message, EntityPlayer player) {
        Notification notification;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        ServerConfigurationManager configManager = server.func_71203_ab();
        EntityPlayer realSendingPlayer = player;
        ArrayList<EntityPlayer> playerList = new ArrayList<EntityPlayer>();
        for (Object obj : configManager.field_72404_b) {
            if (!(obj instanceof EntityPlayer)) continue;
            playerList.add((EntityPlayer)obj);
        }
        EntityPlayer realReceivingPlayer = null;
        for (EntityPlayer iteratedPlayer : playerList) {
            PlayerAether iteratedAetherPlayer = PlayerAether.get(iteratedPlayer);
            if (iteratedAetherPlayer != (message.adding ? message.receivingPlayer : message.sendingPlayer)) continue;
            realReceivingPlayer = iteratedPlayer;
        }
        PlayerAether playerInfo = PlayerAether.get(player);
        Party party = playerInfo.getParty();
        Aether.print("Trying!");
        if (party != null) {
            Aether.print("Party: " + party);
            Aether.print("Recruiter: " + player.getDisplayName());
        }
        if (realSendingPlayer == message.sendingPlayer.entityPlayer && realReceivingPlayer != null) {
            Aether.print("Validated!");
            if (party != null && party.getLeader() != playerInfo) {
                Aether.print("Oops! :(");
                return;
            }
            notification = new Notification(message.type, "Notification Received!", message.sendingPlayer, message.receivingPlayer);
            NotificationHandler.instance().receiveNotification(notification);
            AetherPacketHandler.sendTo(new PacketNotificationChange(notification, message.adding), (EntityPlayerMP)realReceivingPlayer);
        } else if (!message.adding) {
            notification = new Notification(message.type, "Notification Received!", message.sendingPlayer, message.receivingPlayer);
            NotificationHandler.instance().removeSentNotification(notification, false);
            AetherPacketHandler.sendTo(new PacketNotificationChange(notification, message.adding), (EntityPlayerMP)realReceivingPlayer);
        }
    }
}

