/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.packets;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.aetherteam.aether.client.gui.notifications.ClientNotificationHandler;
import net.aetherteam.aether.data.DungeonPosition;
import net.aetherteam.aether.notifications.Notification;
import net.aetherteam.aether.notifications.NotificationHandler;
import net.aetherteam.aether.notifications.NotificationType;
import net.aetherteam.aether.notifications.actions.MemberEnterDungeonAction;
import net.aetherteam.aether.notifications.description.MemberEnterDungeonContents;
import net.aetherteam.aether.packets.AetherPacket;
import net.aetherteam.aether.party.Party;
import net.aetherteam.aether.player.PlayerAether;
import net.minecraft.entity.player.EntityPlayer;

public class PacketMemberDungeonJoin
extends AetherPacket<PacketMemberDungeonJoin> {
    private DungeonPosition position;
    private boolean receiverIsAlreadyInDungeon;
    private PlayerAether sender;

    public PacketMemberDungeonJoin() {
    }

    public PacketMemberDungeonJoin(DungeonPosition position, boolean receiverIsAlreadyInDungeon, PlayerAether sender) {
        this.position = position;
        this.receiverIsAlreadyInDungeon = receiverIsAlreadyInDungeon;
        this.sender = sender;
    }

    public void fromBytes(ByteBuf buf) {
        this.position = new DungeonPosition();
        this.position.readData(buf);
        this.receiverIsAlreadyInDungeon = buf.readBoolean();
        this.sender = PlayerAether.get(new UUID(buf.readLong(), buf.readLong()));
    }

    public void toBytes(ByteBuf buf) {
        this.position.writeData(buf);
        buf.writeBoolean(this.receiverIsAlreadyInDungeon);
        buf.writeLong(this.sender.getUniqueID().getMostSignificantBits());
        buf.writeLong(this.sender.getUniqueID().getLeastSignificantBits());
    }

    @Override
    public void handleClientSide(PacketMemberDungeonJoin message, EntityPlayer player) {
        Party party;
        if (message.receiverIsAlreadyInDungeon) {
            ClientNotificationHandler.createGeneric("Joined Dungeon!", message.sender, PlayerAether.get(player));
        }
        if ((party = message.sender.getParty()) != null && message.sender != PlayerAether.get(player) && party.getLeader() == message.sender) {
            NotificationHandler.instance().receiveNotification(new Notification(NotificationType.DUNGEON_ENTER, "Dungeon Request!", message.sender, PlayerAether.get(player), new MemberEnterDungeonAction(message.position), new MemberEnterDungeonContents()));
        }
    }

    @Override
    public void handleServerSide(PacketMemberDungeonJoin message, EntityPlayer player) {
        Party party;
        if (message.receiverIsAlreadyInDungeon) {
            ClientNotificationHandler.createGeneric("Joined Dungeon!", message.sender, PlayerAether.get(player));
        }
        if ((party = message.sender.getParty()) != null && message.sender != PlayerAether.get(player) && party.getLeader() == message.sender) {
            NotificationHandler.instance().receiveNotification(new Notification(NotificationType.DUNGEON_ENTER, "Dungeon Request!", message.sender, PlayerAether.get(player), new MemberEnterDungeonAction(message.position), new MemberEnterDungeonContents()));
        }
    }
}

