/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.dungeons.worldgen.rooms;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import java.util.Random;
import net.aetherteam.aether.AetherLoot;
import net.aetherteam.aether.blocks.AetherBlocks;
import net.aetherteam.aether.dungeons.Dungeon;
import net.aetherteam.aether.dungeons.worldgen.rooms.DungeonRoom;
import net.aetherteam.aether.tile_entities.TileEntitySkyrootChest;
import net.aetherteam.aether.worldgen.ChunkProviderAether;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public class DungeonRoomChestPillar
extends DungeonRoom {
    public DungeonRoomChestPillar(Dungeon dungeon, int componentType, StructureComponent previousStructure, Random rand, StructureBoundingBox structureBoundingBox, int direction) {
        super(dungeon, componentType, previousStructure, rand, structureBoundingBox, direction);
    }

    @Override
    public boolean func_74875_a(World world, Random rand, StructureBoundingBox chunkBox) {
        for (int var12 = this.field_74887_e.field_78895_b; var12 <= this.field_74887_e.field_78894_e; ++var12) {
            for (int var13 = this.field_74887_e.field_78897_a; var13 <= this.field_74887_e.field_78893_d; ++var13) {
                for (int var14 = this.field_74887_e.field_78896_c; var14 <= this.field_74887_e.field_78892_f; ++var14) {
                    this.func_151550_a(world, rand.nextInt(40) == 1 ? AetherBlocks.Trap : AetherBlocks.DungeonStone, 0, var13, var12, var14, chunkBox);
                }
            }
        }
        int minX = this.field_74887_e.field_78897_a + (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2 - 1;
        int minY = this.field_74887_e.field_78895_b + 1;
        int minZ = this.field_74887_e.field_78896_c + (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 - 1;
        int maxX = this.field_74887_e.field_78897_a + (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2 + 1;
        int maxY = this.field_74887_e.field_78895_b + 1;
        int maxZ = this.field_74887_e.field_78896_c + (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 + 1;
        this.fillWithBlocksWithNotify(world, chunkBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 1, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e - 1, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a, 0, Blocks.field_150350_a, false);
        this.fillWithBlocksWithNotify(world, chunkBox, minX, minY, minZ, maxX, maxY, maxZ, AetherBlocks.LabyrinthPillar, 2, Blocks.field_150350_a, false);
        this.fillWithBlocksWithNotify(world, chunkBox, minX, this.field_74887_e.field_78894_e - 1, minZ, maxX, this.field_74887_e.field_78894_e - 1, maxZ, AetherBlocks.LabyrinthPillar, 2, Blocks.field_150350_a, false);
        this.fillVariedBlocks(world, chunkBox, minX, this.field_74887_e.field_78895_b + (this.field_74887_e.field_78894_e - this.field_74887_e.field_78895_b) / 2, minZ, maxX, this.field_74887_e.field_78895_b + (this.field_74887_e.field_78894_e - this.field_74887_e.field_78895_b) / 2, maxZ, AetherBlocks.LabyrinthPillar, 2, AetherBlocks.LabyrinthPillar, 2, 2, rand, false);
        this.fillVariedBlocks(world, chunkBox, minX + 1, minY, minZ + 1, maxX - 1, this.field_74887_e.field_78894_e - 1, maxZ - 1, AetherBlocks.CarvedWall, 0, AetherBlocks.CarvedWall, 0, 1, rand, true);
        this.func_151550_a(world, AetherBlocks.LabyrinthPillar, 2, minX, minY, minZ, chunkBox);
        this.func_151550_a(world, AetherBlocks.LabyrinthPillar, 2, minX, this.field_74887_e.field_78894_e - 1, minZ, chunkBox);
        this.func_151550_a(world, AetherBlocks.LabyrinthPillar, 2, maxX, minY, maxZ, chunkBox);
        this.func_151550_a(world, AetherBlocks.LabyrinthPillar, 2, maxX, this.field_74887_e.field_78894_e - 1, maxZ, chunkBox);
        this.fillVariedBlocks(world, chunkBox, minX, minY, minZ, minX, this.field_74887_e.field_78894_e - 1, minZ, AetherBlocks.LabyrinthPillar, 0, AetherBlocks.LabyrinthPillar, 0, 1, rand, false);
        this.fillVariedBlocks(world, chunkBox, maxX, minY, maxZ, maxX, this.field_74887_e.field_78894_e - 1, maxZ, AetherBlocks.LabyrinthPillar, 0, AetherBlocks.LabyrinthPillar, 0, 1, rand, false);
        int x = this.field_74887_e.field_78897_a + (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2;
        int y = this.field_74887_e.field_78895_b + 2;
        int z = this.field_74887_e.field_78896_c + (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2;
        for (int chestCount = 1; chestCount <= 4; ++chestCount) {
            TileEntitySkyrootChest chestEntity;
            if (rand.nextInt(2) != 0) continue;
            int xOffset = 0;
            int zOffset = 0;
            int chestDirection = 1;
            switch (chestCount) {
                case 1: {
                    xOffset = 1;
                    chestDirection = 1;
                    break;
                }
                case 2: {
                    xOffset = -1;
                    chestDirection = 2;
                    break;
                }
                case 3: {
                    zOffset = 1;
                    chestDirection = 3;
                    break;
                }
                case 4: {
                    zOffset = -1;
                    chestDirection = 4;
                }
            }
            int i = this.func_74865_a(x + xOffset, z + zOffset);
            int j = this.func_74862_a(y);
            int k = this.func_74873_b(x + xOffset, z + zOffset);
            if (!chunkBox.func_78890_b(i, j, k) || world.func_147439_a(i, j, k) == AetherBlocks.SkyrootChest || rand.nextInt(3) != 0) continue;
            world.func_147465_d(i, j, k, AetherBlocks.SkyrootChest, chestDirection, ChunkProviderAether.placementFlagType);
            world.func_72921_c(i, j, k, chestDirection, ChunkProviderAether.placementFlagType);
            Side side = FMLCommonHandler.instance().getEffectiveSide();
            if (!side.isServer() || world.field_72995_K || (chestEntity = (TileEntitySkyrootChest)world.func_147438_o(i, j, k)) == null) continue;
            for (int count = 0; count < 2 + rand.nextInt(3); ++count) {
                ItemStack stack = AetherLoot.NORMAL.getRandomItem(rand);
                if (stack.field_77994_a <= 0) {
                    stack.field_77994_a = 1;
                }
                chestEntity.func_70299_a(rand.nextInt(chestEntity.func_70302_i_()), stack);
            }
        }
        this.func_151550_a(world, AetherBlocks.AetherMobSpawner, 0, x, y + 1, z, chunkBox);
        TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_147438_o(x, y + 1, z);
        if (spawner != null) {
            String mobID = rand.nextInt(3) == 1 ? "aether.sentryGolem" : "aether.battleSentry";
            spawner.func_145881_a().func_98272_a(mobID);
        }
        this.cutHolesForEntrances(world, rand, chunkBox);
        return true;
    }

    protected void fillWithBlocksWithNotify(World par1World, StructureBoundingBox par2StructureBoundingBox, int par3, int par4, int par5, int par6, int par7, int par8, Block par9, int blockMeta, Block par10, boolean par11) {
        for (int var12 = par4; var12 <= par7; ++var12) {
            for (int var13 = par3; var13 <= par6; ++var13) {
                for (int var14 = par5; var14 <= par8; ++var14) {
                    if (par11 && this.func_151548_a(par1World, var13, var12, var14, par2StructureBoundingBox) == Blocks.field_150350_a) continue;
                    if (var12 != par4 && var12 != par7 && var13 != par3 && var13 != par6 && var14 != par5 && var14 != par8) {
                        this.func_151550_a(par1World, par10, blockMeta, var13, var12, var14, par2StructureBoundingBox);
                        continue;
                    }
                    this.func_151550_a(par1World, par9, blockMeta, var13, var12, var14, par2StructureBoundingBox);
                }
            }
        }
    }

    public void fillVariedBlocks(World world, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Block blockID1, int meta1, Block blockID2, int meta2, int rarity, Random rand, boolean replaceBlocks) {
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (this.func_151548_a(world, x, y, z, box) != Blocks.field_150350_a && !replaceBlocks) continue;
                    Block blockID = blockID2;
                    int meta = meta2;
                    if (rand.nextInt(rarity) == 1) {
                        blockID = blockID1;
                        meta = meta1;
                    }
                    this.func_151550_a(world, blockID, meta, x, y, z, box);
                }
            }
        }
    }

    public static StructureBoundingBox findValidPlacement(List components, Random random, int i, int j, int k, int direction) {
        int roomX = 8 + random.nextInt(16);
        int roomZ = 8 + random.nextInt(16);
        int roomY = 10;
        StructureBoundingBox var6 = new StructureBoundingBox(i, j, k, i, j + roomY, k);
        switch (direction) {
            case 0: {
                var6.field_78897_a = i - 1;
                var6.field_78893_d = i + roomX - 1;
                var6.field_78892_f = k + roomZ;
                break;
            }
            case 1: {
                var6.field_78897_a = i - roomX;
                var6.field_78896_c = k - 1;
                var6.field_78892_f = k + roomZ - 1;
                break;
            }
            case 2: {
                var6.field_78897_a = i - 1;
                var6.field_78893_d = i + roomX - 1;
                var6.field_78896_c = k - roomZ;
                break;
            }
            case 3: {
                var6.field_78893_d = i + roomX;
                var6.field_78896_c = k - 1;
                var6.field_78892_f = k + roomZ - 1;
            }
        }
        return StructureComponent.func_74883_a((List)components, (StructureBoundingBox)var6) != null ? null : var6;
    }
}

