/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.dungeons;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.aetherteam.aether.dungeons.Dungeon;
import net.aetherteam.aether.dungeons.worldgen.rooms.DungeonRoom;
import net.aetherteam.aether.dungeons.worldgen.rooms.DungeonRoomChestPillar;
import net.aetherteam.aether.dungeons.worldgen.rooms.DungeonRoomChests;
import net.aetherteam.aether.dungeons.worldgen.rooms.DungeonRoomCorridor;
import net.aetherteam.aether.dungeons.worldgen.rooms.DungeonRoomLabyrinthEntrance;
import net.aetherteam.aether.dungeons.worldgen.rooms.DungeonRoomLabyrinthEye;
import net.aetherteam.aether.dungeons.worldgen.rooms.DungeonRoomSentryGuardian;
import net.aetherteam.aether.dungeons.worldgen.rooms.DungeonRoomSliderMimic;
import net.aetherteam.aether.dungeons.worldgen.rooms.DungeonRoomStairs;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public class DungeonSliderLabyrinth
extends Dungeon {
    public static final int KEY_FRAGMENTS_REQUIRED = 3;
    public static final int DUNGEON_AREA = 5;

    @Override
    protected DungeonRoom getRandomRoom(DungeonRoom previousRoom, List rooms, Random rand, int i, int j, int k, int direction, int roomNumber) {
        DungeonRoom room;
        StructureBoundingBox boundingBox;
        int chance = rand.nextInt(100);
        if (this.numberOfCertainRoom(rooms, DungeonRoomLabyrinthEntrance.class) < 1 && (boundingBox = DungeonRoomLabyrinthEntrance.findValidPlacement(rooms, rand, i, j, k, direction)) != null) {
            DungeonRoomLabyrinthEntrance room2 = new DungeonRoomLabyrinthEntrance((Dungeon)this, roomNumber, (StructureComponent)previousRoom, rand, boundingBox, direction);
            return room2;
        }
        if (this.numberOfCertainRoom(rooms, DungeonRoomLabyrinthEye.class) < 1 && (rand.nextInt(10) == 0 || roomNumber >= 5) && (boundingBox = DungeonRoomLabyrinthEye.findValidPlacement(rooms, rand, i, j, k, direction)) != null && this.hasIntersectingEntrances(previousRoom, room = new DungeonRoomLabyrinthEye((Dungeon)this, roomNumber, (StructureComponent)previousRoom, rand, boundingBox, direction))) {
            return room;
        }
        if (this.numberOfCertainRoom(rooms, DungeonRoomSentryGuardian.class) < 1 && (rand.nextInt(10) == 0 || roomNumber >= 5) && (boundingBox = DungeonRoomSentryGuardian.findValidPlacement(rooms, rand, i, j, k, direction)) != null && this.hasIntersectingEntrances(previousRoom, room = new DungeonRoomSentryGuardian((Dungeon)this, roomNumber, (StructureComponent)previousRoom, rand, boundingBox, direction))) {
            return room;
        }
        if (this.numberOfCertainRoom(rooms, DungeonRoomSliderMimic.class) < 1 && (rand.nextInt(10) == 0 || roomNumber >= 5) && (boundingBox = DungeonRoomSliderMimic.findValidPlacement(rooms, rand, i, j, k, direction)) != null && this.hasIntersectingEntrances(previousRoom, room = new DungeonRoomSliderMimic((Dungeon)this, roomNumber, (StructureComponent)previousRoom, rand, boundingBox, direction))) {
            return room;
        }
        if (chance < 30 ? (boundingBox = DungeonRoomCorridor.findValidPlacement(rooms, rand, i, j, k, direction)) != null && this.hasIntersectingEntrances(previousRoom, room = new DungeonRoomCorridor((Dungeon)this, roomNumber, (StructureComponent)previousRoom, rand, boundingBox, direction)) : (chance < 50 ? (boundingBox = DungeonRoomChests.findValidPlacement(rooms, rand, i, j, k, direction)) != null && this.hasIntersectingEntrances(previousRoom, room = new DungeonRoomChests((Dungeon)this, roomNumber, (StructureComponent)previousRoom, rand, boundingBox, direction)) : (chance < 70 ? !(previousRoom instanceof DungeonRoomStairs) && (boundingBox = DungeonRoomStairs.findValidPlacement(rooms, rand, i, j, k, direction)) != null && this.hasIntersectingEntrances(previousRoom, room = new DungeonRoomStairs((Dungeon)this, roomNumber, (StructureComponent)previousRoom, rand, boundingBox, direction)) : chance >= 70 && (boundingBox = DungeonRoomChestPillar.findValidPlacement(rooms, rand, i, j, k, direction)) != null && this.hasIntersectingEntrances(previousRoom, room = new DungeonRoomChestPillar((Dungeon)this, roomNumber, (StructureComponent)previousRoom, rand, boundingBox, direction))))) {
            return room;
        }
        return null;
    }

    @Override
    public DungeonRoom getNextDungeonRoom(DungeonRoom previousRoom, List rooms, Random rand, int i, int j, int k, int direction, int roomNumber) {
        if (roomNumber > 5) {
            return null;
        }
        if (Math.abs(i - this.posX) <= 80 && Math.abs(k - this.posZ) <= 80) {
            DungeonRoom dungeonRoom = this.getRandomRoom(previousRoom, rooms, rand, i, j, k, direction, roomNumber + 1);
            if (dungeonRoom != null) {
                rooms.add(dungeonRoom);
            }
            return dungeonRoom;
        }
        return null;
    }

    @Override
    public String getDungeonName() {
        return "Slider's Labyrinth";
    }

    @Override
    public void generateStructure(World world, Random rand, StructureBoundingBox structureBoundingBox) {
        Iterator roomIter = this.rooms.iterator();
        while (roomIter.hasNext()) {
            DungeonRoom room = (DungeonRoom)((Object)roomIter.next());
            if (!room.func_74874_b().func_78884_a(structureBoundingBox) || room.func_74875_a(world, rand, structureBoundingBox)) continue;
            roomIter.remove();
        }
    }
}

