/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.dungeons;

import com.gildedgames.util.core.nbt.NBT;
import com.gildedgames.util.core.nbt.NBTFactory;
import com.gildedgames.util.io_manager.factory.IOFactory;
import com.gildedgames.util.io_manager.util.IOUtil;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.aetherteam.aether.Aether;
import net.aetherteam.aether.dungeons.Dungeon;
import net.aetherteam.aether.packets.AetherPacketHandler;
import net.aetherteam.aether.packets.PacketDungeonInfoRequest;
import net.minecraft.nbt.NBTTagCompound;

public class DungeonHandler
implements NBT {
    private final HashMap<Integer, Dungeon> instances = new HashMap();
    private final ArrayList<Integer> sentRequest = new ArrayList();
    private static DungeonHandler clientHandler = new DungeonHandler();
    private static DungeonHandler serverHandler = new DungeonHandler();

    public static void clear() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side.isClient()) {
            clientHandler = new DungeonHandler();
        } else {
            serverHandler = new DungeonHandler();
        }
    }

    public static DungeonHandler instance() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side.isClient()) {
            return clientHandler;
        }
        return serverHandler;
    }

    public void addInstance(Dungeon newDungeon, boolean saveData) {
        this.instances.put(newDungeon.dungeonId, newDungeon);
        if (saveData) {
            Aether.flushData();
        }
    }

    public Dungeon getDungeon(int dungeonId) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side.isClient()) {
            Dungeon dungeon = this.instances.get(dungeonId);
            if (dungeon == null && !this.sentRequest.contains(dungeonId)) {
                AetherPacketHandler.sendToServer(new PacketDungeonInfoRequest(dungeonId));
                this.sentRequest.add(dungeonId);
            }
            return dungeon;
        }
        return this.instances.get(dungeonId);
    }

    public Dungeon getDungeonAt(int x, int y, int z) {
        for (Dungeon dungeon : this.instances.values()) {
            if (!dungeon.boundingBox.func_78890_b(x, y, z)) continue;
            return dungeon;
        }
        return null;
    }

    public int getInstancesSize() {
        return this.instances.size();
    }

    public Collection<Dungeon> getInstances() {
        return this.instances.values();
    }

    private void setDungeons(List<Dungeon> dungeons) {
        for (Dungeon dungeon : dungeons) {
            this.addInstance(dungeon, false);
        }
    }

    public void write(NBTTagCompound output) {
        NBTFactory factory = new NBTFactory();
        IOUtil.setIOList((String)"dungeons", new ArrayList<Dungeon>(this.getInstances()), (IOFactory)factory, (Object)output);
    }

    public void read(NBTTagCompound input) {
        NBTFactory factory = new NBTFactory();
        List parties = IOUtil.getIOList((String)"dungeons", (IOFactory)factory, (Object)input);
        this.setDungeons(parties);
    }
}

