/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.dungeons;

import com.gildedgames.util.core.nbt.NBT;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.aetherteam.aether.Aether;
import net.aetherteam.aether.achievements.AetherAchievements;
import net.aetherteam.aether.blocks.AetherBlocks;
import net.aetherteam.aether.data.ByteDecoder;
import net.aetherteam.aether.data.ByteEncoder;
import net.aetherteam.aether.data.DungeonPosition;
import net.aetherteam.aether.data.EntityPosition;
import net.aetherteam.aether.dungeons.DungeonHandler;
import net.aetherteam.aether.dungeons.TeleporterDungeons;
import net.aetherteam.aether.dungeons.worldgen.StructureBoundingBoxSerial;
import net.aetherteam.aether.dungeons.worldgen.rooms.DungeonRoom;
import net.aetherteam.aether.dungeons.worldgen.rooms.DungeonRoomLabyrinthEntrance;
import net.aetherteam.aether.dungeons.worldgen.rooms.DungeonRoomSliderBoss;
import net.aetherteam.aether.packets.AetherPacket;
import net.aetherteam.aether.packets.AetherPacketHandler;
import net.aetherteam.aether.packets.PacketDungeonInfo;
import net.aetherteam.aether.player.PlayerAether;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.stats.StatBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public class Dungeon
implements NBT {
    public int posX;
    public int posZ;
    public LinkedList<DungeonRoom> rooms = new LinkedList();
    public int dungeonId;
    public StructureBoundingBoxSerial boundingBox = new StructureBoundingBoxSerial();
    private int keyFragments = 0;
    private final ArrayList<EntityPlayer> members = new ArrayList();
    private EntityPosition entrance = new EntityPosition();
    private DungeonPosition outsideEntrance;
    public boolean conquered;
    public boolean startTime;
    public int dungeonTime;

    public void generate(DungeonPosition outsideEntrance) {
        this.outsideEntrance = outsideEntrance;
        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(Aether.getDungeonDimensionID());
        this.generateRooms((World)world, world.field_73012_v, 0, 0);
        for (DungeonRoom dungeonRoom : this.rooms) {
            if (!(dungeonRoom instanceof DungeonRoomLabyrinthEntrance)) continue;
            this.entrance.x = dungeonRoom.func_74874_b().field_78897_a + 3;
            this.entrance.y = dungeonRoom.func_74874_b().field_78894_e - 4;
            this.entrance.z = dungeonRoom.func_74874_b().field_78896_c + 3;
            break;
        }
    }

    public void enter(EntityPlayerMP player) {
        this.members.add((EntityPlayer)player);
        this.startTime = true;
        PlayerAether playerInfo = PlayerAether.get((EntityPlayer)player);
        playerInfo.setCurrentDungeonId(this.dungeonId);
        playerInfo.setNonDungeonPos(new EntityPosition(player.field_70165_t, player.field_70163_u, player.field_70161_v));
        player.func_71029_a((StatBase)AetherAchievements.enterDungeonBronze);
        this.teleportPlayerToDungeons(player);
        this.movePlayerToEntrance(player);
    }

    public void leave(EntityPlayerMP player) {
        this.members.remove(player);
        this.teleportPlayerOutside(player, this.outsideEntrance.dimensionID);
        PlayerAether playerInfo = PlayerAether.get((EntityPlayer)player);
        EntityPosition nonDungeonPos = playerInfo.getNonDungeonPos();
        player.field_71135_a.func_147364_a((double)this.outsideEntrance.x + 2.0, (double)this.outsideEntrance.y + 2.0, (double)this.outsideEntrance.z + 2.0, 0.0f, 0.0f);
        Random rand = player.field_70170_p.field_73012_v;
        int x = MathHelper.func_76128_c((double)nonDungeonPos.x);
        int y = MathHelper.func_76128_c((double)nonDungeonPos.y);
        int z = MathHelper.func_76128_c((double)nonDungeonPos.z);
        boolean hasFoundLocation = false;
        block0: for (int i = 0; i < 20 && !hasFoundLocation; ++i) {
            x = MathHelper.func_76128_c((double)(nonDungeonPos.x + (double)(rand.nextInt(8) - 4)));
            z = MathHelper.func_76128_c((double)(nonDungeonPos.z + (double)(rand.nextInt(8) - 4)));
            for (int i2 = 0; i2 < 6; ++i2) {
                int y2 = y - i2;
                if (player.field_70170_p.func_147437_c(x, y2 - 1, z) || !player.field_70170_p.func_147437_c(x, y2, z) || !player.field_70170_p.func_147437_c(x, y2 + 1, z)) continue;
                y = y2;
                hasFoundLocation = true;
                continue block0;
            }
        }
        if (!hasFoundLocation) {
            y = player.field_70170_p.func_72825_h(x, z);
        }
        player.func_70107_b((double)x, (double)y, (double)z);
        playerInfo.setCurrentDungeonId(-1);
    }

    public void finish() {
        this.conquered = true;
        this.startTime = false;
        for (EntityPlayer player : this.members) {
            PlayerAether playerInfo = PlayerAether.get(player);
            playerInfo.addBannedEntrance(this.outsideEntrance);
        }
        this.sendPacketToMembers(new PacketDungeonInfo(this));
    }

    public void teleportPlayerToDungeons(EntityPlayerMP player) {
        TeleporterDungeons teleporter = new TeleporterDungeons(MinecraftServer.func_71276_C().func_71218_a(Aether.getDungeonDimensionID()));
        ServerConfigurationManager scm = MinecraftServer.func_71276_C().func_71203_ab();
        scm.transferPlayerToDimension(player, Aether.getDungeonDimensionID(), (Teleporter)teleporter);
        player.field_71088_bW = player.func_82147_ab();
    }

    public void teleportPlayerOutside(EntityPlayerMP player, int dimID) {
        TeleporterDungeons teleporter = new TeleporterDungeons(MinecraftServer.func_71276_C().func_71218_a(dimID));
        ServerConfigurationManager scm = MinecraftServer.func_71276_C().func_71203_ab();
        scm.transferPlayerToDimension(player, dimID, (Teleporter)teleporter);
        player.field_71088_bW = player.func_82147_ab();
    }

    public void movePlayerToEntrance(EntityPlayerMP player) {
        Aether.print("moving player to entrance");
        player.field_70165_t = this.entrance.x;
        player.field_70163_u = this.entrance.y;
        player.field_70161_v = this.entrance.z;
        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(Aether.getDungeonDimensionID());
        world.field_73059_b.func_73158_c((int)player.field_70165_t >> 4, (int)player.field_70161_v >> 4);
        player.field_71135_a.func_147364_a(this.entrance.x, this.entrance.y, this.entrance.z, 0.0f, 0.0f);
        Aether.print("moved played to entrance: " + Aether.getDungeonDimensionID() + " " + this.entrance.x + " " + this.entrance.y + " " + this.entrance.z);
    }

    public void sendPacketToMembers(AetherPacket packet) {
        for (EntityPlayer entityPlayer : this.members) {
            AetherPacketHandler.sendTo(packet, (EntityPlayerMP)entityPlayer);
        }
    }

    public void updateBoundingBox() {
        this.boundingBox = StructureBoundingBoxSerial.getNewBoundingBox();
        for (DungeonRoom component : this.rooms) {
            StructureBoundingBoxSerial serialBox = new StructureBoundingBoxSerial(component.func_74874_b());
            this.boundingBox.expandTo(serialBox);
        }
    }

    public void addKeyFragment() {
        ++this.keyFragments;
        this.sendPacketToMembers(new PacketDungeonInfo(this));
    }

    public void setKeyFragments(int keyFragments) {
        this.keyFragments = keyFragments;
        this.sendPacketToMembers(new PacketDungeonInfo(this));
    }

    public int getKeyFragments() {
        return this.keyFragments;
    }

    public void readData(ByteBuf dataInput) {
        this.dungeonId = dataInput.readInt();
        this.boundingBox.readData(dataInput);
        this.keyFragments = dataInput.readInt();
        this.conquered = dataInput.readBoolean();
    }

    public void writeData(ByteBuf dataOutput) {
        dataOutput.writeInt(this.dungeonId);
        this.boundingBox.writeData(dataOutput);
        dataOutput.writeInt(this.keyFragments);
        dataOutput.writeBoolean(this.conquered);
    }

    public void read(NBTTagCompound input) {
        this.dungeonId = input.func_74762_e("dungeonId");
        this.boundingBox = (StructureBoundingBoxSerial)ByteDecoder.decode(StructureBoundingBoxSerial.class, input.func_74770_j("boundingBox"));
        this.keyFragments = input.func_74762_e("keys");
        this.entrance = (EntityPosition)ByteDecoder.decode(EntityPosition.class, input.func_74770_j("entrance"));
        this.conquered = input.func_74767_n("conquered");
        this.outsideEntrance = (DungeonPosition)ByteDecoder.decode(DungeonPosition.class, input.func_74770_j("outsideEntrance"));
    }

    public void write(NBTTagCompound output) {
        output.func_74768_a("dungeonId", this.dungeonId);
        output.func_74773_a("boundingBox", ByteEncoder.encode(this.boundingBox));
        output.func_74768_a("keys", this.keyFragments);
        output.func_74773_a("entrance", ByteEncoder.encode(this.entrance));
        output.func_74757_a("conquered", this.conquered);
        output.func_74773_a("outsideEntrance", ByteEncoder.encode(this.outsideEntrance));
    }

    public void generateStructure(World world, Random rand, StructureBoundingBox structureBoundingBox) {
    }

    protected StructureComponent getRandomRoom(DungeonRoom previousRoom, List components, Random rand, int i, int j, int k, int direction, int componentNumber) {
        return null;
    }

    public int numberOfCertainRoom(List rooms, Class room) {
        Iterator compsIter = rooms.iterator();
        int max = 0;
        while (compsIter.hasNext()) {
            StructureComponent component = (StructureComponent)compsIter.next();
            if (!room.isInstance(component)) continue;
            ++max;
        }
        return max;
    }

    public boolean hasIntersectingEntrances(DungeonRoom room1, DungeonRoom room2) {
        for (StructureBoundingBox entrance1 : room1.entrances) {
            for (StructureBoundingBox entrance2 : room2.entrances) {
                StructureBoundingBox cube = this.findIntersectingCube(entrance1, entrance2);
                if (cube == null) continue;
                return true;
            }
        }
        return false;
    }

    public StructureBoundingBox findIntersectingCube(StructureBoundingBox box1, StructureBoundingBox box2) {
        int minX = Math.max(box1.field_78897_a, box2.field_78897_a);
        int minY = Math.max(box1.field_78895_b, box2.field_78895_b);
        int minZ = Math.max(box1.field_78896_c, box2.field_78896_c);
        int maxX = Math.min(box1.field_78893_d, box2.field_78893_d);
        int maxY = Math.min(box1.field_78894_e, box2.field_78894_e);
        int maxZ = Math.min(box1.field_78892_f, box2.field_78892_f);
        if (minX < maxX && minY < maxY && minZ < maxZ) {
            return new StructureBoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
        }
        return null;
    }

    public StructureComponent getNextDungeonRoom(DungeonRoom previousRoom, List rooms, Random rand, int i, int j, int k, int direction, int roomNumber) {
        return null;
    }

    public String getDungeonName() {
        return "";
    }

    public void createRooms(int x, int z, Random rand, int xOffset, int zOffset) {
        this.posX = (x << 4) + 2 + xOffset;
        this.posZ = (z << 4) + 2 + zOffset;
        DungeonRoomSliderBoss bossRoom = new DungeonRoomSliderBoss(this, 0, null, rand, xOffset, zOffset);
        this.rooms.add(bossRoom);
        bossRoom.buildComponent(this.rooms, rand);
        for (int numb = 1; numb < 8; ++numb) {
            List roomList = (List)this.rooms.clone();
            Iterator roomIter = roomList.iterator();
            do {
                DungeonRoom room;
                if ((room = (DungeonRoom)((Object)roomIter.next())).func_74877_c() != numb) continue;
                room.func_74861_a(room, this.rooms, rand);
            } while (roomIter.hasNext());
        }
        this.updateBoundingBox();
        this.dungeonId = DungeonHandler.instance().getInstancesSize();
    }

    protected void fillWithBlocks(World world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Block edgeBlockID, Block fillBlockID, boolean replaceBlocks) {
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!replaceBlocks && !world.func_147437_c(x, y, z) || y != minY && y != maxY && x != minX && x != maxX && z != minZ && z != maxZ) continue;
                    world.func_147449_b(x, y, z, edgeBlockID);
                }
            }
        }
    }

    public boolean generateRooms(World world, Random rand, int x, int z) {
        Collection<Dungeon> instances = DungeonHandler.instance().getInstances();
        int maxX = 0;
        for (Dungeon dungeon : instances) {
            if (dungeon.boundingBox.field_78893_d <= maxX) continue;
            maxX = dungeon.boundingBox.field_78893_d;
        }
        int xMaxOffset = maxX + 110;
        this.createRooms(x, z, rand, xMaxOffset, 0);
        DungeonHandler.instance().addInstance(this, true);
        int dungeonChunkLength = this.boundingBox.field_78892_f - this.boundingBox.field_78896_c >> 4;
        int dungeonChunkWidth = this.boundingBox.field_78893_d - this.boundingBox.field_78897_a >> 4;
        int chunkMinX = this.boundingBox.field_78897_a >> 4;
        int chunkMinZ = this.boundingBox.field_78896_c >> 4;
        boolean generatedRooms = false;
        for (int chunkX = chunkMinX - 2; chunkX <= chunkMinX + dungeonChunkWidth + 2; ++chunkX) {
            for (int chunkZ = chunkMinZ - 2; chunkZ <= chunkMinZ + dungeonChunkLength + 2; ++chunkZ) {
                MinecraftServer.func_71276_C().func_71218_a(Aether.getDungeonDimensionID()).func_72863_F().func_73158_c(chunkX, chunkZ);
                int posX = (chunkX << 4) + 8;
                int posZ = (chunkZ << 4) + 8;
                if (!this.boundingBox.func_78885_a(posX - 15, posZ - 15, posX + 31, posZ + 31)) continue;
                this.generateStructure(world, rand, new StructureBoundingBox(posX, posZ, posX + 15, posZ + 15));
                generatedRooms = true;
            }
        }
        this.fillWithBlocks(world, this.boundingBox.field_78897_a - 1, this.boundingBox.field_78895_b - 1, this.boundingBox.field_78896_c - 1, this.boundingBox.field_78893_d + 1, this.boundingBox.field_78894_e + 1, this.boundingBox.field_78892_f + 1, AetherBlocks.BloodMossHolystone, Blocks.field_150350_a, true);
        return generatedRooms;
    }

    public ArrayList<EntityPlayer> getMembers() {
        return this.members;
    }
}

