/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.data;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.aetherteam.aether.data.IEncodableByte;
import net.aetherteam.aether.player.PlayerAether;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public class ByteEncoder {
    public static byte[] encode(IEncodableByte object) {
        ByteBuf bytebuf = Unpooled.buffer();
        object.writeData(bytebuf);
        return bytebuf.array();
    }

    public static void encodeArrayList(ByteBuf dataOutput, Collection<? extends IEncodableByte> list) {
        dataOutput.writeInt(list.size());
        for (IEncodableByte iEncodableByte : list) {
            iEncodableByte.writeData(dataOutput);
        }
    }

    public static byte[] encodeArrayList(ArrayList<? extends IEncodableByte> list) {
        ByteBuf bytebuf = Unpooled.buffer();
        ByteEncoder.encodeArrayList(bytebuf, list);
        return bytebuf.array();
    }

    public static void encodeStringList(ByteBuf dataOutput, ArrayList<String> list) {
        dataOutput.writeInt(list.size());
        for (String object : list) {
            ByteBufUtils.writeUTF8String((ByteBuf)dataOutput, (String)object);
        }
    }

    public static void encodePlayerList(ByteBuf dataOutput, Collection<PlayerAether> list) {
        dataOutput.writeInt(list.size());
        for (PlayerAether player : list) {
            dataOutput.writeLong(player.getUniqueID().getMostSignificantBits());
            dataOutput.writeLong(player.getUniqueID().getLeastSignificantBits());
        }
    }

    public static void encodeItemStackArray(ByteBuf dataOutput, ItemStack ... stackArray) {
        dataOutput.writeInt(stackArray.length);
        for (ItemStack stack : stackArray) {
            PacketBuffer pb = new PacketBuffer(dataOutput);
            try {
                pb.func_150788_a(stack);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] encodeStringList(ArrayList<String> list) {
        ByteBuf bytebuf = Unpooled.buffer();
        ByteEncoder.encodeStringList(bytebuf, list);
        return bytebuf.array();
    }

    public static byte[] encodePlayerList(ArrayList<PlayerAether> list) {
        ByteBuf bytebuf = Unpooled.buffer();
        ByteEncoder.encodePlayerList(bytebuf, list);
        return bytebuf.array();
    }

    public static void encodeIntArray(ByteBuf dataOutput, int[] intArray) {
        dataOutput.writeInt(intArray.length);
        for (int element : intArray) {
            dataOutput.writeInt(element);
        }
    }

    public static void encodeStringIntMap(ByteBuf dataOutput, HashMap<String, Integer> map) {
        ArrayList<String> keys = new ArrayList<String>(map.size());
        int[] values = new int[map.size()];
        int i = 0;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            keys.add(entry.getKey());
            values[i] = entry.getValue();
            ++i;
        }
        ByteEncoder.encodeStringList(dataOutput, keys);
        ByteEncoder.encodeIntArray(dataOutput, values);
    }

    public static byte[] encodeStringIntMap(HashMap<String, Integer> map) {
        ByteBuf bytebuf = Unpooled.buffer();
        ByteEncoder.encodeStringIntMap(bytebuf, map);
        return bytebuf.array();
    }

    public static byte[] encodeIntMap(HashMap<? extends IEncodableByte, Integer> map) {
        ArrayList<IEncodableByte> keys = new ArrayList<IEncodableByte>(map.size());
        int[] values = new int[map.size()];
        int i = 0;
        for (Map.Entry<? extends IEncodableByte, Integer> entry : map.entrySet()) {
            keys.add(entry.getKey());
            values[i] = entry.getValue();
            ++i;
        }
        ByteBuf bytebuf = Unpooled.buffer();
        ByteEncoder.encodeArrayList(bytebuf, keys);
        ByteEncoder.encodeIntArray(bytebuf, values);
        return bytebuf.array();
    }

    public static void writeNBTTagCompound(NBTTagCompound par0NBTTagCompound, ByteBuf par1DataOutput) throws IOException {
        if (par0NBTTagCompound == null) {
            par1DataOutput.writeShort(-1);
        } else {
            byte[] abyte = CompressedStreamTools.func_74798_a((NBTTagCompound)par0NBTTagCompound);
            par1DataOutput.writeShort((int)((short)abyte.length));
            par1DataOutput.writeBytes(abyte);
        }
    }
}

