/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.blocks.util;

import net.aetherteam.aether.blocks.util.IRotatable;
import net.minecraft.world.World;

public enum Rotation {
    NORTH,
    EAST,
    SOUTH,
    WEST;


    public void rotate(World world, IRotatable rotatable, int x, int y, int z) {
        boolean clockwise;
        int rotationAmount = this.indexDifference(rotatable.getCurrentRotation(world, x, y, z));
        boolean bl = clockwise = rotationAmount > 0;
        if (rotationAmount == 3) {
            rotationAmount = 1;
            clockwise = false;
        } else if (rotationAmount == -3) {
            rotationAmount = 1;
            clockwise = true;
        }
        for (int count = 0; count < Math.abs(rotationAmount); ++count) {
            rotatable.rotate(world, clockwise, x, y, z);
        }
        rotatable.setCurrentRotation(world, this, x, y, z);
    }

    private int indexDifference(Rotation rotation) {
        return this.ordinal() - rotation.ordinal();
    }

    public Rotation getNextRotation(boolean clockwise) {
        int newIndex = this.ordinal() + (clockwise ? 1 : -1);
        if (newIndex < 0) {
            newIndex = Rotation.values().length - 1;
        } else if (newIndex == Rotation.values().length) {
            newIndex = 0;
        }
        return Rotation.values()[newIndex];
    }

    public Rotation getNextRotation(boolean clockwise, int rotationAmount) {
        Rotation rotation = null;
        for (int count = 0; count < rotationAmount; ++count) {
            rotation = this.getNextRotation(clockwise);
        }
        return rotation;
    }

    public static Rotation getRotation(int index) {
        return Rotation.values()[index];
    }
}

