/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.aetherteam.aether.Aether;
import net.aetherteam.aether.AetherConfig;
import net.aetherteam.aether.AetherLoot;
import net.aetherteam.aether.blocks.AetherBlocks;
import net.aetherteam.aether.blocks.BlockAetherPortal;
import net.aetherteam.aether.entities.projectile.EntityDaggerfrostSnowball;
import net.aetherteam.aether.entities.util.EntityMountable;
import net.aetherteam.aether.items.AetherItems;
import net.aetherteam.aether.items.ItemLeatherGloves;
import net.aetherteam.aether.items.ItemMouseEarCap;
import net.aetherteam.aether.items.ItemWrappingPaper;
import net.aetherteam.aether.items.itemblock.ItemBlockPresent;
import net.aetherteam.aether.items.weapons.ItemSkyrootSword;
import net.aetherteam.aether.player.PlayerAether;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemSnowball;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;

public class AetherEvents {
    private static final Random rand = new Random();
    private static final List<Byte> possibleColors = new ArrayList<Byte>();

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        PlayerAether player;
        ItemStack stack;
        int x = event.x;
        int y = event.y;
        int z = event.z;
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.entityPlayer.field_70170_p.func_147439_a(x, y, z) == Blocks.field_150383_bp) {
            int metadata;
            ItemStack stack2;
            EntityPlayer player2 = event.entityPlayer;
            World world = player2.field_70170_p;
            if (!world.field_72995_K && (stack2 = player2.field_71071_by.func_70448_g()) != null && (metadata = world.func_72805_g(x, y, z)) > 0) {
                if (stack2.func_77973_b() instanceof ItemLeatherGloves) {
                    ItemLeatherGloves itemarmor = (ItemLeatherGloves)stack2.func_77973_b();
                    itemarmor.removeColor(stack2);
                } else if (stack2.func_77973_b() instanceof ItemMouseEarCap) {
                    ItemMouseEarCap itemarmor = (ItemMouseEarCap)stack2.func_77973_b();
                    itemarmor.removeColor(stack2);
                } else {
                    return;
                }
                world.func_72921_c(x, y, z, metadata - 1, 2);
                world.func_147449_b(x, y, z, (Block)Blocks.field_150383_bp);
            }
        }
        if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
            Block block = event.entityPlayer.field_70170_p.func_147439_a(x, y, z);
            if (block == AetherBlocks.BloodMossHolystone) {
                event.setCanceled(true);
            } else {
                int x2 = x;
                int y2 = y;
                int z2 = z;
                switch (event.face) {
                    case 0: {
                        --y2;
                        break;
                    }
                    case 1: {
                        ++y2;
                        break;
                    }
                    case 2: {
                        --z2;
                        break;
                    }
                    case 3: {
                        ++z2;
                        break;
                    }
                    case 4: {
                        --x2;
                        break;
                    }
                    case 5: {
                        ++x2;
                    }
                }
                if (event.entityPlayer.field_70170_p.func_147439_a(x2, y2, z2) == AetherBlocks.ColdFire) {
                    event.world.func_72889_a(event.entityPlayer, 1004, x2, y2, z2, 0);
                    event.world.func_147468_f(x2, y2, z2);
                    event.setCanceled(true);
                }
            }
        }
        if ((stack = event.entityPlayer.func_71045_bC()) != null && stack.func_77973_b() instanceof ItemSnowball && (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR || event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) && (player = PlayerAether.get(event.entityPlayer)).getAccessoryCount(AetherItems.DaggerfrostLocket) >= 1 && !event.world.field_72995_K) {
            event.world.func_72838_d((Entity)new EntityDaggerfrostSnowball(event.world, (EntityLivingBase)event.entityPlayer));
            event.setCanceled(true);
            if (!event.entityPlayer.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        EntityPlayer player;
        if (event.target instanceof EntityCow && (player = event.entityPlayer).func_71045_bC() != null && player.func_71045_bC().func_77973_b() == AetherItems.SkyrootBucket) {
            if (player.func_71045_bC().field_77994_a == 1) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(AetherItems.SkyrootMilkBucket));
            } else if (!player.field_71071_by.func_70441_a(new ItemStack(AetherItems.SkyrootMilkBucket))) {
                if (!player.field_70170_p.field_72995_K) {
                    player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(AetherItems.SkyrootMilkBucket)));
                    if (!player.field_71075_bZ.field_75098_d) {
                        --player.func_71045_bC().field_77994_a;
                    }
                }
            } else if (!player.field_71075_bZ.field_75098_d) {
                --player.func_71045_bC().field_77994_a;
            }
        }
    }

    @SubscribeEvent
    public void onFillBucket(FillBucketEvent event) {
        int z;
        int y;
        int x;
        if (PlayerAether.get(event.entityPlayer).getDungeon() != null) {
            return;
        }
        if (event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && FluidContainerRegistry.isFilledContainer((ItemStack)event.current) && FluidContainerRegistry.getFluidForFilledItem((ItemStack)event.current).getFluidID() == FluidRegistry.LAVA.getID() && event.entityPlayer.field_71093_bK == Aether.getDimensionID()) {
            if (event.entityPlayer.field_71075_bZ.field_75098_d && event.entityPlayer.func_70093_af()) {
                return;
            }
            if (!event.entityPlayer.field_70170_p.field_72995_K) {
                x = event.target.field_72311_b;
                y = event.target.field_72312_c;
                z = event.target.field_72309_d;
                if (event.target.field_72310_e == 0) {
                    --y;
                } else if (event.target.field_72310_e == 1) {
                    ++y;
                } else if (event.target.field_72310_e == 2) {
                    --z;
                } else if (event.target.field_72310_e == 3) {
                    ++z;
                } else if (event.target.field_72310_e == 4) {
                    --x;
                } else if (event.target.field_72310_e == 5) {
                    ++x;
                }
                if (event.world.func_147437_c(x, y, z)) {
                    event.world.func_147449_b(x, y, z, AetherBlocks.Aerogel);
                    if (!event.entityPlayer.field_71075_bZ.field_75098_d) {
                        event.entityPlayer.field_71071_by.func_70299_a(event.entityPlayer.field_71071_by.field_70461_c, new ItemStack(Items.field_151133_ar));
                    }
                    event.setCanceled(true);
                }
            }
        }
        if (event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && FluidContainerRegistry.isFilledContainer((ItemStack)event.current) && FluidContainerRegistry.getFluidForFilledItem((ItemStack)event.current).getFluidID() == FluidRegistry.WATER.getID() && (event.entityPlayer.field_71093_bK == 0 || event.entityPlayer.field_71093_bK == Aether.getDimensionID())) {
            x = event.target.field_72311_b;
            y = event.target.field_72312_c;
            z = event.target.field_72309_d;
            int facedX = x;
            int facedY = y;
            int facedZ = z;
            if (event.target.field_72310_e == 0) {
                --facedY;
            } else if (event.target.field_72310_e == 1) {
                ++facedY;
            } else if (event.target.field_72310_e == 2) {
                --facedZ;
            } else if (event.target.field_72310_e == 3) {
                ++facedZ;
            } else if (event.target.field_72310_e == 4) {
                --facedX;
            } else if (event.target.field_72310_e == 5) {
                ++facedX;
            }
            if (event.entityPlayer.field_70170_p.func_147439_a(x, y, z) != Blocks.field_150426_aN) {
                return;
            }
            if (!event.entityPlayer.field_70170_p.func_147437_c(facedX, facedY, facedZ)) {
                return;
            }
            if (!event.entityPlayer.field_70170_p.field_72995_K && ((BlockAetherPortal)AetherBlocks.AetherPortal).func_150000_e(event.entityPlayer.field_70170_p, facedX, facedY, facedZ)) {
                if (!event.entityPlayer.field_71075_bZ.field_75098_d) {
                    if (event.current.func_77973_b() == AetherItems.SkyrootWaterBucket) {
                        event.entityPlayer.field_71071_by.func_70299_a(event.entityPlayer.field_71071_by.field_70461_c, new ItemStack(AetherItems.SkyrootBucket));
                    } else if (event.current.func_77973_b() == Items.field_151131_as) {
                        event.entityPlayer.field_71071_by.func_70299_a(event.entityPlayer.field_71071_by.field_70461_c, new ItemStack(Items.field_151133_ar));
                    }
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer && event.entity.field_70154_o != null && event.entity.field_70154_o instanceof EntityMountable) {
            EntityMountable mount = (EntityMountable)event.entity.field_70154_o;
            if (!event.entity.func_70093_af()) {
                if (event.entity.field_70173_aa % 20 == 0) {
                    mount.setRiderSneaking(false);
                }
            } else {
                mount.setRiderSneaking(true);
                event.entity.func_70095_a(false);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDropsEvent(LivingDropsEvent event) {
        if (event.source.func_76364_f() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.source.func_76364_f();
            this.trySkyrootRingLoot(event, event.entityLiving, player);
            this.trySkyrootDoubleLoot(event, event.entityLiving, player);
            this.tryDropPresent(event.entityLiving, player);
        }
    }

    private void trySkyrootRingLoot(LivingDropsEvent event, EntityLivingBase target, EntityPlayer player) {
        if (target instanceof EntityPlayer) {
            return;
        }
        if (target instanceof EntityHorse && ((EntityHorse)target).func_110261_ca()) {
            return;
        }
        PlayerAether hook = PlayerAether.get(player);
        int ringCount = hook.getAccessoryCount(AetherItems.SkyrootRing);
        if (ringCount > 0 && (float)player.func_70681_au().nextInt(10) < (float)ringCount * 1.5f) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (EntityItem item : event.drops) {
                if (ItemSkyrootSword.blacklistedItems.contains(item.func_92059_d().func_77973_b())) continue;
                stacks.add(item.func_92059_d());
            }
            for (ItemStack stack : stacks) {
                EntityItem item = new EntityItem(event.entityLiving.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, stack);
                event.entityLiving.field_70170_p.func_72838_d((Entity)item);
            }
        }
    }

    private void trySkyrootDoubleLoot(LivingDropsEvent event, EntityLivingBase target, EntityPlayer player) {
        if (target instanceof EntityPlayer) {
            return;
        }
        if (target instanceof EntityHorse && ((EntityHorse)target).func_110261_ca()) {
            return;
        }
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == AetherItems.SkyrootSword) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (EntityItem item : event.drops) {
                if (ItemSkyrootSword.blacklistedItems.contains(item.func_92059_d().func_77973_b())) continue;
                stacks.add(item.func_92059_d());
            }
            for (ItemStack stack : stacks) {
                EntityItem item = new EntityItem(event.entityLiving.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, stack);
                event.entityLiving.field_70170_p.func_72838_d((Entity)item);
            }
        }
    }

    private void tryDropPresent(EntityLivingBase entity, EntityPlayer player) {
        ItemStack stack;
        int chance;
        boolean isLucky;
        if (!(entity instanceof EntityMob)) {
            return;
        }
        PlayerAether aePlayer = PlayerAether.get(player);
        if (aePlayer == null) {
            return;
        }
        ItemStack neckgear = aePlayer.accessories.func_70301_a(0);
        boolean bl = isLucky = neckgear != null && neckgear.func_77973_b() == AetherItems.LuckyBell;
        int n = isLucky ? 20 : (chance = AetherConfig.EnableChristmasEvent ? 5 : 0);
        if (chance > 0 && entity.field_70170_p.field_73012_v.nextInt(100) <= chance && (stack = AetherLoot.CHRISTMAS_GIFT.getRandomItem(entity.field_70170_p.field_73012_v)) != null) {
            Collections.shuffle(possibleColors);
            ItemWrappingPaper.PresentDyeData dyeData = new ItemWrappingPaper.PresentDyeData();
            dyeData.setBowColor(possibleColors.get(0));
            dyeData.setBoxColor(possibleColors.get(1));
            ItemBlockPresent.PresentData data = new ItemBlockPresent.PresentData();
            data.setStack(stack);
            data.setDye(dyeData);
            ItemStack presentStack = new ItemStack(AetherBlocks.Present);
            presentStack.field_77990_d = new NBTTagCompound();
            data.writeToNBT(presentStack.field_77990_d);
            entity.func_70099_a(presentStack, 0.5f);
        }
    }

    static {
        for (byte i = 0; i < 15; i = (byte)(i + 1)) {
            possibleColors.add(i);
        }
    }
}

