/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.networking;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergyGridProvider;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.util.AECableType;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.parts.AEBasePart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class PartQuartzFiber
extends AEBasePart
implements IEnergyGridProvider {
    private final AENetworkProxy outerProxy = new AENetworkProxy(this, "outer", this.getProxy().getMachineRepresentation(), true);

    public PartQuartzFiber(ItemStack is) {
        super(is);
        this.getProxy().setIdlePowerUsage(0.0);
        this.getProxy().setFlags(GridFlags.CANNOT_CARRY);
        this.outerProxy.setIdlePowerUsage(0.0);
        this.outerProxy.setFlags(GridFlags.CANNOT_CARRY);
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.GLASS;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 10.0, 10.0, 10.0, 16.0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        GL11.glTranslated((double)-0.2, (double)-0.3, (double)0.0);
        rh.setTexture(this.getItemStack().func_77954_c());
        rh.setBounds(6.0f, 6.0f, 5.0f, 10.0f, 10.0f, 11.0f);
        rh.renderInventoryBox(renderer);
        rh.setTexture(null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        IIcon myIcon = this.getItemStack().func_77954_c();
        rh.setTexture(myIcon);
        rh.setBounds(6.0f, 6.0f, 10.0f, 10.0f, 10.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(null);
    }

    @Override
    public void readFromNBT(NBTTagCompound extra) {
        super.readFromNBT(extra);
        this.outerProxy.readFromNBT(extra);
    }

    @Override
    public void writeToNBT(NBTTagCompound extra) {
        super.writeToNBT(extra);
        this.outerProxy.writeToNBT(extra);
    }

    @Override
    public void removeFromWorld() {
        super.removeFromWorld();
        this.outerProxy.invalidate();
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.outerProxy.onReady();
    }

    @Override
    public void setPartHostInfo(ForgeDirection side, IPartHost host, TileEntity tile) {
        super.setPartHostInfo(side, host, tile);
        this.outerProxy.setValidSides(EnumSet.of(side));
    }

    @Override
    public IGridNode getExternalFacingNode() {
        return this.outerProxy.getNode();
    }

    @Override
    public int cableConnectionRenderTo() {
        return 16;
    }

    @Override
    public void onPlacement(EntityPlayer player, ItemStack held, ForgeDirection side) {
        super.onPlacement(player, held, side);
        this.outerProxy.setOwner(player);
    }

    @Override
    public double extractAEPower(double amt, Actionable mode, Set<IEnergyGrid> seen) {
        IEnergyGrid eg2;
        double acquiredPower = 0.0;
        try {
            eg2 = this.getProxy().getEnergy();
            acquiredPower += eg2.extractAEPower(amt - acquiredPower, mode, seen);
        }
        catch (GridAccessException eg2) {
            // empty catch block
        }
        try {
            eg2 = this.outerProxy.getEnergy();
            acquiredPower += eg2.extractAEPower(amt - acquiredPower, mode, seen);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return acquiredPower;
    }

    @Override
    public double injectAEPower(double amt, Actionable mode, Set<IEnergyGrid> seen) {
        IEnergyGrid eg2;
        try {
            eg2 = this.getProxy().getEnergy();
            if (!seen.contains(eg2)) {
                return eg2.injectAEPower(amt, mode, seen);
            }
        }
        catch (GridAccessException eg2) {
            // empty catch block
        }
        try {
            eg2 = this.outerProxy.getEnergy();
            if (!seen.contains(eg2)) {
                return eg2.injectAEPower(amt, mode, seen);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return amt;
    }

    @Override
    public double getEnergyDemand(double amt, Set<IEnergyGrid> seen) {
        IEnergyGrid eg2;
        double demand = 0.0;
        try {
            eg2 = this.getProxy().getEnergy();
            demand += eg2.getEnergyDemand(amt - demand, seen);
        }
        catch (GridAccessException eg2) {
            // empty catch block
        }
        try {
            eg2 = this.outerProxy.getEnergy();
            demand += eg2.getEnergyDemand(amt - demand, seen);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return demand;
    }
}

