/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.helpers;

import appeng.api.storage.data.IAEStack;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.LinkedList;

public class GenericInterestManager<T> {
    private final Multimap<IAEStack, T> container;
    private LinkedList<SavedTransactions> transactions = null;
    private int transDepth = 0;

    public GenericInterestManager(Multimap<IAEStack, T> interests) {
        this.container = interests;
    }

    public void enableTransactions() {
        if (this.transDepth == 0) {
            this.transactions = new LinkedList();
        }
        ++this.transDepth;
    }

    public void disableTransactions() {
        --this.transDepth;
        if (this.transDepth == 0) {
            LinkedList<SavedTransactions> myActions = this.transactions;
            this.transactions = null;
            for (SavedTransactions t : myActions) {
                if (t.put) {
                    this.put(t.stack, t.iw);
                    continue;
                }
                this.remove(t.stack, t.iw);
            }
        }
    }

    public boolean put(IAEStack stack, T iw) {
        if (this.transactions != null) {
            this.transactions.add(new SavedTransactions(true, stack, iw));
            return true;
        }
        return this.container.put((Object)stack, iw);
    }

    public boolean remove(IAEStack stack, T iw) {
        if (this.transactions != null) {
            this.transactions.add(new SavedTransactions(true, stack, iw));
            return true;
        }
        return this.container.remove((Object)stack, iw);
    }

    public boolean containsKey(IAEStack stack) {
        return this.container.containsKey((Object)stack);
    }

    public Collection<T> get(IAEStack stack) {
        return this.container.get((Object)stack);
    }

    private class SavedTransactions {
        private final boolean put;
        private final IAEStack stack;
        private final T iw;

        public SavedTransactions(boolean putOperation, IAEStack myStack, T watcher) {
            this.put = putOperation;
            this.stack = myStack;
            this.iw = watcher;
        }
    }
}

