/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules;

import appeng.api.AEApi;
import appeng.api.IAppEngApi;
import appeng.api.config.TunnelType;
import appeng.api.features.IP2PTunnelRegistry;
import appeng.api.parts.IPartHelper;
import appeng.integration.IIntegrationModule;
import appeng.integration.IntegrationHelper;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.parts.layers.LayerPressure;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.item.ItemStack;
import pneumaticCraft.api.block.BlockSupplier;
import pneumaticCraft.api.tileentity.AirHandlerSupplier;
import pneumaticCraft.api.tileentity.IAirHandler;
import pneumaticCraft.api.tileentity.ISidedPneumaticMachine;

public class PneumaticCraft
implements IIntegrationModule {
    public static PneumaticCraft instance;
    private static final String PNEUMATIC_CRAFT_MOD_ID = "PneumaticCraft";

    public PneumaticCraft() {
        IntegrationHelper.testClassExistence(this, BlockSupplier.class);
        IntegrationHelper.testClassExistence(this, ISidedPneumaticMachine.class);
        IntegrationHelper.testClassExistence(this, AirHandlerSupplier.class);
        IntegrationHelper.testClassExistence(this, IAirHandler.class);
    }

    @Override
    public void init() {
        IAppEngApi api = AEApi.instance();
        IPartHelper partHelper = api.partHelper();
        if (IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.PneumaticCraft)) {
            partHelper.registerNewLayer(LayerPressure.class.getName(), ISidedPneumaticMachine.class.getName());
        }
    }

    @Override
    public void postInit() {
        this.registerPressureAttunement("pressureTube");
        this.registerPressureAttunement("advancedPressureTube");
    }

    private void registerPressureAttunement(String itemID) {
        IP2PTunnelRegistry registry = AEApi.instance().registries().p2pTunnel();
        ItemStack modItem = GameRegistry.findItemStack((String)PNEUMATIC_CRAFT_MOD_ID, (String)itemID, (int)1);
        if (modItem != null) {
            modItem.func_77964_b(Short.MAX_VALUE);
            registry.addNewAttunement(modItem, TunnelType.PRESSURE);
        }
    }
}

