/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.api.definitions.IBlockDefinition;
import appeng.block.AEBaseItemBlockSlab;
import appeng.block.AEBaseSlabBlock;
import appeng.core.CreativeTab;
import appeng.core.features.AEFeature;
import appeng.core.features.ActivityState;
import appeng.core.features.BlockDefinition;
import appeng.core.features.FeatureNameExtractor;
import appeng.core.features.FeaturedActiveChecker;
import appeng.core.features.IFeatureHandler;
import com.google.common.base.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.EnumSet;
import net.minecraft.block.Block;

public class SlabBlockFeatureHandler
implements IFeatureHandler {
    private final AEBaseSlabBlock slabs;
    private final FeatureNameExtractor extractor;
    private final boolean enabled;
    private final BlockDefinition definition;

    public SlabBlockFeatureHandler(EnumSet<AEFeature> features, AEBaseSlabBlock slabs) {
        ActivityState state = new FeaturedActiveChecker(features).getActivityState();
        this.slabs = slabs;
        this.extractor = new FeatureNameExtractor(slabs.getClass(), (Optional<String>)Optional.absent());
        this.enabled = state == ActivityState.Enabled;
        this.definition = new BlockDefinition((Block)slabs, state);
    }

    @Override
    public final boolean isFeatureAvailable() {
        return this.enabled;
    }

    @Override
    public final IBlockDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public final void register() {
        if (this.enabled) {
            this.slabs.func_149647_a(CreativeTab.instance);
            GameRegistry.registerBlock((Block)this.slabs, AEBaseItemBlockSlab.class, (String)("tile." + this.slabs.name()), (Object[])new Object[]{this.slabs, this.slabs.doubleSlabs(), false});
            GameRegistry.registerBlock((Block)this.slabs.doubleSlabs(), AEBaseItemBlockSlab.class, (String)("tile." + this.slabs.name() + ".double"), (Object[])new Object[]{this.slabs, this.slabs.doubleSlabs(), true});
        }
    }
}

