/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.fluid;

import cofh.core.fluid.BlockFluidInteractive;
import cofh.lib.util.BlockWrapper;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.fluid.TFFluids;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;

public class BlockFluidPetrotheum
extends BlockFluidInteractive {
    Random random = new Random();
    public static final int LEVELS = 6;
    public static final Material materialFluidPetrotheum = new MaterialLiquid(MapColor.field_151665_m);
    private static boolean enableSourceFall = true;
    private static boolean effect = true;
    private static boolean extreme = false;

    public BlockFluidPetrotheum() {
        super("thermalfoundation", TFFluids.fluidPetrotheum, materialFluidPetrotheum, "petrotheum");
        this.setQuantaPerBlock(6);
        this.setTickRate(10);
        this.func_149711_c(1000.0f);
        this.func_149713_g(1);
        this.setParticleColor(0.4f, 0.3f, 0.2f);
    }

    public boolean preInit() {
        GameRegistry.registerBlock((Block)this, (String)"FluidPetrotheum");
        this.addInteraction(Blocks.field_150348_b, Blocks.field_150351_n);
        this.addInteraction(Blocks.field_150347_e, Blocks.field_150351_n);
        this.addInteraction(Blocks.field_150417_aV, Blocks.field_150351_n);
        this.addInteraction(Blocks.field_150341_Y, Blocks.field_150351_n);
        String string = "Fluid.Petrotheum";
        String string2 = "Enable this for Fluid Petrotheum to break apart stone blocks.";
        effect = ThermalFoundation.config.get(string, "Effect", effect, string2);
        string2 = "Enable this for Fluid Petrotheum to have an EXTREME effect on stone blocks.";
        extreme = ThermalFoundation.config.get(string, "Effect.Extreme", extreme, string2);
        string2 = "Enable this for Fluid Petrotheum Source blocks to gradually fall downwards.";
        enableSourceFall = ThermalFoundation.config.get(string, "Fall", enableSourceFall, string2);
        return true;
    }

    public void func_149670_a(World world, int n, int n2, int n3, Entity entity) {
        if (!effect) {
            return;
        }
        if (ServerHelper.isClientWorld((World)world)) {
            return;
        }
        if (world.func_82737_E() % 8L != 0L) {
            return;
        }
        if (world.func_82737_E() % 8L == 0L && entity instanceof EntityLivingBase && !((EntityLivingBase)entity).func_70662_br()) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76422_e.field_76415_H, 600, 2));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 600, 0));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 600, 1));
        }
    }

    public int getLightValue(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return TFFluids.fluidPetrotheum.getLuminosity();
    }

    public void func_149674_a(World world, int n, int n2, int n3, Random random) {
        if (effect) {
            this.checkForInteraction(world, n, n2, n3);
        }
        if (enableSourceFall && world.func_72805_g(n, n2, n3) == 0) {
            Block block = world.func_147439_a(n, n2 + ((BlockFluidBase)this).densityDir, n3);
            int n4 = world.func_72805_g(n, n2 + ((BlockFluidBase)this).densityDir, n3);
            if (block == this && n4 != 0) {
                world.func_147465_d(n, n2 + ((BlockFluidBase)this).densityDir, n3, (Block)this, 0, 3);
                world.func_147468_f(n, n2, n3);
                return;
            }
        }
        super.func_149674_a(world, n, n2, n3, random);
    }

    protected void checkForInteraction(World world, int n, int n2, int n3) {
        if (world.func_147439_a(n, n2, n3) != this) {
            return;
        }
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        for (int i = 2; i < 6; ++i) {
            n4 = n + BlockHelper.SIDE_COORD_MOD[i][0];
            n5 = n2 + BlockHelper.SIDE_COORD_MOD[i][1];
            n6 = n3 + BlockHelper.SIDE_COORD_MOD[i][2];
            this.interactWithBlock(world, n4, n5, n6);
        }
    }

    protected void interactWithBlock(World world, int n, int n2, int n3) {
        Block block = world.func_147439_a(n, n2, n3);
        if (block == Blocks.field_150350_a || block == this) {
            return;
        }
        int n4 = world.func_72805_g(n, n2, n3);
        if (extreme && block.func_149688_o() == Material.field_151576_e && block.func_149712_f(world, n, n2, n3) > 0.0f) {
            block.func_149697_b(world, n, n2, n3, n4, 0);
            world.func_147468_f(n, n2, n3);
            this.triggerInteractionEffects(world, n, n2, n3);
        } else if (this.hasInteraction(block, n4)) {
            BlockWrapper blockWrapper = this.getInteraction(block, n4);
            world.func_147465_d(n, n2, n3, blockWrapper.block, blockWrapper.metadata, 3);
        }
    }

    protected void triggerInteractionEffects(World world, int n, int n2, int n3) {
        world.func_72908_a((double)((float)n + 0.5f), (double)((float)n2 + 0.5f), (double)((float)n3 + 0.5f), "dig.stone", 0.5f, 0.9f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f);
    }
}

