/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.vec;

import cofh.repack.codechicken.lib.vec.Matrix4;
import cofh.repack.codechicken.lib.vec.Transformation;
import cofh.repack.codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.lwjgl.opengl.GL11;

public class Translation
extends Transformation {
    public Vector3 vec;

    public Translation(Vector3 vector3) {
        this.vec = vector3;
    }

    public Translation(double d, double d2, double d3) {
        this(new Vector3(d, d2, d3));
    }

    @Override
    public void apply(Vector3 vector3) {
        vector3.add(this.vec);
    }

    @Override
    public void applyN(Vector3 vector3) {
    }

    @Override
    public void apply(Matrix4 matrix4) {
        matrix4.translate(this.vec);
    }

    @Override
    public Transformation at(Vector3 vector3) {
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void glApply() {
        GL11.glTranslated((double)this.vec.x, (double)this.vec.y, (double)this.vec.z);
    }

    @Override
    public Transformation inverse() {
        return new Translation(-this.vec.x, -this.vec.y, -this.vec.z);
    }

    @Override
    public Transformation merge(Transformation transformation) {
        if (transformation instanceof Translation) {
            return new Translation(this.vec.copy().add(((Translation)transformation).vec));
        }
        return null;
    }

    @Override
    public boolean isRedundant() {
        return this.vec.equalsT(Vector3.zero);
    }

    public String toString() {
        MathContext mathContext = new MathContext(4, RoundingMode.HALF_UP);
        return "Translation(" + new BigDecimal(this.vec.x, mathContext) + ", " + new BigDecimal(this.vec.y, mathContext) + ", " + new BigDecimal(this.vec.z, mathContext) + ")";
    }
}

