/*
 * Decompiled with CFR 0.152.
 */
package cofh.mod.updater;

import cofh.core.CoFHProps;
import cofh.mod.updater.IUpdatableMod;
import cofh.mod.updater.ModVersion;
import cofh.mod.updater.UpdateCheckThread;
import com.google.common.base.Strings;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public final class UpdateManager {
    private static transient int pollOffset = 0;
    private static final ChatStyle description = new ChatStyle();
    private static final ChatStyle version = new ChatStyle();
    private static final ChatStyle modname = new ChatStyle();
    private static final ChatStyle download = new ChatStyle();
    private static final ChatStyle white = new ChatStyle();
    private boolean _notificationDisplayed;
    private final IUpdatableMod _mod;
    private final UpdateCheckThread _updateThread;
    private final String _downloadUrl;
    private int lastPoll = 400;

    public static void registerUpdater(UpdateManager updateManager) {
        FMLCommonHandler.instance().bus().register((Object)updateManager);
    }

    public UpdateManager(IUpdatableMod iUpdatableMod) {
        this(iUpdatableMod, null);
    }

    public UpdateManager(IUpdatableMod iUpdatableMod, String string) {
        this(iUpdatableMod, string, null);
    }

    public UpdateManager(IUpdatableMod iUpdatableMod, String string, String string2) {
        this._mod = iUpdatableMod;
        this._updateThread = new UpdateCheckThread(iUpdatableMod, string, string2);
        this._updateThread.start();
        this._downloadUrl = string2;
        this.lastPoll += (pollOffset += 140);
    }

    @SubscribeEvent
    public void tickStart(TickEvent.PlayerTickEvent playerTickEvent) {
        if (playerTickEvent.phase != TickEvent.Phase.START) {
            return;
        }
        if (MinecraftServer.func_71276_C() != null && MinecraftServer.func_71276_C().func_71278_l() && !MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(playerTickEvent.player.func_146103_bH())) {
            return;
        }
        if (this.lastPoll > 0) {
            --this.lastPoll;
            return;
        }
        this.lastPoll = 400;
        if (!this._notificationDisplayed && this._updateThread.checkComplete()) {
            this._notificationDisplayed = true;
            FMLCommonHandler.instance().bus().unregister((Object)this);
            if (this._updateThread.newVersionAvailable()) {
                if (!CoFHProps.enableUpdateNotice && !this._updateThread.isCriticalUpdate()) {
                    return;
                }
                ModVersion modVersion = this._updateThread.newVersion();
                EntityPlayer entityPlayer = playerTickEvent.player;
                ChatComponentText chatComponentText = new ChatComponentText("");
                ChatStyle chatStyle = modname.func_150232_l();
                IChatComponent iChatComponent = new ChatComponentText(modVersion.modVersion().toString()).func_150255_a(version);
                chatStyle.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, iChatComponent));
                chatComponentText.func_150257_a(new ChatComponentText("[" + this._mod.getModName() + "] ").func_150255_a(chatStyle));
                chatComponentText.func_150257_a(new ChatComponentTranslation("info.cofh.updater.version", new Object[0]).func_150255_a(white));
                chatComponentText.func_150258_a(EnumChatFormatting.GOLD + ":");
                entityPlayer.func_145747_a((IChatComponent)chatComponentText);
                chatComponentText = new ChatComponentText("");
                if (!Strings.isNullOrEmpty((String)this._downloadUrl)) {
                    chatComponentText.func_150258_a(EnumChatFormatting.WHITE + "[");
                    chatStyle = download.func_150232_l();
                    chatStyle.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, this._downloadUrl));
                    chatComponentText.func_150257_a(new ChatComponentTranslation("info.cofh.updater.download", new Object[0]).func_150255_a(chatStyle));
                    chatComponentText.func_150258_a(EnumChatFormatting.WHITE + "] ");
                }
                chatComponentText.func_150257_a(new ChatComponentText(modVersion.description()).func_150255_a(description));
                entityPlayer.func_145747_a((IChatComponent)chatComponentText);
            }
        }
    }

    static {
        description.func_150238_a(EnumChatFormatting.GRAY);
        version.func_150238_a(EnumChatFormatting.AQUA);
        modname.func_150238_a(EnumChatFormatting.GOLD);
        download.func_150238_a(EnumChatFormatting.GREEN);
        white.func_150238_a(EnumChatFormatting.WHITE);
        ChatStyle chatStyle = new ChatStyle();
        chatStyle.func_150238_a(EnumChatFormatting.YELLOW);
        IChatComponent iChatComponent = new ChatComponentTranslation("info.cofh.updater.tooltip", new Object[0]).func_150255_a(chatStyle);
        download.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, iChatComponent));
    }
}

