/*
 * Decompiled with CFR 0.152.
 */
package mca.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import mca.client.gui.GuiButtonPatreon;
import mca.core.MCA;
import mca.core.forge.EventHooksFML;
import mca.data.NBTPlayerData;
import mca.enums.EnumDestinyChoice;
import mca.packets.PacketDestinyChoice;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import radixcore.client.render.RenderHelper;
import radixcore.data.DataWatcherEx;
import radixcore.math.Point3D;
import radixcore.util.BlockHelper;
import radixcore.util.SchematicHandler;

@SideOnly(value=Side.CLIENT)
public class GuiSetup
extends GuiScreen {
    private static ResourceLocation setupLogo = new ResourceLocation("mca:textures/setup.png");
    private static String supportersURL = "http://pastebin.com/raw.php?i=VF4pMfZQ";
    private static List<String> supportersList = new ArrayList<String>();
    private EntityPlayer player;
    private NBTPlayerData data;
    private EnumDestinyChoice destinyChoice;
    private GuiTextField nameTextField;
    private int page;

    public GuiSetup(EntityPlayer player) {
        this.player = player;
        this.data = MCA.getPlayerData(player);
    }

    public void func_73866_w_() {
        DataWatcherEx.allowClientSideModification = true;
        Keyboard.enableRepeatEvents((boolean)true);
        this.page = 1;
        this.drawControls();
        if (supportersList.isEmpty()) {
            MCA.getLog().info("Downloading supporters list...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String input;
                        URL url = new URL(supportersURL);
                        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                        while ((input = in.readLine()) != null) {
                            supportersList.add(input);
                        }
                        MCA.getLog().info("Successfully downloaded supporters list.");
                    }
                    catch (Exception e) {
                        supportersList.add("Failed to download supporters list!");
                    }
                }
            }).start();
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.page == 3 && this.nameTextField != null) {
            this.nameTextField.func_146178_a();
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
    }

    public void func_73863_a(int sizeX, int sizeY, float offset) {
        if (this.page == 6) {
            this.func_146278_c(0);
        } else {
            this.func_146276_q_();
        }
        GL11.glPushMatrix();
        GL11.glScaled((double)0.55, (double)0.25, (double)1.0);
        RenderHelper.drawTexturedRectangle((ResourceLocation)setupLogo, (int)(this.field_146294_l / 2 + 62), (int)(this.field_146295_m / 2 - 120), (int)0, (int)0, (int)256, (int)256);
        GL11.glPopMatrix();
        if (this.page == 1) {
            this.func_73732_a(this.field_146289_q, "Are you a male, or a female?", this.field_146294_l / 2, 120, 0xFFFFFF);
        } else if (this.page == 2) {
            this.func_73732_a(this.field_146289_q, "Which do you prefer?", this.field_146294_l / 2, 120, 0xFFFFFF);
        } else if (this.page == 3 && this.nameTextField != null) {
            this.func_73732_a(this.field_146289_q, "What is your name?", this.field_146294_l / 2, 100, 0xFFFFFF);
            this.nameTextField.func_146194_f();
        } else if (this.page == 4) {
            this.func_73732_a(this.field_146289_q, "Choose your destiny...", this.field_146294_l / 2, 70, 0xFFFFFF);
        } else if (this.page == 5) {
            this.func_73732_a(this.field_146289_q, "WARNING: This destiny can potentially be destructive to your world.", this.field_146294_l / 2, 70, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, "This option works best on flat land with no other structures nearby. Continue?", this.field_146294_l / 2, 85, 0xFFFFFF);
        } else if (this.page == 6) {
            this.func_73732_a(this.field_146289_q, "Thank you to my amazing Patreon supporters!", this.field_146294_l / 2, 70, 0xFFFFFF);
            int i = 85;
            for (String s : supportersList) {
                this.func_73732_a(this.field_146289_q, "\u00a7A" + s, this.field_146294_l / 2, i, 0xFFFFFF);
                i += 15;
            }
        }
        super.func_73863_a(sizeX, sizeY, offset);
        this.drawControls();
    }

    public void func_146281_b() {
        try {
            SortedMap destinySchematic = SchematicHandler.readSchematic((String)"/assets/mca/schematic/destiny-test.schematic");
            for (Map.Entry entry : destinySchematic.entrySet()) {
                int y = MCA.destinyCenterPoint.iPosY + ((Point3D)entry.getKey()).iPosY;
                if (y <= (int)this.player.field_70163_u - 2) continue;
                BlockHelper.setBlock((World)this.player.field_70170_p, (int)(MCA.destinyCenterPoint.iPosX + ((Point3D)entry.getKey()).iPosX), (int)y, (int)(MCA.destinyCenterPoint.iPosZ + ((Point3D)entry.getKey()).iPosZ), (Block)Blocks.field_150350_a);
            }
        }
        catch (NullPointerException destinySchematic) {
            // empty catch block
        }
        EntityPlayerSP playerSP = (EntityPlayerSP)this.player;
        EventHooksFML.playPortalAnimation = true;
        playerSP.field_71086_bY = 6.0f;
        playerSP.field_71080_cy = 0.0f;
        DataWatcherEx.allowClientSideModification = false;
        MCA.destinySpawnFlag = false;
    }

    protected void func_73869_a(char c, int i) {
        if (this.page == 3 && this.nameTextField != null) {
            this.nameTextField.func_146201_a(c, i);
        }
    }

    protected void func_73864_a(int clickX, int clickY, int clicked) {
        super.func_73864_a(clickX, clickY, clicked);
        if (this.page == 3 && this.nameTextField != null) {
            this.nameTextField.func_146192_a(clickX, clickY, clicked);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == -1) {
            try {
                Desktop.getDesktop().browse(new URI("https://www.patreon.com/wildbamaboy"));
            }
            catch (Exception e) {
                return;
            }
        }
        switch (button.field_146127_k) {
            case -2: {
                this.page = 6;
                break;
            }
            case 0: {
                this.page = this.page == 6 ? 1 : this.page - 1;
                break;
            }
            case 1: 
            case 2: {
                this.page = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.page = 3;
                break;
            }
            case 6: {
                if (!MCA.getConfig().enableStructureSpawning) break;
                this.page = 4;
                break;
            }
            default: {
                this.page = 1;
            }
        }
        switch (button.field_146127_k) {
            case 1: {
                this.data.setIsMale(true);
                break;
            }
            case 2: {
                this.data.setIsMale(false);
                break;
            }
            case 3: {
                this.data.setGenderPreference(0);
                break;
            }
            case 4: {
                this.data.setGenderPreference(1);
                break;
            }
            case 5: {
                this.data.setGenderPreference(2);
                break;
            }
            case 6: {
                boolean isDedicatedServer;
                this.data.setMcaName(this.nameTextField.func_146179_b());
                boolean bl = isDedicatedServer = !Minecraft.func_71410_x().func_71387_A();
                if ((isDedicatedServer || MCA.getConfig().enableStructureSpawning) && (!isDedicatedServer || MCA.getConfig().serverEnableStructureSpawning)) break;
                this.setDestinyComplete();
                this.field_146297_k.func_147108_a(null);
                MCA.getPacketHandler().sendPacketToServer(new PacketDestinyChoice(EnumDestinyChoice.NONE));
                break;
            }
            case 7: {
                this.destinyChoice = EnumDestinyChoice.FAMILY;
                this.page = 5;
                break;
            }
            case 8: {
                this.destinyChoice = EnumDestinyChoice.ALONE;
                this.page = 5;
                break;
            }
            case 9: {
                this.destinyChoice = EnumDestinyChoice.VILLAGE;
                this.page = 5;
                break;
            }
            case 10: {
                this.data.setHasChosenDestiny(true);
                this.setDestinyComplete();
                this.field_146297_k.func_147108_a(null);
                MCA.getPacketHandler().sendPacketToServer(new PacketDestinyChoice(EnumDestinyChoice.NONE));
                break;
            }
            case 11: {
                this.data.setHasChosenDestiny(true);
                this.setDestinyComplete();
                this.field_146297_k.func_147108_a(null);
                MCA.getPacketHandler().sendPacketToServer(new PacketDestinyChoice(this.destinyChoice));
                break;
            }
            case 12: {
                this.page = 4;
                break;
            }
            case 13: {
                MCA.getPacketHandler().sendPacketToServer(new PacketDestinyChoice(EnumDestinyChoice.CANCEL));
                this.field_146297_k.func_147108_a(null);
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private void drawControls() {
        this.field_146292_n.clear();
        if (!MCA.getConfig().disablePatreonButton) {
            this.field_146292_n.add(new GuiButtonPatreon(-1, this.field_146294_l / 2 + 90, this.field_146295_m / 2 + 80));
        }
        if (this.page > 1) {
            this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 200, this.field_146295_m / 2 + 90, 65, 20, "Back"));
        }
        if (this.page == 1) {
            this.field_146292_n.add(new GuiButton(-2, this.field_146294_l / 2 - 200, this.field_146295_m / 2 + 90, 80, 20, "\u00a7ASupporters"));
            this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 - 65, this.field_146295_m / 2 + 10, 65, 20, "\u00a7BMale"));
            this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 + 2, this.field_146295_m / 2 + 10, 65, 20, "\u00a7DFemale"));
        } else if (this.page == 2) {
            this.field_146292_n.add(new GuiButton(3, this.field_146294_l / 2 - 97, this.field_146295_m / 2 + 10, 65, 20, "\u00a7BMales"));
            this.field_146292_n.add(new GuiButton(4, this.field_146294_l / 2 - 32, this.field_146295_m / 2 + 10, 65, 20, "\u00a7AEither"));
            this.field_146292_n.add(new GuiButton(5, this.field_146294_l / 2 + 33, this.field_146295_m / 2 + 10, 65, 20, "\u00a7DFemales"));
        } else if (this.page == 3) {
            if (this.nameTextField == null) {
                this.nameTextField = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 100, this.field_146295_m / 2 - 5, 200, 20);
                this.nameTextField.func_146180_a(this.player.func_70005_c_());
            }
            GuiButton doneButton = new GuiButton(6, this.field_146294_l / 2 - 32, this.field_146295_m / 2 + 30, 65, 20, MCA.getConfig().enableStructureSpawning ? "Continue" : "Done");
            doneButton.field_146124_l = !this.nameTextField.func_146179_b().trim().isEmpty();
            this.field_146292_n.add(doneButton);
        } else if (this.page == 4) {
            this.field_146292_n.add(new GuiButton(7, this.field_146294_l / 2 - 46, this.field_146295_m / 2 - 40, 95, 20, "I have a family."));
            this.field_146292_n.add(new GuiButton(8, this.field_146294_l / 2 - 46, this.field_146295_m / 2 - 20, 95, 20, "I live alone."));
            this.field_146292_n.add(new GuiButton(9, this.field_146294_l / 2 - 46, this.field_146295_m / 2 + 0, 95, 20, "I live in a village."));
            this.field_146292_n.add(new GuiButton(10, this.field_146294_l / 2 - 46, this.field_146295_m / 2 + 20, 95, 20, "None of these."));
        } else if (this.page == 5) {
            this.field_146292_n.add(new GuiButton(11, this.field_146294_l / 2 - 46, this.field_146295_m / 2 - 20, 95, 20, "Yes"));
            this.field_146292_n.add(new GuiButton(12, this.field_146294_l / 2 - 46, this.field_146295_m / 2 - 0, 95, 20, "No"));
            this.field_146292_n.add(new GuiButton(13, this.field_146294_l / 2 - 46, this.field_146295_m / 2 + 20, 95, 20, "Cancel"));
        }
    }

    private void setDestinyComplete() {
        NBTPlayerData data = MCA.getPlayerData(this.player);
        data.setHasChosenDestiny(true);
    }
}

