/*
 * Decompiled with CFR 0.152.
 */
package mca.ai;

import mca.ai.AbstractAI;
import mca.core.MCA;
import mca.data.PlayerMemory;
import mca.entity.EntityHuman;
import mca.enums.EnumPersonality;
import mca.enums.EnumProfessionGroup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.util.FakePlayer;
import radixcore.util.RadixMath;

public class AIRespondToAttack
extends AbstractAI {
    private String targetPlayerName;
    private Entity target;
    private boolean isRetaliating;

    public AIRespondToAttack(EntityHuman entityHuman) {
        super(entityHuman);
    }

    @Override
    public void onUpdateCommon() {
    }

    @Override
    public void onUpdateClient() {
    }

    @Override
    public void onUpdateServer() {
        if (!this.owner.getIsChild() && this.isRetaliating && this.owner.func_110143_aJ() > 0.0f && !this.owner.getIsInfected()) {
            if (this.target instanceof EntityPlayerMP && !this.target.func_70005_c_().equals("[CoFH]") && !(this.target instanceof FakePlayer)) {
                EntityPlayer targetPlayer = (EntityPlayer)this.target;
                if (targetPlayer != null) {
                    double distanceToPlayer = RadixMath.getDistanceToEntity((Entity)this.owner, (Entity)targetPlayer);
                    if (distanceToPlayer >= 10.0) {
                        this.owner.say("behavior.retaliate.distanced", targetPlayer);
                        this.reset();
                    } else if (this.playerHasWeapon(targetPlayer)) {
                        this.handlePlayerWithWeapon();
                    } else if (this.owner.func_70661_as().func_75500_f()) {
                        this.owner.func_70661_as().func_75497_a((Entity)targetPlayer, (double)0.7f);
                    } else if (distanceToPlayer <= 1.8) {
                        this.owner.func_71038_i();
                        targetPlayer.func_70097_a(DamageSource.field_76377_j, 1.0f);
                        this.reset();
                    }
                } else {
                    this.target = this.owner.field_70170_p.func_72924_a(this.targetPlayerName);
                    if (this.target == null) {
                        this.reset();
                    }
                }
            } else if (this.target != null) {
                double distanceToTarget = RadixMath.getDistanceToEntity((Entity)this.owner, (Entity)this.target);
                if (distanceToTarget >= 10.0) {
                    this.reset();
                } else if (this.owner.func_70661_as().func_75500_f()) {
                    this.owner.func_70661_as().func_75497_a(this.target, (double)0.7f);
                } else if (distanceToTarget <= 1.8) {
                    float attackDamage = this.owner.getProfessionGroup() == EnumProfessionGroup.Guard ? (float)MCA.getConfig().guardAttackDamage : (float)MCA.getConfig().villagerAttackDamage;
                    this.owner.func_71038_i();
                    this.target.func_70097_a(DamageSource.field_76377_j, attackDamage);
                    this.reset();
                }
            }
        }
    }

    @Override
    public void reset() {
        this.isRetaliating = false;
        this.targetPlayerName = null;
        this.owner.func_70661_as().func_75499_g();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
    }

    public void startResponse(Entity entity) {
        if (this.owner.getPersonality() == EnumPersonality.PEACEFUL) {
            return;
        }
        if (entity instanceof EntityPlayerMP && !entity.func_70005_c_().equals("[CoFH]") && !(entity instanceof FakePlayer)) {
            EntityPlayer player = (EntityPlayer)entity;
            this.target = player;
            if (this.playerHasWeapon(player)) {
                this.handlePlayerWithWeapon();
            } else {
                this.owner.say("behavior.retaliate.begin", player);
                this.isRetaliating = true;
                this.targetPlayerName = player.func_70005_c_();
                PlayerMemory memory = this.owner.getPlayerMemory(player);
                memory.setHearts(memory.getHearts() - 5);
            }
        } else {
            this.target = entity;
            this.isRetaliating = true;
        }
    }

    private boolean playerHasWeapon(EntityPlayer player) {
        ItemStack heldItem = player.field_71071_by.func_70448_g();
        if (heldItem != null) {
            return heldItem.func_77973_b() instanceof ItemSword || heldItem.func_77973_b() instanceof ItemBow;
        }
        return false;
    }

    private void handlePlayerWithWeapon() {
        try {
            this.owner.say("behavior.retaliate.weapondrawn", (EntityPlayer)this.target);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.reset();
    }

    public boolean getIsRetaliating() {
        return this.isRetaliating;
    }
}

