/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.transfernodes;

import com.rwtema.extrautils.tileentity.transfernodes.Frequency;
import com.rwtema.extrautils.tileentity.transfernodes.TileEntityTransferNode;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.INodeBuffer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class TransferNodeEnderRegistry {
    private static final HashMap<Frequency, List<WeakReference<INodeBuffer>>> receptors = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void clearTileRegistrations(INodeBuffer buffer) {
        HashMap<Frequency, List<WeakReference<INodeBuffer>>> hashMap = receptors;
        synchronized (hashMap) {
            HashSet<Frequency> t = null;
            for (Frequency fs : receptors.keySet()) {
                List<WeakReference<INodeBuffer>> list = receptors.get(fs);
                Iterator<WeakReference<INodeBuffer>> iter = list.iterator();
                while (iter.hasNext()) {
                    INodeBuffer next = (INodeBuffer)iter.next().get();
                    if (next != null && next != buffer) continue;
                    iter.remove();
                }
                if (!list.isEmpty()) continue;
                if (t == null) {
                    t = new HashSet<Frequency>();
                }
                t.add(fs);
            }
            if (t != null) {
                for (Frequency fs : t) {
                    receptors.remove(fs);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void registerTile(Frequency freq, INodeBuffer buffer) {
        HashMap<Frequency, List<WeakReference<INodeBuffer>>> hashMap = receptors;
        synchronized (hashMap) {
            TileEntityTransferNode a = buffer.getNode().getNode();
            for (Frequency fs : receptors.keySet()) {
                Iterator<WeakReference<INodeBuffer>> iter = receptors.get(fs).iterator();
                while (iter.hasNext()) {
                    INodeBuffer next = (INodeBuffer)iter.next().get();
                    if (next == null) {
                        iter.remove();
                        continue;
                    }
                    TileEntityTransferNode b = next.getNode().getNode();
                    if (a.field_145851_c != b.field_145851_c || a.field_145849_e != b.field_145849_e || a.field_145848_d != b.field_145848_d || a.func_145831_w().field_73011_w.field_76574_g != b.func_145831_w().field_73011_w.field_76574_g) continue;
                    return;
                }
            }
            List<WeakReference<INodeBuffer>> b = receptors.get(freq);
            if (b == null) {
                b = new ArrayList<WeakReference<INodeBuffer>>();
                receptors.put(freq, b);
            }
            b.add(new WeakReference<INodeBuffer>(buffer));
        }
    }

    public static synchronized void doTransfer(INodeBuffer sender, Frequency f, int no) {
        List<WeakReference<INodeBuffer>> b = receptors.get(f);
        if (b == null) {
            return;
        }
        Collections.shuffle(b);
        Iterator<WeakReference<INodeBuffer>> iterator = b.iterator();
        while (iterator.hasNext()) {
            WeakReference<INodeBuffer> ref = iterator.next();
            INodeBuffer reciever = (INodeBuffer)ref.get();
            if (reciever == null) {
                iterator.remove();
                continue;
            }
            if (reciever == sender) continue;
            sender.transferTo(reciever, no);
        }
    }
}

