/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.helper;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;

public class WeakList<E>
implements Iterable<E> {
    LinkedList<WeakReference<E>> list = new LinkedList();

    public boolean add(E a) {
        return a != null && this.list.add(new WeakReference<E>(a));
    }

    public void clear() {
        this.list.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return new WeakIterator();
    }

    public class WeakIterator
    implements Iterator<E> {
        E next = null;
        Iterator<WeakReference<E>> iter;

        public WeakIterator() {
            this.loadNext();
        }

        private void loadNext() {
            this.next = null;
            while (this.iter.hasNext()) {
                this.next = this.iter.next().get();
                if (this.next != null) {
                    return;
                }
                this.iter.remove();
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            Object e = this.next;
            this.loadNext();
            return e;
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }
}

