/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.gui;

import com.rwtema.extrautils.network.NetworkHandler;
import com.rwtema.extrautils.network.packets.PacketVillagerReturn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import org.lwjgl.opengl.GL11;

public class GuiTradingPost
extends GuiScreen {
    protected static RenderItem itemRenderer = new RenderItem();
    private static Comparator c = new VillagerSorter();
    protected int guiLeft = 0;
    protected int guiTop = 0;
    protected String screenTitle = "Trading Post";
    List<MerchantRecipe> merchant_recipes = new ArrayList<MerchantRecipe>();
    List<Integer> merchant_id = new ArrayList<Integer>();
    int item_size = 18;
    int space_between_items = 10;
    int button_width = this.item_size * 3 + this.space_between_items * 4;
    int button_height = 20;
    int w = this.button_width + this.space_between_items;
    int h = this.button_height + 5;
    int grid_w = 4;
    int grid_h = 5;
    int grid_no = this.grid_w * this.grid_h;
    int x0 = 0;
    int y0 = 20;
    int curPage = 0;
    int maxPages;
    TileEntity tradingPost;
    EntityPlayer player;
    private GuiButton[] buttons;
    private GuiButton leftButton;
    private GuiButton rightButton;

    public GuiTradingPost(EntityPlayer _player, int[] p1ids, MerchantRecipeList[] p2recipes, TileEntity _post) {
        this.tradingPost = _post;
        this.player = _player;
        ArrayList<Object[]> t = new ArrayList<Object[]>();
        for (int i = 0; i < p2recipes.length; ++i) {
            Entity e = _player.field_70170_p.func_73045_a(p1ids[i]);
            if (e == null) continue;
            for (int j = 0; j < p2recipes[i].size(); ++j) {
                t.add(new Object[]{e, p2recipes[i].get(j)});
            }
        }
        Collections.sort(t, c);
        int hash = -1;
        int j = 0;
        for (int i = 0; i < p2recipes.length; ++i) {
            MerchantRecipe m = (MerchantRecipe)((Object[])t.get(i))[1];
            int h = m.func_77395_g().hashCode();
            if (h == hash && i != 0) continue;
            hash = h;
            this.merchant_recipes.add(j, m);
            this.merchant_id.add(j, ((Entity)((Object[])t.get(i))[0]).func_145782_y());
            ++j;
        }
    }

    public static int getProf(Object a) {
        if (a instanceof EntityVillager) {
            return ((EntityVillager)a).func_70946_n();
        }
        return -1;
    }

    public void setPage(int page) {
        if (page < 0) {
            page = 0;
        }
        if (page >= this.maxPages) {
            page = this.maxPages - 1;
        }
        this.curPage = page;
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].field_146124_l = this.getRecipeForButton(i) < this.merchant_id.size() && !this.merchant_recipes.get(i).func_82784_g();
        }
    }

    public int getRecipeForButton(int i) {
        return this.curPage * this.grid_no + i;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        int h2 = (int)Math.ceil((double)this.field_146294_l / 1.5);
        this.grid_w = Math.min(this.field_146294_l / this.w, 4);
        this.grid_h = Math.min((h2 - 40) / this.h, 5);
        if (this.grid_h < 0) {
            this.grid_h = 1;
        }
        this.grid_no = this.grid_w * this.grid_h;
        this.buttons = new GuiButton[this.grid_no];
        this.maxPages = (int)Math.ceil((float)this.merchant_recipes.size() / (float)this.grid_no);
        this.x0 = (this.field_146294_l - this.grid_w * this.w) / 2;
        this.y0 = 80;
        this.leftButton = new GuiButton(0, this.field_146294_l / 2 - 100, 15, 20, 20, "<");
        this.field_146292_n.add(this.leftButton);
        this.rightButton = new GuiButton(1, this.field_146294_l / 2 + 80, 15, 20, 20, ">");
        this.field_146292_n.add(this.rightButton);
        this.leftButton.field_146124_l = this.maxPages > 1;
        this.rightButton.field_146124_l = this.maxPages > 1;
        String text = "";
        for (int i = 0; i < this.grid_no; ++i) {
            this.buttons[i] = new GuiButton(2 + i, this.x0 + i / this.grid_h * this.w, this.y0 + i % this.grid_h * this.h, this.button_width, this.button_height, text);
            if (i >= this.merchant_id.size()) {
                this.buttons[i].field_146124_l = false;
            }
            this.field_146292_n.add(this.buttons[i]);
        }
        this.setPage(0);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73876_c() {
        boolean flag = false;
        if (this.tradingPost == null) {
            flag = true;
        } else if (this.tradingPost.func_145831_w() == null) {
            flag = true;
        } else if (this.tradingPost.func_145831_w().func_147438_o(this.tradingPost.field_145851_c, this.tradingPost.field_145848_d, this.tradingPost.field_145849_e) != this.tradingPost) {
            flag = true;
        }
        if (flag) {
            this.field_146297_k.func_147108_a(null);
        }
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146124_l) {
            if (par1GuiButton.field_146127_k == 0) {
                this.setPage(this.curPage - 1);
            } else if (par1GuiButton.field_146127_k == 1) {
                this.setPage(this.curPage + 1);
            } else {
                int i = this.getRecipeForButton(par1GuiButton.field_146127_k - 2);
                NetworkHandler.sendPacketToServer(new PacketVillagerReturn(this.merchant_id.get(i), this.tradingPost.func_145831_w().field_73011_w.field_76574_g, this.tradingPost.field_145851_c, this.tradingPost.field_145848_d, this.tradingPost.field_145849_e));
                this.field_146297_k.func_147108_a(null);
            }
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        int y;
        int x;
        int j;
        int i;
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.screenTitle, this.field_146294_l / 2, 15, 0xFFFFFF);
        super.func_73863_a(par1, par2, par3);
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        GuiTradingPost.itemRenderer.field_77023_b = 100.0f;
        for (i = 0; i < this.buttons.length; ++i) {
            j = this.getRecipeForButton(i);
            if (j >= this.merchant_recipes.size()) continue;
            x = this.buttons[i].field_146128_h;
            y = this.buttons[i].field_146129_i;
            if (this.merchant_recipes.get(j).func_77396_b() != null) {
                itemRenderer.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, this.merchant_recipes.get(j).func_77394_a(), x + this.space_between_items, y + 2);
                itemRenderer.func_77021_b(this.field_146289_q, this.field_146297_k.field_71446_o, this.merchant_recipes.get(j).func_77394_a(), x + this.space_between_items, y + 2);
                itemRenderer.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, this.merchant_recipes.get(j).func_77396_b(), x + this.space_between_items * 2 + this.item_size, y + 2);
                itemRenderer.func_77021_b(this.field_146289_q, this.field_146297_k.field_71446_o, this.merchant_recipes.get(j).func_77396_b(), x + this.space_between_items * 2 + this.item_size, y + 2);
                itemRenderer.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, this.merchant_recipes.get(j).func_77397_d(), x + 3 * this.space_between_items + 2 * this.item_size, y + 2);
                itemRenderer.func_77021_b(this.field_146289_q, this.field_146297_k.field_71446_o, this.merchant_recipes.get(j).func_77397_d(), x + 3 * this.space_between_items + 2 * this.item_size, y + 2);
                continue;
            }
            itemRenderer.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, this.merchant_recipes.get(j).func_77394_a(), x + (this.item_size + this.space_between_items) / 2 + this.space_between_items, y + 2);
            itemRenderer.func_77021_b(this.field_146289_q, this.field_146297_k.field_71446_o, this.merchant_recipes.get(j).func_77394_a(), x + (this.item_size + this.space_between_items) / 2 + this.space_between_items, y + 2);
            itemRenderer.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, this.merchant_recipes.get(j).func_77397_d(), x + (this.item_size + this.space_between_items) / 2 + 2 * this.space_between_items + this.item_size, y + 2);
            itemRenderer.func_77021_b(this.field_146289_q, this.field_146297_k.field_71446_o, this.merchant_recipes.get(j).func_77397_d(), x + (this.item_size + this.space_between_items) / 2 + 2 * this.space_between_items + this.item_size, y + 2);
        }
        GuiTradingPost.itemRenderer.field_77023_b = 0.0f;
        GL11.glDisable((int)2896);
        for (i = 0; i < this.buttons.length; ++i) {
            j = this.getRecipeForButton(i);
            if (j >= this.merchant_recipes.size()) continue;
            x = this.buttons[i].field_146128_h;
            y = this.buttons[i].field_146129_i;
            if (this.merchant_recipes.get(j).func_77396_b() != null) {
                this.func_73732_a(this.field_146289_q, "+", x + this.space_between_items * 3 / 2 + this.item_size, y + 7, 0xFFFFFF);
                this.func_73732_a(this.field_146289_q, "=", x + this.space_between_items * 5 / 2 + 2 * this.item_size, y + 7, 0xFFFFFF);
                continue;
            }
            this.func_73732_a(this.field_146289_q, "=", x + this.button_width / 2, y + 7, 0xFFFFFF);
        }
        for (i = 0; i < this.buttons.length; ++i) {
            j = this.getRecipeForButton(i);
            if (j >= this.merchant_recipes.size()) continue;
            x = this.buttons[i].field_146128_h;
            y = this.buttons[i].field_146129_i;
            if (this.merchant_recipes.get(j).func_77396_b() != null) {
                if (this.func_146978_c(x + this.space_between_items, y, this.item_size, this.item_size, par1, par2)) {
                    this.drawItemStackTooltip(this.merchant_recipes.get(j).func_77394_a(), par1, par2);
                }
                if (this.func_146978_c(x + this.space_between_items * 2 + this.item_size, y, this.item_size, this.item_size, par1, par2)) {
                    this.drawItemStackTooltip(this.merchant_recipes.get(j).func_77396_b(), par1, par2);
                }
                if (!this.func_146978_c(x + 3 * this.space_between_items + 2 * this.item_size, y, this.item_size, this.item_size, par1, par2)) continue;
                this.drawItemStackTooltip(this.merchant_recipes.get(j).func_77397_d(), par1, par2);
                continue;
            }
            if (this.func_146978_c(x + (this.item_size + this.space_between_items) / 2 + this.space_between_items, y, this.item_size, this.item_size, par1, par2)) {
                this.drawItemStackTooltip(this.merchant_recipes.get(j).func_77394_a(), par1, par2);
            }
            if (!this.func_146978_c(x + (this.item_size + this.space_between_items) / 2 + 2 * this.space_between_items + this.item_size, y, this.item_size, this.item_size, par1, par2)) continue;
            this.drawItemStackTooltip(this.merchant_recipes.get(j).func_77397_d(), par1, par2);
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
    }

    protected void drawItemStackTooltip(ItemStack par1ItemStack, int par2, int par3) {
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        List list = par1ItemStack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
        if (!list.isEmpty()) {
            int i1;
            int l;
            int k = 0;
            for (l = 0; l < list.size(); ++l) {
                i1 = this.field_146289_q.func_78256_a((String)list.get(l));
                if (i1 <= k) continue;
                k = i1;
            }
            l = par2 + 12;
            i1 = par3 - 12;
            int j1 = 8;
            if (list.size() > 1) {
                j1 += 2 + (list.size() - 1) * 10;
            }
            this.field_73735_i = 300.0f;
            GuiTradingPost.itemRenderer.field_77023_b = 300.0f;
            int k1 = -267386864;
            this.func_73733_a(l - 3, i1 - 4, l + k + 3, i1 - 3, k1, k1);
            this.func_73733_a(l - 3, i1 + j1 + 3, l + k + 3, i1 + j1 + 4, k1, k1);
            this.func_73733_a(l - 3, i1 - 3, l + k + 3, i1 + j1 + 3, k1, k1);
            this.func_73733_a(l - 4, i1 - 3, l - 3, i1 + j1 + 3, k1, k1);
            this.func_73733_a(l + k + 3, i1 - 3, l + k + 4, i1 + j1 + 3, k1, k1);
            int l1 = 0x505000FF;
            int i2 = (l1 & 0xFEFEFE) >> 1 | l1 & 0xFF000000;
            this.func_73733_a(l - 3, i1 - 3 + 1, l - 3 + 1, i1 + j1 + 3 - 1, l1, i2);
            this.func_73733_a(l + k + 2, i1 - 3 + 1, l + k + 3, i1 + j1 + 3 - 1, l1, i2);
            this.func_73733_a(l - 3, i1 - 3, l + k + 3, i1 - 3 + 1, l1, l1);
            this.func_73733_a(l - 3, i1 + j1 + 2, l + k + 3, i1 + j1 + 3, i2, i2);
            for (int j2 = 0; j2 < list.size(); ++j2) {
                String s = (String)list.get(j2);
                s = j2 == 0 ? par1ItemStack.func_77953_t().field_77937_e + s : EnumChatFormatting.GRAY + s;
                this.field_146289_q.func_78261_a(s, l, i1, -1);
                if (j2 == 0) {
                    i1 += 2;
                }
                i1 += 10;
            }
            this.field_73735_i = 0.0f;
            GuiTradingPost.itemRenderer.field_77023_b = 0.0f;
        }
    }

    private void drawLine(double x1, double x2, double y1, double y2, int col) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(1);
        tessellator.func_78378_d(col);
        tessellator.func_78377_a(x1, y1, (double)this.field_73735_i);
        tessellator.func_78377_a(x2, y2, (double)this.field_73735_i);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    protected boolean func_146978_c(int par1, int par2, int par3, int par4, int par5, int par6) {
        int k1 = this.guiTop;
        int l1 = this.guiLeft;
        return (par5 -= k1) >= par1 - 1 && par5 < par1 + par3 + 1 && (par6 -= l1) >= par2 - 1 && par6 < par2 + par4 + 1;
    }

    public static class VillagerSorter
    implements Comparator {
        public int intCompare(int a, int b) {
            if (a == b) {
                return 0;
            }
            if (a > b) {
                return 1;
            }
            return -1;
        }

        public int itemCompare(Item a, Item b) {
            return a.func_77658_a().compareTo(b.func_77658_a());
        }

        public int compare(Object arg0, Object arg1) {
            int i = this.intCompare(GuiTradingPost.getProf(((Object[])arg0)[0]), GuiTradingPost.getProf(((Object[])arg0)[0]));
            if (i == 0) {
                MerchantRecipe m1 = (MerchantRecipe)((Object[])arg0)[1];
                MerchantRecipe m2 = (MerchantRecipe)((Object[])arg1)[1];
                int i2 = this.itemCompare(m1.func_77394_a().func_77973_b(), m2.func_77394_a().func_77973_b());
                if (i2 == 0) {
                    int i3 = this.intCompare(m1.func_77394_a().field_77994_a, m2.func_77394_a().field_77994_a);
                    if (i3 == 0) {
                        int i4 = this.itemCompare(m1.func_77397_d().func_77973_b(), m2.func_77397_d().func_77973_b());
                        if (i4 == 0) {
                            int i5 = this.intCompare(m1.func_77397_d().field_77994_a, m2.func_77397_d().field_77994_a);
                            if (i5 == 0) {
                                return this.intCompare(m1.func_77395_g().hashCode(), m2.func_77395_g().hashCode());
                            }
                            return i5;
                        }
                        return i4;
                    }
                    return i3;
                }
                return i2;
            }
            return i;
        }
    }
}

