/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.avaritia.compat.botania.alfheim;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;

public class Ruin {
    public BlockArray blocks;
    public double ruinLevel;
    public Random rand;
    public BlockRuinPalette palette;
    public int xSize;
    public int ySize;
    public int zSize;
    public int xOffset;
    public int yOffset;
    public int zOffset;

    public Ruin(BlockArray blocks, double ruinLevel, Random rand) {
        this(blocks, ruinLevel, rand, new BlockRuinPalette());
    }

    public Ruin(BlockArray blocks, double ruinLevel, Random rand, BlockRuinPalette palette) {
        this(blocks, ruinLevel, rand, blocks.xSize, blocks.ySize, blocks.zSize, 0, 0, 0, palette);
    }

    public Ruin(BlockArray blocks, double ruinLevel, Random rand, int xSize, int ySize, int zSize, int xOffset, int yOffset, int zOffset) {
        this(blocks, ruinLevel, rand, xSize, ySize, zSize, xOffset, yOffset, zOffset, new BlockRuinPalette());
    }

    public Ruin(BlockArray blocks, double ruinLevel, Random rand, int xSize, int ySize, int zSize, int xOffset, int yOffset, int zOffset, BlockRuinPalette palette) {
        this.blocks = blocks;
        this.ruinLevel = ruinLevel;
        this.rand = rand;
        this.palette = palette;
        this.xSize = xSize;
        this.ySize = ySize;
        this.zSize = zSize;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
        int volume = this.xSize * this.ySize * this.zSize;
        int breaks = (int)Math.ceil((double)volume / 16.0 * ruinLevel);
        for (int i = 0; i < breaks; ++i) {
            int x = rand.nextInt(this.xSize) - this.xOffset;
            int z = rand.nextInt(this.zSize) - this.zOffset;
            double ylevel = 1.0 - rand.nextDouble() * rand.nextDouble();
            int y = (int)Math.round(ylevel * (double)this.ySize) - this.yOffset;
            double rad = (6.0 * rand.nextDouble() + 1.0) * ylevel * (0.1 + 0.9 * ruinLevel) + 0.45 + 0.55 * ruinLevel;
            this.ruinArea(x, y, z, rad);
        }
        this.disconnectionCheck();
        this.disconnectionCheck();
    }

    protected void dropBlock(int ox, int oy, int oz) {
        this.dropBlock(ox, oy, oz, 0);
    }

    protected void dropBlock(int ox, int oy, int oz, int initialdistance) {
        block15: {
            int x = ox;
            int y = oy;
            int z = oz;
            BlockMeta block = this.blocks.getBlock(x, y, z);
            if (block == null) {
                return;
            }
            this.blocks.setBlock(ox, oy, oz, null);
            int falldistance = initialdistance;
            while (true) {
                BlockMeta below = this.blocks.getBlock(x, y - 1, z);
                if (this.blocks.outOfBounds(x, y - 1, z)) {
                    this.blocks.setBlock(x, y, z, block);
                    break block15;
                }
                if (below == null) {
                    --y;
                    ++falldistance;
                    continue;
                }
                boolean slide = false;
                int slidedir = 0;
                ArrayList<Integer> falldirs = new ArrayList<Integer>();
                if (!this.blocks.outOfBounds(x - 1, y, z) && this.blocks.getBlock(x - 1, y, z) == null && this.blocks.getBlock(x - 1, y - 1, z) == null) {
                    falldirs.add(0);
                }
                if (!this.blocks.outOfBounds(x + 1, y, z) && this.blocks.getBlock(x + 1, y, z) == null && this.blocks.getBlock(x + 1, y - 1, z) == null) {
                    falldirs.add(1);
                }
                if (!this.blocks.outOfBounds(x, y, z - 1) && this.blocks.getBlock(x, y, z - 1) == null && this.blocks.getBlock(x, y - 1, z - 1) == null) {
                    falldirs.add(2);
                }
                if (!this.blocks.outOfBounds(x, y, z + 1) && this.blocks.getBlock(x, y, z + 1) == null && this.blocks.getBlock(x, y - 1, z + 1) == null) {
                    falldirs.add(3);
                }
                if (!falldirs.isEmpty()) {
                    slide = true;
                    slidedir = (Integer)falldirs.get(this.rand.nextInt(falldirs.size()));
                }
                if (!slide) break;
                this.impact(x, y - 1, z, falldistance / 4, block);
                if (slidedir == 0) {
                    --x;
                    continue;
                }
                if (slidedir == 1) {
                    ++x;
                    continue;
                }
                if (slidedir == 2) {
                    --z;
                    continue;
                }
                ++z;
            }
            BlockRuinPalette.BlockPaletteInfo blockinfo = this.palette.get(block);
            double breakchance = this.fallBreakChance(falldistance) * blockinfo.breakchance;
            if (this.rand.nextDouble() <= breakchance) {
                this.blocks.setBlock(x, y, z, blockinfo.broken);
            } else if (blockinfo.hardness >= 1.0) {
                this.blocks.setBlock(x, y, z, block);
            }
            this.impact(x, y - 1, z, falldistance, block);
        }
    }

    protected void impact(int x, int y, int z, int falldistance, BlockMeta fallingblock) {
        BlockMeta block = this.blocks.getBlock(x, y, z);
        BlockRuinPalette.BlockPaletteInfo blockinfo = this.palette.get(block);
        double smashchance = this.fallBreakChance(falldistance) * blockinfo.smashchance;
        if (this.rand.nextDouble() <= smashchance) {
            this.blocks.setBlock(x, y, z, null);
            this.dropBlock(x, y + 1, z, falldistance / 3);
        }
        double breakchance = this.fallBreakChance(falldistance) * blockinfo.breakchance;
        if (this.blocks.getBlock(x, y - 1, z) != null) {
            breakchance *= 0.75;
        }
        if (this.rand.nextDouble() <= breakchance) {
            if (blockinfo.broken != null) {
                this.blocks.setBlock(x, y, z, blockinfo.broken);
                this.impact(x, y, z, falldistance / 2, fallingblock);
            } else {
                this.dropBlock(x, y, z);
                this.dropBlock(x, y + 1, z, falldistance / 3);
            }
        }
    }

    protected void ruinArea(int ox, int oy, int oz, double radius) {
        int range = (int)Math.ceil(radius * 2.0);
        int offset = range / 2;
        for (int y = 0; y <= range; ++y) {
            ArrayList<Coord> coords = new ArrayList<Coord>();
            for (int x = 0; x <= range; ++x) {
                if (x < 0 || x >= this.blocks.xSize) continue;
                for (int z = 0; z <= range; ++z) {
                    BlockMeta block;
                    if (z < 0 || z >= this.blocks.zSize || (block = this.blocks.getBlock(ox + x - offset, oy + y - offset, oz + z - offset)) == null) continue;
                    BlockRuinPalette.BlockPaletteInfo blockinfo = this.palette.get(block);
                    double rx = x - range / 2;
                    double ry = y - range / 2;
                    double rz = z - range / 2;
                    double dist = Math.sqrt(rx * rx + ry * ry + rz * rz) / radius;
                    if (!(dist <= 1.0)) continue;
                    if (dist > 0.75) {
                        double dchance = (dist - 0.75) * 4.0;
                        if (this.rand.nextDouble() > dchance) {
                            coords.add(new Coord(x, y, z));
                            continue;
                        }
                        if (blockinfo.broken == null && !(blockinfo.hardness < 1.0)) continue;
                        this.blocks.setBlock(ox + x - offset, oy + y - offset, oz + z - offset, blockinfo.broken);
                        continue;
                    }
                    coords.add(new Coord(x, y, z));
                }
            }
            Collections.shuffle(coords, this.rand);
            for (int i = 0; i < coords.size(); ++i) {
                Coord c = (Coord)coords.get(i);
                this.dropBlock(ox + c.x - range / 2, oy + c.y - range / 2, oz + c.z - range / 2);
            }
        }
    }

    protected void disconnectionCheck() {
        int ox = this.blocks.xSize / 2;
        int oz = this.blocks.zSize / 2;
        boolean[] connected = new boolean[this.blocks.length];
        ArrayList<Coord> open = new ArrayList<Coord>();
        open.add(new Coord(ox, 0, oz));
        while (!open.isEmpty()) {
            Coord c = (Coord)open.remove(open.size() - 1);
            if (this.blocks.outOfBounds(c.x, c.y, c.z) || this.blocks.getBlock(c.x, c.y, c.z) == null) continue;
            connected[this.blocks.index((int)c.x, (int)c.y, (int)c.z)] = true;
            if (!this.blocks.outOfBounds(c.x - 1, c.y, c.z) && this.blocks.getBlock(c.x - 1, c.y, c.z) != null && !connected[this.blocks.index(c.x - 1, c.y, c.z)]) {
                open.add(new Coord(c.x - 1, c.y, c.z));
            }
            if (!this.blocks.outOfBounds(c.x + 1, c.y, c.z) && this.blocks.getBlock(c.x + 1, c.y, c.z) != null && !connected[this.blocks.index(c.x + 1, c.y, c.z)]) {
                open.add(new Coord(c.x + 1, c.y, c.z));
            }
            if (!this.blocks.outOfBounds(c.x, c.y, c.z - 1) && this.blocks.getBlock(c.x, c.y, c.z - 1) != null && !connected[this.blocks.index(c.x, c.y, c.z - 1)]) {
                open.add(new Coord(c.x, c.y, c.z - 1));
            }
            if (!this.blocks.outOfBounds(c.x, c.y, c.z + 1) && this.blocks.getBlock(c.x, c.y, c.z + 1) != null && !connected[this.blocks.index(c.x, c.y, c.z + 1)]) {
                open.add(new Coord(c.x, c.y, c.z + 1));
            }
            if (!this.blocks.outOfBounds(c.x, c.y - 1, c.z) && this.blocks.getBlock(c.x, c.y - 1, c.z) != null && !connected[this.blocks.index(c.x, c.y - 1, c.z)]) {
                open.add(new Coord(c.x, c.y - 1, c.z));
            }
            if (this.blocks.outOfBounds(c.x, c.y + 1, c.z) || this.blocks.getBlock(c.x, c.y + 1, c.z) == null || connected[this.blocks.index(c.x, c.y + 1, c.z)]) continue;
            open.add(new Coord(c.x, c.y + 1, c.z));
        }
        for (int y = 0; y <= this.blocks.ySize; ++y) {
            ArrayList<Coord> coords = new ArrayList<Coord>();
            for (int x = 0; x <= this.blocks.xSize; ++x) {
                for (int z = 0; z <= this.blocks.zSize; ++z) {
                    if (this.blocks.getBlock(x, y, z) == null || connected[this.blocks.index(x, y, z)]) continue;
                    coords.add(new Coord(x, y, z));
                }
            }
            Collections.shuffle(coords, this.rand);
            for (int i = 0; i < coords.size(); ++i) {
                Coord c = (Coord)coords.get(i);
                this.dropBlock(c.x, c.y, c.z);
            }
        }
    }

    protected double fallBreakChance(int distance) {
        double maxdist = 2.0;
        return Math.min((double)distance, maxdist) / maxdist;
    }

    protected static class Coord {
        int x;
        int y;
        int z;

        public Coord(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    public static class BlockRuinPalette {
        protected Map<BlockMeta, BlockPaletteInfo> infomap = new HashMap<BlockMeta, BlockPaletteInfo>();

        public BlockPaletteInfo get(BlockMeta block) {
            if (this.infomap.containsKey(block)) {
                return this.infomap.get(block);
            }
            return BlockPaletteInfo.DEFAULT;
        }

        public void set(BlockMeta block, double hardness, double breakchance, double smashchance) {
            this.set(block, hardness, breakchance, smashchance, null);
        }

        public void set(BlockMeta block, double hardness, double breakchance, double smashchance, BlockMeta broken) {
            this.infomap.put(block, new BlockPaletteInfo(hardness, breakchance, smashchance, broken));
        }

        public static class BlockPaletteInfo {
            public static final BlockPaletteInfo DEFAULT = new BlockPaletteInfo(1.0, 0.2, 0.2, null);
            public final double hardness;
            public final double breakchance;
            public final double smashchance;
            public final BlockMeta broken;

            public BlockPaletteInfo(double hardness, double breakchance, double smashchance, BlockMeta broken) {
                this.hardness = hardness;
                this.breakchance = breakchance;
                this.smashchance = smashchance;
                this.broken = broken;
            }
        }
    }

    public static class BlockMeta {
        public Block block;
        public byte meta;

        public BlockMeta(Block block, int meta) {
            this.block = block;
            this.meta = (byte)(meta & 0xFF);
        }

        public String toString() {
            return this.block.toString() + "#" + this.meta;
        }

        public int hashCode() {
            return this.block.hashCode() + this.meta;
        }
    }

    public static class BlockArray {
        public BlockMeta[] blocks;
        public int xSize;
        public int ySize;
        public int zSize;
        public int length;

        public BlockArray(int xSize, int ySize, int zSize) {
            this.length = xSize * ySize * zSize;
            this.blocks = new BlockMeta[this.length];
            this.xSize = xSize;
            this.ySize = ySize;
            this.zSize = zSize;
        }

        public boolean outOfBounds(int x, int y, int z) {
            return x < 0 || x >= this.xSize || y < 0 || y >= this.ySize || z < 0 || z >= this.zSize;
        }

        public void setBlock(int x, int y, int z, BlockMeta block) {
            if (this.outOfBounds(x, y, z)) {
                return;
            }
            this.blocks[this.index((int)x, (int)y, (int)z)] = block;
        }

        public BlockMeta getBlock(int x, int y, int z) {
            if (this.outOfBounds(x, y, z)) {
                return null;
            }
            return this.blocks[this.index(x, y, z)];
        }

        public void fillBlocks(int x, int y, int z, int x2, int y2, int z2, BlockMeta block) {
            for (int ix = x; ix <= x2; ++ix) {
                for (int iy = y; iy <= y2; ++iy) {
                    for (int iz = z; iz <= z2; ++iz) {
                        this.setBlock(ix, iy, iz, block);
                    }
                }
            }
        }

        protected int index(int x, int y, int z) {
            return y * this.zSize * this.xSize + z * this.xSize + x;
        }
    }
}

