/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.rewardparts;

import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class OffsetTileEntity
extends OffsetBlock {
    private NBTTagCompound nbt;

    public OffsetTileEntity(int x, int y, int z, Block block, NBTTagCompound nbt, boolean falling) {
        this(x, y, z, block, nbt, falling, 0);
    }

    public OffsetTileEntity(int x, int y, int z, Block block, NBTTagCompound nbt, boolean falling, int delay) {
        super(x, y, z, block, falling, delay);
        this.nbt = nbt;
    }

    @Override
    public void spawnInWorld(final World world, final int x, final int y, final int z) {
        if (!this.falling) {
            if (this.delay != 0) {
                Task task = new Task("Delayed_Block_At_(" + this.xOff + "," + this.yOff + "," + this.zOff + ")", this.delay){

                    @Override
                    public void callback() {
                        OffsetTileEntity.this.placeInWorld(world, x, y, z, true);
                    }
                };
                Scheduler.scheduleTask(task);
            } else {
                this.placeInWorld(world, x, y, z, true);
            }
        } else if (this.delay != 0) {
            Task task = new Task("Falling_Block_At_(" + this.xOff + "," + this.yOff + "," + this.zOff + ")", this.delay){

                @Override
                public void callback() {
                    OffsetTileEntity.this.spawnFallingBlock(world, x, y, z);
                }
            };
            Scheduler.scheduleTask(task);
        } else {
            this.spawnFallingBlock(world, x, y, z);
        }
    }

    @Override
    public void placeInWorld(World world, int x, int y, int z, boolean offset) {
        super.placeInWorld(world, x, y, z, offset);
        TileEntity te = TileEntity.func_145827_c((NBTTagCompound)this.nbt);
        te.field_145847_g = this.data;
        if (offset) {
            world.func_147455_a(x + this.xOff, y + this.yOff, z + this.zOff, te);
        } else {
            world.func_147455_a(x, y, z, te);
        }
        te.func_70296_d();
    }

    public void seFalling(boolean falling) {
        this.falling = falling;
    }
}

