/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.item;

import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Iterator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class StackMap
extends TObjectIntHashMap<ItemEntry> {
    public boolean addItemstack(ItemStack itemStack, int n) {
        this.adjustOrPutValue(new ItemEntry(itemStack, n), itemStack.field_77994_a, itemStack.field_77994_a);
        return true;
    }

    public boolean addItemEntry(ItemEntry itemEntry, int n) {
        if (itemEntry == null) {
            return false;
        }
        this.adjustOrPutValue(itemEntry, n, n);
        return true;
    }

    public IteratorItemstack getItems() {
        return new IteratorItemstack();
    }

    public class IteratorItemstack
    implements Iterator<ItemStack>,
    Iterable<ItemStack> {
        public final TObjectIntIterator<ItemEntry> iterator;

        public IteratorItemstack() {
            this.iterator = StackMap.this.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public ItemStack next() {
            this.iterator.advance();
            return ((ItemEntry)this.iterator.key()).toItemStack(this.iterator.value());
        }

        @Override
        public Iterator<ItemStack> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    public static final class ItemEntry {
        public final Item item;
        public final int item_id;
        public final int metadata;
        public NBTTagCompound tag;
        public final int side;

        public ItemEntry(ItemStack itemStack, int n) {
            this(itemStack.func_77973_b(), itemStack.func_77960_j(), itemStack.field_77990_d, n);
        }

        public ItemEntry(Item item, int n, NBTTagCompound nBTTagCompound, int n2) {
            this.item = item;
            this.metadata = n;
            this.tag = nBTTagCompound != null ? (NBTTagCompound)nBTTagCompound.func_74737_b() : null;
            this.side = n2;
            this.item_id = this.getId();
        }

        public ItemStack toItemStack(int n) {
            if (this.tag == null) {
                return new ItemStack(this.item, n, this.metadata);
            }
            ItemStack itemStack = new ItemStack(this.item, n, this.metadata);
            itemStack.field_77990_d = (NBTTagCompound)this.tag.func_74737_b();
            return itemStack;
        }

        protected final int getId() {
            return Item.func_150891_b((Item)this.item);
        }

        public String toString() {
            return "ItemEntry{item=" + this.item + ", item_id=" + this.item_id + ", metadata=" + this.metadata + ", tag=" + this.tag + ", side=" + this.side + '}';
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ItemEntry)) {
                return false;
            }
            ItemEntry itemEntry = (ItemEntry)object;
            if (this.side != itemEntry.side) {
                return false;
            }
            if (this.metadata != itemEntry.metadata) {
                return false;
            }
            if (!this.item.equals(itemEntry.item)) {
                return false;
            }
            if (this.tag != null) {
                if (itemEntry.tag == null) {
                    return false;
                }
                if (this.tag == itemEntry.tag) return true;
                if (!this.tag.equals((Object)itemEntry.tag)) return false;
                this.tag = itemEntry.tag;
                return true;
            } else {
                if (itemEntry.tag == null) return true;
                return false;
            }
        }

        public int hashCode() {
            return this.metadata & 0x3FFF | this.item_id << 14 | this.side << 28;
        }
    }
}

