/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.servo;

import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.attachments.filter.FilterLogic;
import cofh.thermaldynamics.duct.attachments.servo.ServoBase;
import cofh.thermaldynamics.duct.fluid.TileFluidDuct;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class ServoFluid
extends ServoBase {
    public TileFluidDuct fluidDuct;
    public static float[] throttle = new float[]{0.5f, 0.75f, 1.0f, 1.5f, 2.0f};
    public IFluidHandler theTile;

    @Override
    public int getId() {
        return 1;
    }

    public ServoFluid(TileTDBase tileTDBase, byte by) {
        super(tileTDBase, by);
        this.fluidDuct = (TileFluidDuct)tileTDBase;
    }

    public ServoFluid(TileTDBase tileTDBase, byte by, int n) {
        super(tileTDBase, by, n);
        this.fluidDuct = (TileFluidDuct)tileTDBase;
    }

    @Override
    public void clearCache() {
        this.theTile = null;
    }

    @Override
    public void cacheTile(TileEntity tileEntity) {
        this.theTile = (IFluidHandler)tileEntity;
    }

    @Override
    public boolean isValidTile(TileEntity tileEntity) {
        return tileEntity instanceof IFluidHandler;
    }

    @Override
    public boolean canAddToTile(TileTDBase tileTDBase) {
        return tileTDBase instanceof TileFluidDuct;
    }

    @Override
    public void tick(int n) {
        super.tick(n);
        if (n != 1 || this.fluidDuct.fluidGrid == null || !this.isPowered || !this.isValidInput) {
            return;
        }
        int n2 = (int)Math.ceil((float)this.fluidDuct.fluidGrid.myTank.fluidThroughput * throttle[this.type]);
        n2 = this.fluidDuct.fill(ForgeDirection.VALID_DIRECTIONS[this.side], this.theTile.drain(ForgeDirection.VALID_DIRECTIONS[this.side ^ 1], n2, false), false);
        FluidStack fluidStack = this.theTile.drain(ForgeDirection.VALID_DIRECTIONS[this.side ^ 1], n2, true);
        this.fluidDuct.fill(ForgeDirection.getOrientation((int)this.side), fluidStack, true);
    }

    public boolean fluidPassesFiltering(FluidStack fluidStack) {
        return fluidStack != null && this.filter.allowFluid(fluidStack);
    }

    @Override
    public FilterLogic createFilterLogic() {
        return new FilterLogic(this.type, Duct.Type.FLUID, this);
    }
}

