/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCarpentersBlock;
import com.carpentersblocks.block.BlockCarpentersStairs;
import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.Hatch;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.handler.ChatHandler;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCarpentersHatch
extends BlockCoverable {
    public BlockCarpentersHatch(Material material) {
        super(material);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        IconRegistry.icon_hatch_glass = iconRegister.func_94245_a("CarpentersBlocks:hatch/hatch_glass");
        IconRegistry.icon_hatch_french_glass = iconRegister.func_94245_a("CarpentersBlocks:hatch/hatch_french_glass");
        IconRegistry.icon_hatch_screen = iconRegister.func_94245_a("CarpentersBlocks:hatch/hatch_screen");
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        if (!TE.func_145831_w().field_72995_K) {
            this.findNextSideSupportBlock(TE, TE.func_145831_w(), TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
        }
        return true;
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        if (!entityPlayer.func_70093_af()) {
            int type = Hatch.getType(TE);
            if (++type > 4) {
                type = 0;
            }
            Hatch.setType(TE, type);
        } else {
            int rigidity = Hatch.getRigidity(TE) == 0 ? 1 : 0;
            Hatch.setRigidity(TE, rigidity);
            switch (rigidity) {
                case 0: {
                    ChatHandler.sendMessageToPlayer("message.activation_wood.name", entityPlayer);
                    break;
                }
                case 1: {
                    ChatHandler.sendMessageToPlayer("message.activation_iron.name", entityPlayer);
                }
            }
        }
        return true;
    }

    @Override
    protected void postOnBlockActivated(TEBase TE, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ, BlockCoverable.ActionResult actionResult) {
        if (!this.activationRequiresRedstone(TE)) {
            Hatch.setState(TE, Hatch.getState(TE) == 0 ? 1 : 0);
            actionResult.setAltered().setNoSound();
        }
    }

    private boolean activationRequiresRedstone(TEBase TE) {
        return Hatch.getRigidity(TE) == 1;
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null) {
            boolean isHigh = Hatch.getPos(TE) == 1;
            boolean isOpen = Hatch.getState(TE) == 1;
            int dir = Hatch.getDir(TE);
            float thickness = 0.1875f;
            if (Hatch.getType(TE) == 0) {
                thickness = 0.125f;
            }
            if (isHigh) {
                this.func_149676_a(0.0f, 1.0f - thickness, 0.0f, 1.0f, 1.0f, 1.0f);
            } else {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, thickness, 1.0f);
            }
            if (isOpen) {
                switch (dir) {
                    case 0: {
                        this.func_149676_a(0.0f, 0.0f, 1.0f - thickness, 1.0f, 1.0f, 1.0f);
                        break;
                    }
                    case 1: {
                        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, thickness);
                        break;
                    }
                    case 2: {
                        this.func_149676_a(1.0f - thickness, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                        break;
                    }
                    case 3: {
                        this.func_149676_a(0.0f, 0.0f, 0.0f, thickness, 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        super.func_149743_a(world, x, y, z, axisAlignedBB, list, entity);
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            boolean isOpen;
            int dir = Hatch.getDir(TE);
            int state = Hatch.getState(TE);
            int xOffset = x;
            int zOffset = z;
            switch (dir) {
                case 0: {
                    zOffset = z + 1;
                    break;
                }
                case 1: {
                    --zOffset;
                    break;
                }
                case 2: {
                    xOffset = x + 1;
                    break;
                }
                case 3: {
                    --xOffset;
                }
            }
            if (!this.isValidSupportBlock(world, x, y, z, world.func_147439_a(xOffset, y, zOffset)) && !world.func_147439_a(xOffset, y, zOffset).isSideSolid((IBlockAccess)world, xOffset, y, zOffset, ForgeDirection.getOrientation((int)(dir + 2)))) {
                this.findNextSideSupportBlock(TE, world, x, y, z);
            }
            boolean isPowered = world.func_72864_z(x, y, z);
            boolean bl = isOpen = state == 1;
            if (block != null && block.func_149744_f() && isPowered != isOpen) {
                Hatch.setState(TE, state == 1 ? 0 : 1);
            }
        }
        super.func_149695_a(world, x, y, z, block);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 startVec, Vec3 endVec) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149731_a(world, x, y, z, startVec, endVec);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        int initData = 0;
        if (side > 1) {
            initData = side - 2;
        }
        if (side != 1 && side != 0 && hitY > 0.5f) {
            initData |= 8;
        }
        return initData;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            int metadata = world.func_72805_g(x, y, z);
            Hatch.setDir(TE, metadata & 3);
            if ((metadata & 8) > 0) {
                Hatch.setPos(TE, 1);
            }
        }
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        switch (side) {
            case 2: {
                return this.isValidSupportBlock(world, x, y, z, world.func_147439_a(x, y, z + 1)) || world.func_147439_a(x, y, z + 1).isSideSolid((IBlockAccess)world, x, y, z + 1, ForgeDirection.getOrientation((int)ForgeDirection.OPPOSITES[3]));
            }
            case 3: {
                return this.isValidSupportBlock(world, x, y, z, world.func_147439_a(x, y, z - 1)) || world.func_147439_a(x, y, z - 1).isSideSolid((IBlockAccess)world, x, y, z - 1, ForgeDirection.getOrientation((int)ForgeDirection.OPPOSITES[2]));
            }
            case 4: {
                return this.isValidSupportBlock(world, x, y, z, world.func_147439_a(x + 1, y, z)) || world.func_147439_a(x + 1, y, z).isSideSolid((IBlockAccess)world, x + 1, y, z, ForgeDirection.getOrientation((int)ForgeDirection.OPPOSITES[5]));
            }
            case 5: {
                return this.isValidSupportBlock(world, x, y, z, world.func_147439_a(x - 1, y, z)) || world.func_147439_a(x - 1, y, z).isSideSolid((IBlockAccess)world, x - 1, y, z, ForgeDirection.getOrientation((int)ForgeDirection.OPPOSITES[4]));
            }
        }
        return false;
    }

    private void findNextSideSupportBlock(TEBase TE, World world, int x, int y, int z) {
        int count;
        int dir = Hatch.getDir(TE);
        if (++dir > 3) {
            dir = 0;
        }
        for (count = 0; !this.func_149707_d(world, x, y, z, dir + 2) && count < 4; ++count) {
            if (++dir <= 3) continue;
            dir = 0;
        }
        if (count == 4) {
            this.destroyBlock(world, x, y, z, true);
        } else {
            Hatch.setDir(TE, dir);
        }
    }

    public boolean isLadder(IBlockAccess blockAccess, int x, int y, int z, EntityLivingBase entityLiving) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        return TE != null && Hatch.getType(TE) == 0 && Hatch.getPos(TE) == 1 && Hatch.getState(TE) == 1;
    }

    private boolean isValidSupportBlock(World world, int x, int y, int z, Block block) {
        return block == Blocks.field_150426_aN || block instanceof BlockCarpentersStairs || block instanceof BlockCarpentersBlock || block instanceof BlockSlab || block instanceof BlockStairs;
    }

    public int func_149645_b() {
        return BlockRegistry.carpentersHatchRenderID;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        ForgeDirection[] axises = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
        return axises;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TEBase) {
            TEBase cbTile = (TEBase)tile;
            int direction = Hatch.getDir(cbTile);
            switch (axis) {
                case UP: {
                    switch (direction) {
                        case 0: {
                            Hatch.setDir(cbTile, 3);
                            break;
                        }
                        case 1: {
                            Hatch.setDir(cbTile, 2);
                            break;
                        }
                        case 2: {
                            Hatch.setDir(cbTile, 0);
                            break;
                        }
                        case 3: {
                            Hatch.setDir(cbTile, 1);
                        }
                    }
                    break;
                }
                case DOWN: {
                    switch (direction) {
                        case 0: {
                            Hatch.setDir(cbTile, 2);
                            break;
                        }
                        case 1: {
                            Hatch.setDir(cbTile, 3);
                            break;
                        }
                        case 2: {
                            Hatch.setDir(cbTile, 1);
                            break;
                        }
                        case 3: {
                            Hatch.setDir(cbTile, 0);
                        }
                    }
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

