/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.storage.item;

import codechicken.enderstorage.EnderStorage;
import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.common.TileFrequencyOwner;
import codechicken.enderstorage.storage.item.EnderDyeButton;
import codechicken.enderstorage.storage.item.EnderItemStorage;
import codechicken.enderstorage.storage.item.EnderKnobSlot;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEnderChest
extends TileFrequencyOwner
implements IInventory {
    public double a_lidAngle;
    public double b_lidAngle;
    public int c_numOpen;
    public int rotation;
    private EnderItemStorage storage;
    public static EnderDyeButton[] buttons = new EnderDyeButton[3];

    public TileEnderChest(World world, int metaData) {
        this.field_145850_b = world;
        this.freq = metaData;
        this.c_numOpen = -1;
    }

    public TileEnderChest() {
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) != 0) {
            this.rotation = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
        }
        if (!(this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 20L != 0L && this.c_numOpen == this.storage.getNumOpen())) {
            this.c_numOpen = this.storage.getNumOpen();
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)EnderStorage.blockEnderChest, 1, this.c_numOpen);
        }
        this.b_lidAngle = this.a_lidAngle;
        this.a_lidAngle = MathHelper.approachLinear((double)this.a_lidAngle, (double)(this.c_numOpen > 0 ? 1.0 : 0.0), (double)0.1);
        if (this.b_lidAngle >= 0.5 && this.a_lidAngle < 0.5) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        } else if (this.b_lidAngle == 0.0 && this.a_lidAngle > 0.0) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 1) {
            this.c_numOpen = j;
            return true;
        }
        return false;
    }

    public double getRadianLidAngle(float frame) {
        double a = MathHelper.interpolate((double)this.b_lidAngle, (double)this.a_lidAngle, (double)frame);
        a = 1.0 - a;
        a = 1.0 - a * a * a;
        return a * 3.141593 * -0.5;
    }

    @Override
    public void reloadStorage() {
        this.storage = (EnderItemStorage)EnderStorageManager.instance(this.field_145850_b.field_72995_K).getStorage(this.owner, this.freq, "item");
    }

    @Override
    public EnderItemStorage getStorage() {
        return this.storage;
    }

    public int func_70302_i_() {
        return this.storage.func_70302_i_();
    }

    public ItemStack func_70301_a(int var1) {
        return this.storage.func_70301_a(var1);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return this.storage.func_70298_a(var1, var2);
    }

    public ItemStack func_70304_b(int var1) {
        return this.storage.func_70304_b(var1);
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.storage.func_70299_a(var1, var2);
    }

    public String func_145825_b() {
        return "Ender Chest";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void writeToPacket(PacketCustom packet) {
        packet.writeByte(this.rotation);
    }

    @Override
    public void handleDescriptionPacket(PacketCustom desc) {
        super.handleDescriptionPacket(desc);
        this.rotation = desc.readUByte();
    }

    @Override
    public void onPlaced(EntityLivingBase entity) {
        this.rotation = (int)Math.floor((double)(entity.field_70177_z * 4.0f / 360.0f) + 2.5) & 3;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74774_a("rot", (byte)this.rotation);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.rotation = tag.func_74771_c("rot");
    }

    @Override
    public boolean activate(EntityPlayer player, int subHit) {
        this.storage.openSMPGui(player, "tile.enderchest|0.name");
        return true;
    }

    @Override
    public void addTraceableCuboids(List<IndexedCuboid6> cuboids) {
        cuboids.add(new IndexedCuboid6((Object)0, new Cuboid6((double)this.field_145851_c + 0.0625, (double)this.field_145848_d, (double)this.field_145849_e + 0.0625, (double)this.field_145851_c + 0.9375, (double)this.field_145848_d + 0.875, (double)this.field_145849_e + 0.9375)));
        if (this.getRadianLidAngle(0.0f) < 0.0) {
            return;
        }
        for (int button = 0; button < 3; ++button) {
            EnderDyeButton ebutton = buttons[button].copy();
            ebutton.rotate(0.0, 0.5625, 0.0625, 1.0, 0.0, 0.0, 0.0);
            ebutton.rotateMeta(this.rotation);
            cuboids.add(new IndexedCuboid6((Object)(button + 1), new Cuboid6(ebutton.getMin(), ebutton.getMax()).add(Vector3.fromTileEntity((TileEntity)this))));
        }
        cuboids.add(new IndexedCuboid6((Object)4, new Cuboid6(new EnderKnobSlot(this.rotation).getSelectionBB()).add(Vector3.fromTileEntity((TileEntity)this))));
    }

    @Override
    public boolean rotate() {
        if (!this.field_145850_b.field_72995_K) {
            this.rotation = (this.rotation + 1) % 4;
            PacketCustom.sendToChunk((Packet)this.func_145844_m(), (World)this.field_145850_b, (int)(this.field_145851_c >> 4), (int)(this.field_145849_e >> 4));
        }
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public boolean func_145818_k_() {
        return true;
    }

    @Override
    public int comparatorInput() {
        return Container.func_94526_b((IInventory)this);
    }

    static {
        for (int i = 0; i < 3; ++i) {
            TileEnderChest.buttons[i] = new EnderDyeButton(i);
        }
    }
}

