/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader;

import codechicken.chunkloader.ChickenChunks;
import codechicken.chunkloader.IChickenChunkLoader;
import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import codechicken.lib.config.ConfigFile;
import codechicken.lib.config.ConfigTag;
import codechicken.lib.vec.BlockCoord;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import org.apache.logging.log4j.LogManager;

public class ChunkLoaderManager {
    private static boolean reloadDimensions = false;
    private static boolean opInteract = false;
    private static int cleanupTicks;
    private static int maxChunks;
    private static int awayTimeout;
    private static HashMap<Object, ModContainer> mods;
    private static boolean loaded;
    private static HashMap<String, PlayerOrganiser> playerOrganisers;
    private static HashMap<Object, ModOrganiser> modOrganisers;
    private static HashMap<String, Long> loginTimes;
    private static File saveDir;

    public static void registerMod(Object mod) {
        ModContainer container = (ModContainer)Loader.instance().getModObjectList().inverse().get(mod);
        if (container == null) {
            throw new NullPointerException("Mod container not found for: " + mod);
        }
        mods.put(mod, container);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)mod, (ForgeChunkManager.LoadingCallback)new DummyLoadingCallback());
    }

    public static void loadWorld(WorldServer world) {
        ReviveChange.DimensionRevive.list.add(world);
    }

    public static World getWorld(int dim, boolean create) {
        if (create) {
            return MinecraftServer.func_71276_C().func_71218_a(dim);
        }
        return DimensionManager.getWorld((int)dim);
    }

    public static void load(WorldServer world) {
        if (loaded) {
            return;
        }
        loaded = true;
        playerOrganisers = new HashMap();
        modOrganisers = new HashMap();
        loginTimes = new HashMap();
        ReviveChange.load();
        try {
            saveDir = new File(DimensionManager.getCurrentSaveRootDirectory(), "chickenchunks");
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            ChunkLoaderManager.loadPlayerChunks();
            ChunkLoaderManager.loadModChunks();
            ChunkLoaderManager.loadLoginTimes();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void loadLoginTimes() throws IOException {
        File saveFile = new File(saveDir, "loginTimes.dat");
        if (!saveFile.exists()) {
            return;
        }
        DataInputStream datain = new DataInputStream(new FileInputStream(saveFile));
        try {
            int entries = datain.readInt();
            for (int i = 0; i < entries; ++i) {
                loginTimes.put(datain.readUTF(), datain.readLong());
            }
        }
        catch (IOException e) {
            LogManager.getLogger((String)"ChickenChunks").error("Error reading loginTimes.dat", (Throwable)e);
        }
        datain.close();
    }

    private static void loadModChunks() throws IOException {
        for (Map.Entry<Object, ModContainer> entry : mods.entrySet()) {
            File saveFile = new File(saveDir, entry.getValue().getModId() + ".dat");
            if (!saveFile.exists()) {
                return;
            }
            DataInputStream datain = new DataInputStream(new FileInputStream(saveFile));
            ModOrganiser organiser = ChunkLoaderManager.getModOrganiser(entry.getKey());
            ReviveChange.ModRevive.list.add(organiser);
            organiser.load(datain);
            datain.close();
        }
    }

    private static void loadPlayerChunks() throws IOException {
        File saveFile = new File(saveDir, "players.dat");
        if (!saveFile.exists()) {
            return;
        }
        DataInputStream datain = new DataInputStream(new FileInputStream(saveFile));
        int organisers = datain.readInt();
        for (int i = 0; i < organisers; ++i) {
            String username = datain.readUTF();
            PlayerOrganiser organiser = ChunkLoaderManager.getPlayerOrganiser(username);
            organiser.setDormant();
            if (ChunkLoaderManager.allowOffline(username) && ChunkLoaderManager.loggedInRecently(username)) {
                ReviveChange.PlayerRevive.list.add(organiser);
            }
            organiser.load(datain);
        }
        datain.close();
    }

    private static boolean loggedInRecently(String username) {
        if (awayTimeout == 0) {
            return true;
        }
        Long lastLogin = loginTimes.get(username);
        return lastLogin != null && (System.currentTimeMillis() - lastLogin) / 60000L < (long)awayTimeout;
    }

    public static int getPlayerChunkLimit(String username) {
        int ret;
        ConfigTag config = ChickenChunks.config.getTag("players");
        if (config.containsTag(username) && (ret = config.getTag(username).getIntValue(0)) != 0) {
            return ret;
        }
        if (ServerUtils.isPlayerOP((String)username) && (ret = config.getTag("OP").getIntValue(0)) != 0) {
            return ret;
        }
        return config.getTag("DEFAULT").getIntValue(5000);
    }

    public static boolean allowOffline(String username) {
        ConfigTag config = ChickenChunks.config.getTag("allowoffline");
        if (config.containsTag(username)) {
            return config.getTag(username).getBooleanValue(true);
        }
        if (ServerUtils.isPlayerOP((String)username)) {
            return config.getTag("OP").getBooleanValue(true);
        }
        return config.getTag("DEFAULT").getBooleanValue(true);
    }

    public static boolean allowChunkViewer(String username) {
        ConfigTag config = ChickenChunks.config.getTag("allowchunkviewer");
        if (config.containsTag(username)) {
            return config.getTag(username).getBooleanValue(true);
        }
        if (ServerUtils.isPlayerOP((String)username)) {
            return config.getTag("OP").getBooleanValue(true);
        }
        return config.getTag("DEFAULT").getBooleanValue(true);
    }

    public static void initConfig(ConfigFile config) {
        config.getTag("players").setPosition(0).useBraces().setComment("Per player chunk limiting. Values ignored if 0.:Simply add <username>=<value>");
        config.getTag("players.DEFAULT").setComment("Forge gives everyone 12500 by default").getIntValue(5000);
        config.getTag("players.OP").setComment("For server op's only.").getIntValue(5000);
        config.getTag("allowoffline").setPosition(1).useBraces().setComment("If set to false, players will have to be logged in for their chunkloaders to work.:Simply add <username>=<true|false>");
        config.getTag("allowoffline.DEFAULT").getBooleanValue(true);
        config.getTag("allowoffline.OP").getBooleanValue(true);
        config.getTag("allowchunkviewer").setPosition(2).useBraces().setComment("Set to false to deny a player access to the chunk viewer");
        config.getTag("allowchunkviewer.DEFAULT").getBooleanValue(true);
        config.getTag("allowchunkviewer.OP").getBooleanValue(true);
        if (!FMLCommonHandler.instance().getModName().contains("mcpc")) {
            cleanupTicks = config.getTag("cleanuptime").setComment("The number of ticks to wait between attempting to unload orphaned chunks").getIntValue(1200);
        }
        reloadDimensions = config.getTag("reload-dimensions").setComment("Set to false to disable the automatic reloading of mystcraft dimensions on server restart").getBooleanValue(true);
        opInteract = config.getTag("op-interact").setComment("Enabling this lets OPs alter other player's chunkloaders. WARNING: If you change a chunkloader, you have no idea what may break/explode by not being chunkloaded.").getBooleanValue(false);
        maxChunks = config.getTag("maxchunks").setComment("The maximum number of chunks per chunkloader").getIntValue(400);
        awayTimeout = config.getTag("awayTimeout").setComment("The number of minutes since last login within which chunks from a player will remain active, 0 for infinite.").getIntValue(0);
    }

    public static void addChunkLoader(IChickenChunkLoader loader) {
        int dim = CommonUtils.getDimension((World)loader.getWorld());
        ChunkLoaderOrganiser organiser = ChunkLoaderManager.getOrganiser(loader);
        if (organiser.canForceNewChunks(dim, loader.getChunks())) {
            organiser.addChunkLoader(loader);
        } else {
            loader.deactivate();
        }
    }

    private static ChunkLoaderOrganiser getOrganiser(IChickenChunkLoader loader) {
        String owner = loader.getOwner();
        return owner == null ? ChunkLoaderManager.getModOrganiser(loader.getMod()) : ChunkLoaderManager.getPlayerOrganiser(owner);
    }

    public static void remChunkLoader(IChickenChunkLoader loader) {
        ChunkLoaderManager.getOrganiser(loader).remChunkLoader(loader);
    }

    public static void updateLoader(IChickenChunkLoader loader) {
        ChunkLoaderManager.getOrganiser(loader).updateChunkLoader(loader);
    }

    public static boolean canLoaderAdd(IChickenChunkLoader loader, Collection<ChunkCoordIntPair> chunks) {
        String owner = loader.getOwner();
        int dim = CommonUtils.getDimension((World)loader.getWorld());
        if (owner != null) {
            return ChunkLoaderManager.getPlayerOrganiser(owner).canForceNewChunks(dim, chunks);
        }
        return false;
    }

    private static PlayerOrganiser getPlayerOrganiser(String username) {
        PlayerOrganiser organiser = playerOrganisers.get(username);
        if (organiser == null) {
            organiser = new PlayerOrganiser(username);
            playerOrganisers.put(username, organiser);
        }
        return organiser;
    }

    private static ModOrganiser getModOrganiser(Object mod) {
        ModOrganiser organiser = modOrganisers.get(mod);
        if (organiser == null) {
            ModContainer container = mods.get(mod);
            if (container == null) {
                throw new NullPointerException("Mod not registered with chickenchunks: " + mod);
            }
            organiser = new ModOrganiser(mod, container);
            modOrganisers.put(mod, organiser);
        }
        return organiser;
    }

    public static void serverShutdown() {
        loaded = false;
    }

    public static void save(WorldServer world) {
        try {
            if (PlayerOrganiser.dirty) {
                File saveFile = new File(saveDir, "players.dat");
                if (!saveFile.exists()) {
                    saveFile.createNewFile();
                }
                DataOutputStream dataout = new DataOutputStream(new FileOutputStream(saveFile));
                dataout.writeInt(playerOrganisers.size());
                for (PlayerOrganiser organiser : playerOrganisers.values()) {
                    dataout.writeUTF(organiser.username);
                    organiser.save(dataout);
                }
                dataout.close();
                PlayerOrganiser.dirty = false;
            }
            for (ModOrganiser organiser : modOrganisers.values()) {
                if (!organiser.dirty) continue;
                File saveFile = new File(saveDir, organiser.container.getModId() + ".dat");
                if (!saveFile.exists()) {
                    saveFile.createNewFile();
                }
                DataOutputStream dataout = new DataOutputStream(new FileOutputStream(saveFile));
                organiser.save(dataout);
                dataout.close();
                organiser.dirty = false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void cleanChunks(WorldServer world) {
        int dim = CommonUtils.getDimension((World)world);
        int viewdist = ServerUtils.mc().func_71203_ab().func_72395_o();
        HashSet<ChunkCoordIntPair> loadedChunks = new HashSet<ChunkCoordIntPair>();
        for (EntityPlayer player : ServerUtils.getPlayersInDimension((int)dim)) {
            int playerChunkX = (int)player.field_70165_t >> 4;
            int playerChunkZ = (int)player.field_70161_v >> 4;
            for (int cx = playerChunkX - viewdist; cx <= playerChunkX + viewdist; ++cx) {
                for (int cz = playerChunkZ - viewdist; cz <= playerChunkZ + viewdist; ++cz) {
                    loadedChunks.add(new ChunkCoordIntPair(cx, cz));
                }
            }
        }
        ImmutableSetMultimap persistantChunks = world.getPersistentChunks();
        PlayerManager manager = world.func_73040_p();
        for (Chunk chunk : world.field_73059_b.field_73245_g) {
            ChunkCoordIntPair coord = chunk.func_76632_l();
            if (loadedChunks.contains(coord) || persistantChunks.containsKey((Object)coord) || !world.field_73059_b.func_73149_a(coord.field_77276_a, coord.field_77275_b)) continue;
            PlayerManager.PlayerInstance instance = manager.func_72690_a(coord.field_77276_a, coord.field_77275_b, false);
            if (instance == null) {
                world.field_73059_b.func_73241_b(coord.field_77276_a, coord.field_77275_b);
                continue;
            }
            while (instance.field_73263_b.size() > 0) {
                instance.func_73252_b((EntityPlayerMP)instance.field_73263_b.get(0));
            }
        }
        if (ServerUtils.getPlayersInDimension((int)dim).isEmpty() && world.getPersistentChunks().isEmpty() && !DimensionManager.shouldLoadSpawn((int)dim)) {
            DimensionManager.unloadWorld((int)dim);
        }
    }

    public static void tickEnd(WorldServer world) {
        if (world.func_72820_D() % 1200L == 0L) {
            ChunkLoaderManager.updateLoginTimes();
        }
        if (cleanupTicks > 0 && world.func_72820_D() % (long)cleanupTicks == 0L) {
            ChunkLoaderManager.cleanChunks(world);
        }
        ChunkLoaderManager.tickDownUnloads();
        ChunkLoaderManager.revivePlayerLoaders();
    }

    private static void updateLoginTimes() {
        long time = System.currentTimeMillis();
        for (EntityPlayer player : ServerUtils.getPlayers()) {
            loginTimes.put(player.func_70005_c_(), time);
        }
        try {
            File saveFile = new File(saveDir, "loginTimes.dat");
            if (!saveFile.exists()) {
                saveFile.createNewFile();
            }
            DataOutputStream dataout = new DataOutputStream(new FileOutputStream(saveFile));
            dataout.writeInt(loginTimes.size());
            for (Map.Entry<String, Long> entry : loginTimes.entrySet()) {
                dataout.writeUTF(entry.getKey());
                dataout.writeLong(entry.getValue());
            }
            dataout.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (PlayerOrganiser organiser : playerOrganisers.values()) {
            if (organiser.isDormant() || ChunkLoaderManager.loggedInRecently(organiser.username)) continue;
            ReviveChange.PlayerDevive.list.add(organiser);
        }
    }

    private static void tickDownUnloads() {
        for (Map.Entry<String, PlayerOrganiser> entry : playerOrganisers.entrySet()) {
            entry.getValue().tickDownUnloads();
        }
        for (Map.Entry<Object, ChunkLoaderOrganiser> entry : modOrganisers.entrySet()) {
            ((ModOrganiser)entry.getValue()).tickDownUnloads();
        }
    }

    private static void revivePlayerLoaders() {
        for (Object e : ReviveChange.PlayerRevive.list) {
            ((PlayerOrganiser)e).revive();
        }
        ReviveChange.PlayerRevive.list.clear();
        for (Object e : ReviveChange.ModRevive.list) {
            ((ModOrganiser)e).revive();
        }
        ReviveChange.ModRevive.list.clear();
        for (Object e : ReviveChange.DimensionRevive.list) {
            for (PlayerOrganiser organiser : playerOrganisers.values()) {
                organiser.revive((World)e);
            }
        }
        ReviveChange.DimensionRevive.list.clear();
        for (Object e : ReviveChange.PlayerDevive.list) {
            ((PlayerOrganiser)e).devive();
        }
        ReviveChange.PlayerDevive.list.clear();
    }

    public static void playerLogin(String username) {
        loginTimes.put(username, System.currentTimeMillis());
        ReviveChange.PlayerRevive.list.add(ChunkLoaderManager.getPlayerOrganiser(username));
    }

    public static void playerLogout(String username) {
        if (!ChunkLoaderManager.allowOffline(username)) {
            ReviveChange.PlayerDevive.list.add(ChunkLoaderManager.getPlayerOrganiser(username));
        }
    }

    public static int maxChunksPerLoader() {
        return maxChunks;
    }

    public static boolean opInteract() {
        return opInteract;
    }

    public static void unloadWorld(World world) {
        int dim = CommonUtils.getDimension((World)world);
        for (TicketManager ticketManager : playerOrganisers.values()) {
            ticketManager.unloadDimension(dim);
        }
        for (TicketManager ticketManager : modOrganisers.values()) {
            ticketManager.unloadDimension(dim);
        }
    }

    static {
        mods = new HashMap();
        loaded = false;
    }

    private static enum ReviveChange {
        PlayerRevive,
        PlayerDevive,
        ModRevive,
        DimensionRevive;

        public LinkedList<Object> list;

        public static void load() {
            for (ReviveChange change : ReviveChange.values()) {
                change.list = new LinkedList();
            }
        }
    }

    private static class DummyLoadingCallback
    implements ForgeChunkManager.OrderedLoadingCallback,
    ForgeChunkManager.PlayerOrderedLoadingCallback {
        private DummyLoadingCallback() {
        }

        public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        }

        public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
            return new LinkedList<ForgeChunkManager.Ticket>();
        }

        public ListMultimap<String, ForgeChunkManager.Ticket> playerTicketsLoaded(ListMultimap<String, ForgeChunkManager.Ticket> tickets, World world) {
            return LinkedListMultimap.create();
        }
    }

    private static class ModOrganiser
    extends ChunkLoaderOrganiser {
        public final Object mod;
        public final ModContainer container;
        private boolean dirty;

        public ModOrganiser(Object mod, ModContainer container) {
            this.mod = mod;
            this.container = container;
        }

        @Override
        public boolean canForceNewChunks(int required, int dim) {
            return required < ForgeChunkManager.ticketCountAvailableFor((Object)this.mod, (World)DimensionManager.getWorld((int)dim)) * ForgeChunkManager.getMaxChunkDepthFor((String)this.container.getModId());
        }

        @Override
        public void setDirty() {
            this.dirty = false;
        }

        @Override
        protected ForgeChunkManager.Ticket createTicket(int dimension) {
            return ForgeChunkManager.requestTicket((Object)this.mod, (World)DimensionManager.getWorld((int)dimension), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        }
    }

    private static class PlayerOrganiser
    extends ChunkLoaderOrganiser {
        private static boolean dirty;
        public final String username;

        public PlayerOrganiser(String username) {
            this.username = username;
        }

        @Override
        public boolean canForceNewChunks(int required, int dim) {
            return required + this.numLoadedChunks() < ChunkLoaderManager.getPlayerChunkLimit(this.username) && required < ForgeChunkManager.ticketCountAvailableFor((String)this.username) * ForgeChunkManager.getMaxChunkDepthFor((String)"ChickenChunks");
        }

        @Override
        public ForgeChunkManager.Ticket createTicket(int dimension) {
            return ForgeChunkManager.requestPlayerTicket((Object)ChickenChunks.instance, (String)this.username, (World)DimensionManager.getWorld((int)dimension), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        }

        @Override
        public void setDirty() {
            dirty = true;
        }
    }

    private static abstract class ChunkLoaderOrganiser
    extends TicketManager {
        private HashMap<Integer, HashSet<BlockCoord>> dormantLoaders = new HashMap();
        private HashMap<DimChunkCoord, LinkedList<IChickenChunkLoader>> forcedChunksByChunk = new HashMap();
        private HashMap<IChickenChunkLoader, HashSet<ChunkCoordIntPair>> forcedChunksByLoader = new HashMap();
        private HashMap<DimChunkCoord, Integer> timedUnloadQueue = new HashMap();
        private boolean reviving;
        private boolean dormant = false;

        private ChunkLoaderOrganiser() {
        }

        public boolean canForceNewChunks(int dimension, Collection<ChunkCoordIntPair> chunks) {
            if (this.dormant) {
                return true;
            }
            int required = 0;
            for (ChunkCoordIntPair coord : chunks) {
                LinkedList<IChickenChunkLoader> loaders = this.forcedChunksByChunk.get(new DimChunkCoord(dimension, coord));
                if (loaders != null && !loaders.isEmpty()) continue;
                ++required;
            }
            return this.canForceNewChunks(required, dimension);
        }

        public final int numLoadedChunks() {
            return this.forcedChunksByChunk.size();
        }

        public void addChunkLoader(IChickenChunkLoader loader) {
            if (this.reviving) {
                return;
            }
            int dim = CommonUtils.getDimension((World)loader.getWorld());
            if (this.dormant) {
                HashSet<Object> coords = this.dormantLoaders.get(dim);
                if (coords == null) {
                    coords = new HashSet();
                    this.dormantLoaders.put(dim, coords);
                }
                coords.add(loader.getPosition());
            } else {
                this.forcedChunksByLoader.put(loader, new HashSet());
                this.forceChunks(loader, dim, loader.getChunks());
            }
            this.setDirty();
        }

        public void remChunkLoader(IChickenChunkLoader loader) {
            int dim = CommonUtils.getDimension((World)loader.getWorld());
            if (this.dormant) {
                HashSet<BlockCoord> coords = this.dormantLoaders.get(dim);
                if (coords != null) {
                    coords.remove(loader.getPosition());
                }
            } else {
                HashSet<ChunkCoordIntPair> chunks = this.forcedChunksByLoader.remove(loader);
                if (chunks == null) {
                    return;
                }
                this.unforceChunks(loader, dim, chunks, true);
            }
            this.setDirty();
        }

        private void unforceChunks(IChickenChunkLoader loader, int dim, Collection<ChunkCoordIntPair> chunks, boolean remLoader) {
            for (ChunkCoordIntPair coord : chunks) {
                DimChunkCoord dimCoord = new DimChunkCoord(dim, coord);
                LinkedList<IChickenChunkLoader> loaders = this.forcedChunksByChunk.get(dimCoord);
                if (loaders == null || !loaders.remove(loader) || !loaders.isEmpty()) continue;
                this.forcedChunksByChunk.remove(dimCoord);
                this.timedUnloadQueue.put(dimCoord, 100);
            }
            if (!remLoader) {
                this.forcedChunksByLoader.get(loader).removeAll(chunks);
            }
            this.setDirty();
        }

        private void forceChunks(IChickenChunkLoader loader, int dim, Collection<ChunkCoordIntPair> chunks) {
            for (ChunkCoordIntPair coord : chunks) {
                DimChunkCoord dimCoord = new DimChunkCoord(dim, coord);
                LinkedList<IChickenChunkLoader> loaders = this.forcedChunksByChunk.get(dimCoord);
                if (loaders == null) {
                    loaders = new LinkedList();
                    this.forcedChunksByChunk.put(dimCoord, loaders);
                }
                if (loaders.isEmpty()) {
                    this.timedUnloadQueue.remove(dimCoord);
                    this.addChunk(dimCoord);
                }
                if (loaders.contains(loader)) continue;
                loaders.add(loader);
            }
            this.forcedChunksByLoader.get(loader).addAll(chunks);
            this.setDirty();
        }

        public abstract boolean canForceNewChunks(int var1, int var2);

        public abstract void setDirty();

        public void updateChunkLoader(IChickenChunkLoader loader) {
            HashSet<ChunkCoordIntPair> loaderChunks = this.forcedChunksByLoader.get(loader);
            if (loaderChunks == null) {
                this.addChunkLoader(loader);
                return;
            }
            HashSet<ChunkCoordIntPair> oldChunks = new HashSet<ChunkCoordIntPair>(loaderChunks);
            HashSet<ChunkCoordIntPair> newChunks = new HashSet<ChunkCoordIntPair>();
            for (ChunkCoordIntPair chunk : loader.getChunks()) {
                if (oldChunks.remove(chunk)) continue;
                newChunks.add(chunk);
            }
            int dim = CommonUtils.getDimension((World)loader.getWorld());
            if (!oldChunks.isEmpty()) {
                this.unforceChunks(loader, dim, oldChunks, false);
            }
            if (!newChunks.isEmpty()) {
                this.forceChunks(loader, dim, newChunks);
            }
        }

        public void save(DataOutput dataout) throws IOException {
            dataout.writeInt(this.dormantLoaders.size());
            for (Map.Entry<Integer, HashSet<BlockCoord>> entry : this.dormantLoaders.entrySet()) {
                dataout.writeInt(entry.getKey());
                HashSet<BlockCoord> coords = entry.getValue();
                dataout.writeInt(coords.size());
                for (BlockCoord coord : coords) {
                    dataout.writeInt(coord.x);
                    dataout.writeInt(coord.y);
                    dataout.writeInt(coord.z);
                }
            }
            dataout.writeInt(this.forcedChunksByLoader.size());
            for (IChickenChunkLoader loader : this.forcedChunksByLoader.keySet()) {
                BlockCoord coord = loader.getPosition();
                dataout.writeInt(CommonUtils.getDimension((World)loader.getWorld()));
                dataout.writeInt(coord.x);
                dataout.writeInt(coord.y);
                dataout.writeInt(coord.z);
            }
        }

        public void load(DataInputStream datain) throws IOException {
            int dimensions = datain.readInt();
            for (int i = 0; i < dimensions; ++i) {
                int dim = datain.readInt();
                HashSet<BlockCoord> coords = new HashSet<BlockCoord>();
                this.dormantLoaders.put(dim, coords);
                int numCoords = datain.readInt();
                for (int j = 0; j < numCoords; ++j) {
                    coords.add(new BlockCoord(datain.readInt(), datain.readInt(), datain.readInt()));
                }
            }
            int numLoaders = datain.readInt();
            for (int i = 0; i < numLoaders; ++i) {
                int dim = datain.readInt();
                HashSet<Object> coords = this.dormantLoaders.get(dim);
                if (coords == null) {
                    coords = new HashSet();
                    this.dormantLoaders.put(dim, coords);
                }
                coords.add(new BlockCoord(datain.readInt(), datain.readInt(), datain.readInt()));
            }
        }

        public void revive() {
            if (!this.dormant) {
                return;
            }
            this.dormant = false;
            for (int dim : this.dormantLoaders.keySet()) {
                World world = ChunkLoaderManager.getWorld(dim, reloadDimensions);
                if (world == null) continue;
                this.revive(world);
            }
        }

        public void devive() {
            if (this.dormant) {
                return;
            }
            for (IChickenChunkLoader loader : new ArrayList<IChickenChunkLoader>(this.forcedChunksByLoader.keySet())) {
                int dim = CommonUtils.getDimension((World)loader.getWorld());
                HashSet<Object> coords = this.dormantLoaders.get(dim);
                if (coords == null) {
                    coords = new HashSet();
                    this.dormantLoaders.put(dim, coords);
                }
                coords.add(loader.getPosition());
                this.remChunkLoader(loader);
            }
            this.dormant = true;
        }

        public void revive(World world) {
            HashSet<BlockCoord> coords = this.dormantLoaders.get(CommonUtils.getDimension((World)world));
            if (coords == null) {
                return;
            }
            ArrayList<BlockCoord> verifyCoords = new ArrayList<BlockCoord>(coords);
            coords.clear();
            for (BlockCoord coord : verifyCoords) {
                this.reviving = true;
                TileEntity tile = world.func_147438_o(coord.x, coord.y, coord.z);
                this.reviving = false;
                if (!(tile instanceof IChickenChunkLoader)) continue;
                ChunkLoaderManager.addChunkLoader((IChickenChunkLoader)tile);
            }
        }

        public void setDormant() {
            this.dormant = true;
        }

        public boolean isDormant() {
            return this.dormant;
        }

        public void tickDownUnloads() {
            Iterator<Map.Entry<DimChunkCoord, Integer>> iterator = this.timedUnloadQueue.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<DimChunkCoord, Integer> entry = iterator.next();
                int ticks = entry.getValue();
                if (ticks <= 1) {
                    this.remChunk(entry.getKey());
                    iterator.remove();
                    continue;
                }
                entry.setValue(ticks - 1);
            }
        }
    }

    private static abstract class TicketManager {
        public HashMap<Integer, Stack<ForgeChunkManager.Ticket>> ticketsWithSpace = new HashMap();
        public HashMap<DimChunkCoord, ForgeChunkManager.Ticket> heldChunks = new HashMap();

        private TicketManager() {
        }

        protected void addChunk(DimChunkCoord coord) {
            ForgeChunkManager.Ticket ticket;
            if (this.heldChunks.containsKey(coord)) {
                return;
            }
            Stack<Object> freeTickets = this.ticketsWithSpace.get(coord.dimension);
            if (freeTickets == null) {
                freeTickets = new Stack();
                this.ticketsWithSpace.put(coord.dimension, freeTickets);
            }
            if (freeTickets.isEmpty()) {
                ticket = this.createTicket(coord.dimension);
                freeTickets.push(ticket);
            } else {
                ticket = freeTickets.peek();
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)coord.getChunkCoord());
            this.heldChunks.put(coord, ticket);
            if (ticket.getChunkList().size() == ticket.getChunkListDepth() && !freeTickets.isEmpty()) {
                freeTickets.pop();
            }
        }

        protected abstract ForgeChunkManager.Ticket createTicket(int var1);

        protected void remChunk(DimChunkCoord coord) {
            ForgeChunkManager.Ticket ticket = this.heldChunks.remove(coord);
            if (ticket == null) {
                return;
            }
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)coord.getChunkCoord());
            if (ticket.getChunkList().size() == ticket.getChunkListDepth() - 1) {
                Stack<Object> freeTickets = this.ticketsWithSpace.get(coord.dimension);
                if (freeTickets == null) {
                    freeTickets = new Stack();
                    this.ticketsWithSpace.put(coord.dimension, freeTickets);
                }
                freeTickets.push(ticket);
            }
        }

        protected void unloadDimension(int dimension) {
            this.ticketsWithSpace.remove(dimension);
        }
    }

    private static class DimChunkCoord {
        public final int dimension;
        public final int chunkX;
        public final int chunkZ;

        public DimChunkCoord(int dim, ChunkCoordIntPair coord) {
            this(dim, coord.field_77276_a, coord.field_77275_b);
        }

        public DimChunkCoord(int dim, int x, int z) {
            this.dimension = dim;
            this.chunkX = x;
            this.chunkZ = z;
        }

        public int hashCode() {
            return (this.chunkX * 31 + this.chunkZ) * 31 + this.dimension;
        }

        public boolean equals(Object o) {
            if (o instanceof DimChunkCoord) {
                DimChunkCoord o2 = (DimChunkCoord)o;
                return this.dimension == o2.dimension && this.chunkX == o2.chunkX && this.chunkZ == o2.chunkZ;
            }
            return false;
        }

        public ChunkCoordIntPair getChunkCoord() {
            return new ChunkCoordIntPair(this.chunkX, this.chunkZ);
        }
    }
}

