﻿#version 140

in vec3 aPosition;
in vec4 aColor;
in vec4 aNormal;

uniform mat4 uProjMatrix;
uniform mat4 uViewMatrix;
uniform mat4 uModelMatrix;
uniform mat4 uNormalMatrix;

out vec4 vColor;
out float vDot;

void main()
{
    gl_Position = uProjMatrix * uViewMatrix * uModelMatrix * vec4(aPosition, 1.0);
    vColor = aColor;

    vec3 lightDir = vec3(3.0, 5.0, 4.0);
    vec3 normal = normalize(vec3(uNormalMatrix * aNormal));
    vDot = max(dot(normal, normalize(lightDir)), 0.0);
}
