/*
 * Decompiled with CFR 0.152.
 */
package cscot.basicnetherores.util.handler;

import cscot.basicnetherores.init.BlockInit;
import cscot.basicnetherores.init.BlockOreInit;
import cscot.basicnetherores.init.IngotInit;
import cscot.basicnetherores.init.ItemInit;
import cscot.basicnetherores.registries.OreDictionaryRegistry;
import cscot.basicnetherores.util.handler.ConfigHandler;
import cscot.basicnetherores.util.interfaces.IHasModel;
import cscot.basicnetherores.world.gen.WorldGenCustomOres;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegistryHandler {
    @SubscribeEvent
    public static void onBlockOreRegister(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])BlockOreInit.BLOCKORES.toArray(new Block[0]));
    }

    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ItemInit.ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void onIngotRegister(RegistryEvent.Register<Item> event) {
        if (ConfigHandler.regeisterIngots) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])IngotInit.ITEMINGOTS.toArray(new Item[0]));
        }
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        if (ConfigHandler.regeisterIngots) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])BlockInit.BLOCKS.toArray(new Block[0]));
        }
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        for (Block block : BlockOreInit.BLOCKORES) {
            if (!(block instanceof IHasModel)) continue;
            ((IHasModel)block).registerModels();
        }
        for (Block block : BlockInit.BLOCKS) {
            if (!(block instanceof IHasModel)) continue;
            ((IHasModel)block).registerModels();
        }
        for (Item item : ItemInit.ITEMS) {
            if (!(item instanceof IHasModel)) continue;
            ((IHasModel)item).registerModels();
        }
        for (Item item : IngotInit.ITEMINGOTS) {
            if (!(item instanceof IHasModel)) continue;
            ((IHasModel)item).registerModels();
        }
    }

    public static void preInitRegistries(FMLPreInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenCustomOres(), (int)0);
        ConfigHandler.registerConfig(event);
    }

    public static void initRegistries(FMLInitializationEvent event) {
        GameRegistry.addSmelting((Block)BlockOreInit.ORE_NETHEREMERALD, (ItemStack)new ItemStack(Items.field_151166_bC), (float)1.0f);
        GameRegistry.addSmelting((Block)BlockOreInit.ORE_NETHERDIAMOND, (ItemStack)new ItemStack(Items.field_151045_i), (float)1.0f);
        GameRegistry.addSmelting((Block)BlockOreInit.ORE_NETHERREDSTONE, (ItemStack)new ItemStack(Items.field_151137_ax, 4), (float)1.0f);
        GameRegistry.addSmelting((Block)BlockOreInit.ORE_NETHERLAPIS, (ItemStack)new ItemStack(Items.field_151100_aR, 4, 4), (float)1.0f);
        GameRegistry.addSmelting((Block)BlockOreInit.ORE_NETHERCOAL, (ItemStack)new ItemStack(Items.field_151044_h), (float)0.7f);
        GameRegistry.addSmelting((Block)BlockOreInit.ORE_NETHERGOLD, (ItemStack)new ItemStack(Items.field_151043_k), (float)1.0f);
        GameRegistry.addSmelting((Block)BlockOreInit.ORE_NETHERIRON, (ItemStack)new ItemStack(Items.field_151042_j), (float)0.7f);
        GameRegistry.addSmelting((Block)BlockOreInit.ORE_NETHERCOPPER, (ItemStack)new ItemStack(IngotInit.INGOT_COPPER), (float)0.7f);
        GameRegistry.addSmelting((Block)BlockOreInit.ORE_NETHERTIN, (ItemStack)new ItemStack(IngotInit.INGOT_TIN), (float)0.7f);
    }

    public static void postInitRegistries(FMLPostInitializationEvent event) {
        OreDictionaryRegistry.registerDictionaryOres();
    }
}

