/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged.util;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.silvercatcher.reforged.proxy.CommonProxy;

public class Helpers {
    public static boolean blockPosEqual(BlockPos pos1, BlockPos pos2) {
        int x1 = pos1.func_177958_n();
        int x2 = pos2.func_177958_n();
        int y1 = pos1.func_177956_o();
        int y2 = pos2.func_177956_o();
        int z1 = pos1.func_177952_p();
        int z2 = pos2.func_177952_p();
        return x1 == x2 && y1 == y2 && z1 == z2;
    }

    public static boolean consumeInventoryItem(EntityPlayer player, Item itemIn) {
        int i = player.func_184614_ca().func_185136_b(new ItemStack(itemIn)) ? player.field_71071_by.field_70461_c : Helpers.getInventorySlotContainItem(player, itemIn);
        if (i < 0) {
            return false;
        }
        ItemStack item = (ItemStack)player.field_71071_by.field_70462_a.get(i);
        item.func_190918_g(1);
        if (item.func_190916_E() <= 0) {
            player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
        }
        return true;
    }

    public static void destroyCurrentEquippedItem(EntityPlayer player) {
        ItemStack orig = player.field_71071_by.func_70448_g();
        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
        ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)orig, (EnumHand)EnumHand.MAIN_HAND);
    }

    public static void drawRectangle(int left, int top, int right, int bottom, float[] color) {
        int j1;
        if (left < right) {
            j1 = left;
            left = right;
            right = j1;
        }
        if (top < bottom) {
            j1 = top;
            top = bottom;
            bottom = j1;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)color[0], (float)color[1], (float)color[2], (float)color[3]);
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b((double)left, (double)bottom, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)right, (double)bottom, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)right, (double)top, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static int getInventorySlotContainItem(EntityPlayer player, Item itemIn) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            if (!((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_185136_b(new ItemStack(itemIn))) continue;
            return i;
        }
        return -1;
    }

    public static RayTraceResult getMouseOverExtended(float distance) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        Entity theRenderViewEntity = mc.func_175606_aa();
        AxisAlignedBB theViewBoundingBox = new AxisAlignedBB(theRenderViewEntity.field_70165_t - 0.5, theRenderViewEntity.field_70163_u - 0.0, theRenderViewEntity.field_70161_v - 0.5, theRenderViewEntity.field_70165_t + 0.5, theRenderViewEntity.field_70163_u + 1.5, theRenderViewEntity.field_70161_v + 0.5);
        RayTraceResult returnMOP = null;
        if (mc.field_71441_e != null) {
            double var2 = distance;
            returnMOP = theRenderViewEntity.func_174822_a(var2, 0.0f);
            double calcdist = var2;
            Vec3d pos = theRenderViewEntity.func_174824_e(0.0f);
            var2 = calcdist;
            if (returnMOP != null) {
                calcdist = returnMOP.field_72307_f.func_72438_d(pos);
            }
            Vec3d lookvec = theRenderViewEntity.func_70676_i(0.0f);
            Vec3d var8 = pos.func_72441_c(lookvec.field_72450_a * var2, lookvec.field_72448_b * var2, lookvec.field_72449_c * var2);
            Entity pointedEntity = null;
            float var9 = 1.0f;
            List list = mc.field_71441_e.func_72839_b(theRenderViewEntity, theViewBoundingBox.func_72321_a(lookvec.field_72450_a * var2, lookvec.field_72448_b * var2, lookvec.field_72449_c * var2).func_72321_a((double)var9, (double)var9, (double)var9));
            double d = calcdist;
            for (Entity entity : list) {
                double d1;
                if (!entity.func_70067_L()) continue;
                float bordersize = entity.func_70111_Y();
                AxisAlignedBB aabb = new AxisAlignedBB(entity.field_70165_t - (double)(entity.field_70130_N / 2.0f), entity.field_70163_u, entity.field_70161_v - (double)(entity.field_70130_N / 2.0f), entity.field_70165_t + (double)(entity.field_70130_N / 2.0f), entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v + (double)(entity.field_70130_N / 2.0f));
                aabb.func_72321_a((double)bordersize, (double)bordersize, (double)bordersize);
                RayTraceResult mop0 = aabb.func_72327_a(pos, var8);
                if (aabb.func_72318_a(pos)) {
                    if (!(0.0 < d) && d != 0.0) continue;
                    pointedEntity = entity;
                    d = 0.0;
                    continue;
                }
                if (mop0 == null || !((d1 = pos.func_72438_d(mop0.field_72307_f)) < d) && d != 0.0) continue;
                pointedEntity = entity;
                d = d1;
            }
            if (pointedEntity != null && (d < calcdist || returnMOP == null)) {
                returnMOP = new RayTraceResult(pointedEntity);
            }
        }
        return returnMOP;
    }

    public static void playSound(World w, Entity e, String name, double volume, double pitch) {
        Helpers.playSound(w, e, name, (float)volume, (float)pitch);
    }

    public static void playSound(World w, Entity e, String name, float volume, float pitch) {
        w.func_184148_a(null, e.field_70165_t, e.field_70163_u, e.field_70161_v, CommonProxy.getSound(name), SoundCategory.MASTER, volume, pitch);
    }
}

