/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged.material;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import org.silvercatcher.reforged.material.MaterialDefinition;

public class MaterialManager {
    private static final HashMap<Item.ToolMaterial, MaterialDefinition> definitionMap = new HashMap();
    private static final HashMap<Item.ToolMaterial, Item[]> itemMap = new HashMap();
    private static final HashMap<Item.ToolMaterial, ResourceLocation[]> textureMap = new HashMap();

    public static void addMaterialDefinition(Item.ToolMaterial material, MaterialDefinition definition) {
        definitionMap.put(material, definition);
    }

    public static void addOthers(Item.ToolMaterial material, ResourceLocation[] textures, Item[] items) {
        textureMap.put(material, textures);
        itemMap.put(material, items);
    }

    public static Set<Map.Entry<Item.ToolMaterial, MaterialDefinition>> getEntries() {
        return definitionMap.entrySet();
    }

    public static Item[] getItems(Item.ToolMaterial material) {
        return itemMap.get(material);
    }

    public static MaterialDefinition getMaterialDefinition(Item.ToolMaterial material) {
        return definitionMap.get(material);
    }

    public static ResourceLocation[] getTextures(Item.ToolMaterial material) {
        return textureMap.get(material);
    }

    public static boolean isFullyAdded(Item.ToolMaterial tm) {
        return definitionMap.containsKey(tm) && textureMap.containsKey(tm) && itemMap.containsKey(tm);
    }

    static {
        definitionMap.put(Item.ToolMaterial.WOOD, new MaterialDefinition("wooden", Item.ToolMaterial.WOOD));
        definitionMap.put(Item.ToolMaterial.STONE, new MaterialDefinition("stone", Item.ToolMaterial.STONE));
        definitionMap.put(Item.ToolMaterial.IRON, new MaterialDefinition("iron", Item.ToolMaterial.IRON));
        definitionMap.put(Item.ToolMaterial.GOLD, new MaterialDefinition("golden", Item.ToolMaterial.GOLD));
        definitionMap.put(Item.ToolMaterial.DIAMOND, new MaterialDefinition("diamond", Item.ToolMaterial.DIAMOND));
    }
}

