/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged.entities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.silvercatcher.reforged.api.AReforgedThrowable;
import org.silvercatcher.reforged.api.ReforgedAdditions;
import org.silvercatcher.reforged.items.others.ItemDart;

public class EntityDart
extends AReforgedThrowable {
    public static final DataParameter<ItemStack> STACK = EntityDataManager.func_187226_a(EntityDart.class, (DataSerializer)DataSerializers.field_187196_f);

    public EntityDart(World worldIn) {
        super(worldIn, "dart");
    }

    public EntityDart(World worldIn, EntityLivingBase getThrowerIn, ItemStack stack) {
        super(worldIn, getThrowerIn, stack, "dart");
        this.setItemStack(stack);
        this.setInited();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STACK, (Object)new ItemStack(ReforgedAdditions.DART_NORMAL));
    }

    public String getEffect() {
        return ((ItemDart)this.getItemStack().func_77973_b()).func_77658_a().substring(10);
    }

    @Override
    protected float func_70185_h() {
        return 0.03f;
    }

    @Override
    protected float getImpactDamage(Entity target) {
        return 5.0f;
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(STACK);
    }

    private Potion getPotion(String name) {
        return Potion.func_180142_b((String)name);
    }

    @Override
    protected boolean onBlockHit(BlockPos blockPos) {
        if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(4) == 0 && !this.creativeUse()) {
            this.func_70099_a(new ItemStack(Items.field_151008_G), 1.0f);
        }
        return true;
    }

    @Override
    protected boolean onEntityHit(Entity entity) {
        entity.func_70097_a(this.causeImpactDamage(entity, this.func_85052_h()), this.getImpactDamage(entity));
        if (!entity.field_70128_L && entity instanceof EntityLivingBase) {
            EntityLivingBase p = (EntityLivingBase)entity;
            switch (this.getEffect()) {
                case "normal": {
                    break;
                }
                case "hunger": {
                    p.func_70690_d(new PotionEffect(this.getPotion("hunger"), 300, 1));
                    break;
                }
                case "poison": {
                    p.func_70690_d(new PotionEffect(this.getPotion("poison"), 200, 1));
                    break;
                }
                case "poison_strong": {
                    p.func_70690_d(new PotionEffect(this.getPotion("poison"), 300, 2));
                    break;
                }
                case "slowness": {
                    p.func_70690_d(new PotionEffect(this.getPotion("slowness"), 300, 1));
                    p.func_70690_d(new PotionEffect(this.getPotion("mining_fatigue"), 300, 1));
                    break;
                }
                case "wither": {
                    p.func_70690_d(new PotionEffect(this.getPotion("wither"), 300, 1));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No effect called " + this.getEffect().substring(5) + " found!");
                }
            }
        }
        return true;
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setItemStack(new ItemStack(tagCompund.func_74775_l("item")));
    }

    public void setItemStack(ItemStack stack) {
        if (stack == null || stack.func_190926_b() || !stack.func_77973_b().func_77658_a().contains("dart")) {
            throw new IllegalArgumentException("Invalid Itemstack!");
        }
        this.field_70180_af.func_187227_b(STACK, (Object)stack);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (this.getItemStack() != null && !this.getItemStack().func_190926_b()) {
            tagCompound.func_74782_a("item", (NBTBase)this.getItemStack().func_77955_b(new NBTTagCompound()));
        }
    }
}

