/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged.api;

import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.silvercatcher.reforged.ReforgedMod;
import org.silvercatcher.reforged.api.CompoundTags;
import org.silvercatcher.reforged.api.ItemExtension;
import org.silvercatcher.reforged.util.Helpers;

public abstract class AReloadable
extends ItemBow
implements ItemExtension {
    public static final byte empty = 0;
    public static final byte loading = 1;
    public static final byte loaded = 2;
    private Item ammo;
    private String shootsound;

    public AReloadable(String name, String shootsound) {
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.func_77655_b(name);
        this.func_77637_a(ReforgedMod.tabReforged);
        this.shootsound = shootsound;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        byte loadState = this.giveCompound(stack).func_74771_c("ammo");
        tooltip.add(I18n.func_135052_a((String)"item.musket.loadstate", (Object[])new Object[0]) + ": " + (loadState == 0 ? I18n.func_135052_a((String)"item.musket.loadstate.empty", (Object[])new Object[0]) : (loadState == 2 ? I18n.func_135052_a((String)"item.musket.loadstate.loaded", (Object[])new Object[0]) : I18n.func_135052_a((String)"item.musket.loadstate.loading", (Object[])new Object[0]))));
    }

    private Item getAmmo() {
        return this.ammo;
    }

    @Override
    public Multimap getAttributeModifiers(ItemStack stack) {
        return ItemExtension.super.getAttributeModifiers(stack);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.getHitDamage(), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", this.getAttackSpeed(null), 0));
        }
        return multimap;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        byte loadState = this.giveCompound(stack).func_74771_c("ammo");
        if (loadState == 1) {
            if (ReforgedMod.battlegearDetected) {
                return EnumAction.BOW;
            }
            return EnumAction.BLOCK;
        }
        if (loadState == 2) {
            return EnumAction.BOW;
        }
        return EnumAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        byte loadState = this.giveCompound(stack).func_74771_c("ammo");
        if (loadState == 1) {
            return this.getReloadTotal();
        }
        return super.func_77626_a(stack);
    }

    public int getReloadTime(ItemStack stack) {
        return this.giveCompound(stack).func_74762_e("time");
    }

    public abstract int getReloadTotal();

    public NBTTagCompound giveCompound(ItemStack stack) {
        NBTTagCompound compound = CompoundTags.giveCompound(stack);
        if (!compound.func_74764_b("ammo")) {
            compound.func_74774_a("ammo", (byte)0);
        }
        return compound;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            NBTTagCompound compound = this.giveCompound(playerIn.func_184614_ca());
            byte loadState = compound.func_74771_c("ammo");
            if (loadState == 0) {
                if (playerIn.field_71075_bZ.field_75098_d || Helpers.consumeInventoryItem(playerIn, this.getAmmo())) {
                    loadState = 1;
                    if (compound.func_74771_c("ammo") == 0) {
                        compound.func_74757_a("started", true);
                        compound.func_74768_a("time", 0);
                    }
                } else {
                    Helpers.playSound(worldIn, (Entity)playerIn, "shotgun_reload", 1.0f, 0.7f);
                }
            }
            compound.func_74774_a("ammo", loadState);
            if (compound.func_74762_e("time") <= 0 || !worldIn.field_72995_K || worldIn.field_72995_K && compound.func_74762_e("time") >= this.getReloadTotal() - 1) {
                playerIn.func_184598_c(hand);
            }
            return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184614_ca());
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184592_cb());
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase playerIn) {
        byte loadState = this.giveCompound(stack).func_74771_c("ammo");
        if (loadState == 1) {
            loadState = 2;
        }
        this.giveCompound(stack).func_74774_a("ammo", loadState);
        return stack;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase playerInl, int timeLeft) {
        if (!worldIn.field_72995_K && playerInl instanceof EntityPlayer) {
            EntityPlayerMP playerIn = (EntityPlayerMP)playerInl;
            NBTTagCompound compound = this.giveCompound(stack);
            byte loadState = compound.func_74771_c("ammo");
            if (loadState == 2) {
                Helpers.playSound(worldIn, (Entity)playerIn, this.shootsound, 1.0f, 1.0f);
                this.shoot(worldIn, (EntityLivingBase)playerIn, stack);
                if (!playerIn.field_71075_bZ.field_75098_d && stack.func_77973_b().func_77645_m() && stack.func_96631_a(5, field_77697_d, playerIn)) {
                    playerIn.func_70669_a(stack);
                    Helpers.destroyCurrentEquippedItem((EntityPlayer)playerIn);
                }
                compound.func_74774_a("ammo", (byte)0);
                compound.func_74757_a("started", false);
            }
            compound.func_74768_a("time", -1);
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!(entityIn instanceof EntityLivingBase)) {
            return;
        }
        if (this.giveCompound(stack).func_74767_n("started") && this.giveCompound(stack).func_74771_c("ammo") == 1 && ItemStack.func_77989_b((ItemStack)stack, (ItemStack)((EntityLivingBase)entityIn).func_184607_cu())) {
            this.giveCompound(stack).func_74768_a("time", this.getReloadTime(stack) + 1);
        }
    }

    protected void setAmmo(Item ammo) {
        this.ammo = ammo;
    }

    public abstract void shoot(World var1, EntityLivingBase var2, ItemStack var3);

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }
}

