/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged.api;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class AReforgedThrowable
extends EntityThrowable {
    public static final DataParameter<Boolean> INITIATED = EntityDataManager.func_187226_a(AReforgedThrowable.class, (DataSerializer)DataSerializers.field_187198_h);
    private final String damageName;

    public AReforgedThrowable(World worldIn, EntityLivingBase thrower, ItemStack stack, String damageName) {
        super(worldIn, thrower);
        this.damageName = damageName;
        this.func_70012_b(thrower.field_70165_t, thrower.field_70163_u + (double)thrower.func_70047_e(), thrower.field_70161_v, thrower.field_70177_z, thrower.field_70125_A);
        this.field_70165_t -= (double)MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.25;
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.25;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.5f, 1.0f);
    }

    public AReforgedThrowable(World worldIn, String damageName) {
        super(worldIn);
        this.damageName = damageName;
    }

    protected DamageSource causeImpactDamage(Entity target, EntityLivingBase shooter) {
        return new EntityDamageSourceIndirect(this.damageName, target, (Entity)shooter).func_76349_b();
    }

    public boolean creativeUse() {
        return this.creativeUse((Entity)this.func_85052_h());
    }

    public boolean creativeUse(Entity e) {
        return e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75098_d || !(e instanceof EntityPlayer);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(INITIATED, (Object)false);
    }

    protected float func_70185_h() {
        return 0.005f;
    }

    protected abstract float getImpactDamage(Entity var1);

    protected boolean isInited() {
        return (Boolean)this.field_70180_af.func_187225_a(INITIATED);
    }

    protected boolean onBlockHit(BlockPos blockPos) {
        return true;
    }

    protected boolean onEntityHit(Entity entity) {
        return true;
    }

    protected boolean onEntityHit(EntityLivingBase living) {
        return this.onEntityHit((Entity)living);
    }

    protected void func_70184_a(RayTraceResult target) {
        if (!this.field_70170_p.field_72995_K) {
            boolean broken;
            if (target.field_72308_g == null) {
                broken = this.field_70170_p.func_180495_p(target.func_178782_a()).func_185890_d((IBlockAccess)this.field_70170_p, target.func_178782_a()) != null ? this.onBlockHit(target.func_178782_a()) : false;
            } else {
                if (target.field_72308_g instanceof EntityLivingBase && target.field_72308_g.equals((Object)this.func_85052_h()) && this.field_70173_aa < 5) {
                    return;
                }
                broken = this.onEntityHit((Entity)(target.field_72308_g instanceof EntityLivingBase ? (EntityLivingBase)target.field_72308_g : target.field_72308_g));
            }
            if (broken) {
                this.func_70106_y();
            }
        }
    }

    public void func_70071_h_() {
        if (this.isInited()) {
            super.func_70071_h_();
            this.onUpdated();
        }
    }

    public void onUpdated() {
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.field_70180_af.func_187227_b(INITIATED, (Object)tagCompund.func_74767_n("initiated"));
    }

    public void setInited() {
        this.field_70180_af.func_187227_b(INITIATED, (Object)true);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("initiated", ((Boolean)this.field_70180_af.func_187225_a(INITIATED)).booleanValue());
    }
}

