/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.poweradapters.adapters;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjPassiveProvider;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.MjAPI;
import com.jarhax.poweradapters.ConfigurationHandler;
import com.jarhax.poweradapters.InternalBattery;
import com.jarhax.poweradapters.adapters.IPowerAdapter;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class MjAdapter
extends IPowerAdapter
implements IMjReceiver,
IMjPassiveProvider {
    public MjAdapter(InternalBattery battery) {
        super(battery);
    }

    @Override
    public long getExchangeRate() {
        return ConfigurationHandler.worthMinecraftJoules;
    }

    @Override
    public void distributePower(World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (world.func_175625_s(pos.func_177972_a(facing)) == null || !world.func_175625_s(pos.func_177972_a(facing)).hasCapability(MjAPI.CAP_RECEIVER, facing.func_176734_d())) continue;
            IMjReceiver storage = (IMjReceiver)world.func_175625_s(pos.func_177972_a(facing)).getCapability(MjAPI.CAP_RECEIVER, facing.func_176734_d());
            long power = this.extractPower(0L, this.getLocalOutput(), true);
            long unconsumed = storage.receivePower(power * MjAPI.ONE_MINECRAFT_JOULE, true) / MjAPI.ONE_MINECRAFT_JOULE;
            this.extractPower(0L, power - unconsumed, false);
            storage.receivePower(power * MjAPI.ONE_MINECRAFT_JOULE, false);
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == MjAPI.CAP_PASSIVE_PROVIDER || capability == MjAPI.CAP_CONNECTOR || capability == MjAPI.CAP_RECEIVER;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == MjAPI.CAP_PASSIVE_PROVIDER || capability == MjAPI.CAP_CONNECTOR || capability == MjAPI.CAP_RECEIVER) {
            return (T)this;
        }
        return null;
    }

    public boolean canConnect(IMjConnector other) {
        return true;
    }

    public long getPowerRequested() {
        return Math.min(this.getLocalInput(), this.getLocalCapacity() - this.getLocalStored());
    }

    public long receivePower(long microJoules, boolean simulate) {
        return this.addPower(microJoules, simulate);
    }

    public long extractPower(long min, long max, boolean simulate) {
        return this.takePower(max, simulate);
    }
}

