/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.BCModules;
import buildcraft.api.core.BCLog;
import buildcraft.api.facades.FacadeAPI;
import buildcraft.api.schematics.SchematicBlockFactoryRegistry;
import buildcraft.lib.config.EnumRestartRequirement;
import buildcraft.lib.registry.CreativeTabManager;
import buildcraft.lib.registry.RegistryConfig;
import buildcraft.lib.registry.TagManager;
import buildcraft.silicon.plug.FacadeStateManager;
import buildcraft.transport.BCTransportBlocks;
import buildcraft.transport.BCTransportConfig;
import buildcraft.transport.BCTransportEventDist;
import buildcraft.transport.BCTransportItems;
import buildcraft.transport.BCTransportPipes;
import buildcraft.transport.BCTransportPlugs;
import buildcraft.transport.BCTransportProxy;
import buildcraft.transport.BCTransportRegistries;
import buildcraft.transport.BCTransportStatements;
import buildcraft.transport.pipe.SchematicBlockPipe;
import java.util.function.Consumer;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

@Mod(modid="buildcrafttransport", name="BuildCraft Transport", version="7.99.17", dependencies="required-after:buildcraftcore@[7.99.17]", acceptedMinecraftVersions="[1.12.2]")
public class BCTransport {
    public static final String MODID = "buildcrafttransport";
    @Mod.Instance(value="buildcrafttransport")
    public static BCTransport INSTANCE = null;
    private static CreativeTabManager.CreativeTabBC tabPipes;
    private static CreativeTabManager.CreativeTabBC tabPlugs;
    private static int totalTantrumTime;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent evt) {
        RegistryConfig.useOtherModConfigFor(MODID, "buildcraftcore");
        tabPipes = CreativeTabManager.createTab("buildcraft.pipes");
        tabPlugs = CreativeTabManager.createTab("buildcraft.plugs");
        BCTransportRegistries.preInit();
        BCTransportConfig.preInit();
        BCTransportBlocks.preInit();
        BCTransportPipes.preInit();
        BCTransportPlugs.preInit();
        BCTransportItems.preInit();
        BCTransportStatements.preInit();
        BCTransportConfig.reloadConfig(EnumRestartRequirement.GAME);
        tabPipes.setItem((Item)BCTransportItems.pipeItemDiamond);
        tabPlugs.setItem(BCTransportItems.plugBlocker);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)BCTransportProxy.getProxy());
        SchematicBlockFactoryRegistry.registerFactory("pipe", 300, SchematicBlockPipe::predicate, SchematicBlockPipe::new);
        BCTransportProxy.getProxy().fmlPreInit();
        MinecraftForge.EVENT_BUS.register((Object)BCTransportEventDist.INSTANCE);
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent evt) {
        BCTransportProxy.getProxy().fmlInit();
        BCTransportRegistries.init();
    }

    @Mod.EventHandler
    public static void onImcEvent(FMLInterModComms.IMCEvent imc) {
        for (FMLInterModComms.IMCMessage message : imc.getMessages()) {
            if (!FacadeAPI.isFacadeMessageId(message.key)) continue;
            BCLog.logger.warn("[transport] Recieved a facade IMC message that should be directed to 'buildcraftsilicon' instead!");
            new IllegalArgumentException().printStackTrace();
            int time = 1000;
            if (time + totalTantrumTime > 15000) {
                time = 0;
            } else {
                totalTantrumTime += time;
                try {
                    Thread.sleep(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!BCModules.SILICON.isLoaded()) continue;
            FacadeStateManager.receiveInterModComms(message);
        }
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent evt) {
        BCTransportProxy.getProxy().fmlPostInit();
    }

    private static TagManager.TagEntry registerTag(String id) {
        return TagManager.registerTag(id);
    }

    private static void startBatch() {
        TagManager.startBatch();
    }

    private static void endBatch(Consumer<TagManager.TagEntry> consumer) {
        TagManager.endBatch(consumer);
    }

    static {
        BCTransport.startBatch();
        BCTransport.registerTag("item.waterproof").reg("waterproof").locale("pipeWaterproof").oldReg("pipeWaterproof").model("waterproof");
        BCTransport.registerTag("item.plug.blocker").reg("plug_blocker").locale("PipePlug").model("plug_blocker").tab("buildcraft.plugs");
        BCTransport.registerTag("item.plug.power_adaptor").reg("plug_power_adaptor").locale("PipePowerAdapter").model("plug_power_adaptor").tab("buildcraft.plugs");
        BCTransport.registerTag("item.wire").reg("wire").locale("pipeWire").model("wire/").tab("buildcraft.plugs");
        BCTransport.startBatch();
        BCTransport.registerTag("item.pipe.buildcrafttransport.structure").reg("pipe_structure").locale("PipeStructureCobblestone");
        BCTransport.registerTag("item.pipe.buildcrafttransport.wood_item").reg("pipe_wood_item").locale("PipeItemsWood");
        BCTransport.registerTag("item.pipe.buildcrafttransport.wood_fluid").reg("pipe_wood_fluid").locale("PipeFluidsWood");
        BCTransport.registerTag("item.pipe.buildcrafttransport.wood_power").reg("pipe_wood_power").locale("PipePowerWood");
        BCTransport.registerTag("item.pipe.buildcrafttransport.stone_item").reg("pipe_stone_item").locale("PipeItemsStone");
        BCTransport.registerTag("item.pipe.buildcrafttransport.stone_fluid").reg("pipe_stone_fluid").locale("PipeFluidsStone");
        BCTransport.registerTag("item.pipe.buildcrafttransport.stone_power").reg("pipe_stone_power").locale("PipePowerStone");
        BCTransport.registerTag("item.pipe.buildcrafttransport.cobblestone_item").reg("pipe_cobble_item").locale("PipeItemsCobblestone");
        BCTransport.registerTag("item.pipe.buildcrafttransport.cobblestone_fluid").reg("pipe_cobble_fluid").locale("PipeFluidsCobblestone");
        BCTransport.registerTag("item.pipe.buildcrafttransport.cobblestone_power").reg("pipe_cobble_power").locale("PipePowerCobblestone");
        BCTransport.registerTag("item.pipe.buildcrafttransport.quartz_item").reg("pipe_quartz_item").locale("PipeItemsQuartz");
        BCTransport.registerTag("item.pipe.buildcrafttransport.quartz_fluid").reg("pipe_quartz_fluid").locale("PipeFluidsQuartz");
        BCTransport.registerTag("item.pipe.buildcrafttransport.quartz_power").reg("pipe_quartz_power").locale("PipePowerQuartz");
        BCTransport.registerTag("item.pipe.buildcrafttransport.gold_item").reg("pipe_gold_item").locale("PipeItemsGold");
        BCTransport.registerTag("item.pipe.buildcrafttransport.gold_fluid").reg("pipe_gold_fluid").locale("PipeFluidsGold");
        BCTransport.registerTag("item.pipe.buildcrafttransport.gold_power").reg("pipe_gold_power").locale("PipePowerGold");
        BCTransport.registerTag("item.pipe.buildcrafttransport.sandstone_item").reg("pipe_sandstone_item").locale("PipeItemsSandstone");
        BCTransport.registerTag("item.pipe.buildcrafttransport.sandstone_fluid").reg("pipe_sandstone_fluid").locale("PipeFluidsSandstone");
        BCTransport.registerTag("item.pipe.buildcrafttransport.sandstone_power").reg("pipe_sandstone_power").locale("PipePowerSandstone");
        BCTransport.registerTag("item.pipe.buildcrafttransport.iron_item").reg("pipe_iron_item").locale("PipeItemsIron");
        BCTransport.registerTag("item.pipe.buildcrafttransport.iron_fluid").reg("pipe_iron_fluid").locale("PipeFluidsIron");
        BCTransport.registerTag("item.pipe.buildcrafttransport.iron_power").reg("pipe_iron_power").locale("PipePowerIron");
        BCTransport.registerTag("item.pipe.buildcrafttransport.diamond_item").reg("pipe_diamond_item").locale("PipeItemsDiamond");
        BCTransport.registerTag("item.pipe.buildcrafttransport.diamond_fluid").reg("pipe_diamond_fluid").locale("PipeFluidsDiamond");
        BCTransport.registerTag("item.pipe.buildcrafttransport.diamond_power").reg("pipe_diamond_power").locale("PipePowerDiamond");
        BCTransport.registerTag("item.pipe.buildcrafttransport.diamond_wood_item").reg("pipe_diamond_wood_item").locale("PipeItemsEmerald");
        BCTransport.registerTag("item.pipe.buildcrafttransport.diamond_wood_fluid").reg("pipe_diamond_wood_fluid").locale("PipeFluidsEmerald");
        BCTransport.registerTag("item.pipe.buildcrafttransport.diamond_wood_power").reg("pipe_diamond_wood_power").locale("PipePowerEmerald");
        BCTransport.registerTag("item.pipe.buildcrafttransport.clay_item").reg("pipe_clay_item").locale("PipeItemsClay");
        BCTransport.registerTag("item.pipe.buildcrafttransport.clay_fluid").reg("pipe_clay_fluid").locale("PipeFluidsClay");
        BCTransport.registerTag("item.pipe.buildcrafttransport.void_item").reg("pipe_void_item").locale("PipeItemsVoid");
        BCTransport.registerTag("item.pipe.buildcrafttransport.void_fluid").reg("pipe_void_fluid").locale("PipeFluidsVoid");
        BCTransport.registerTag("item.pipe.buildcrafttransport.obsidian_item").reg("pipe_obsidian_item").locale("PipeItemsObsidian");
        BCTransport.registerTag("item.pipe.buildcrafttransport.obsidian_fluid").reg("pipe_obsidian_fluid").locale("PipeFluidsObsidian");
        BCTransport.registerTag("item.pipe.buildcrafttransport.lapis_item").reg("pipe_lapis_item").locale("PipeItemsLapis");
        BCTransport.registerTag("item.pipe.buildcrafttransport.daizuli_item").reg("pipe_daizuli_item").locale("PipeItemsDaizuli");
        BCTransport.registerTag("item.pipe.buildcrafttransport.emzuli_item").reg("pipe_emzuli_item").locale("PipeItemsEmzuli");
        BCTransport.registerTag("item.pipe.buildcrafttransport.stripes_item").reg("pipe_stripes_item").locale("PipeItemsStripes");
        BCTransport.registerTag("item.pipe.buildcrafttransport.wood_power_2").reg("pipe_wood_power_2").locale("PipePowerWood2");
        BCTransport.registerTag("item.pipe.buildcrafttransport.quartz_power_2").reg("pipe_quartz_power_2").locale("PipePowerQuartz2");
        BCTransport.endBatch(TagManager.setTab("buildcraft.pipes"));
        BCTransport.registerTag("item.block.filtered_buffer").reg("filtered_buffer").locale("filteredBufferBlock").model("filtered_buffer");
        BCTransport.registerTag("block.filtered_buffer").reg("filtered_buffer").oldReg("filteredBufferBlock").locale("filteredBufferBlock").model("filtered_buffer");
        BCTransport.registerTag("block.pipe_holder").reg("pipe_holder").locale("pipeHolder");
        BCTransport.registerTag("tile.filtered_buffer").reg("filtered_buffer");
        BCTransport.registerTag("tile.pipe_holder").reg("pipe_holder");
        BCTransport.endBatch(TagManager.prependTags("buildcrafttransport:", TagManager.EnumTagType.REGISTRY_NAME, TagManager.EnumTagType.MODEL_LOCATION).andThen(TagManager.setTab("buildcraft.main")));
    }
}

