/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.tile;

import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.mj.ILaserTarget;
import buildcraft.api.mj.ILaserTargetBlock;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.mj.MjBattery;
import buildcraft.api.mj.MjCapabilityHelper;
import buildcraft.api.properties.BuildCraftProperties;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.lib.block.ILocalBlockUpdateSubscriber;
import buildcraft.lib.block.LocalBlockUpdateNotifier;
import buildcraft.lib.client.render.DetachedRenderer;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.VolumeUtil;
import buildcraft.lib.misc.data.AverageLong;
import buildcraft.lib.misc.data.Box;
import buildcraft.lib.mj.MjBatteryReceiver;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.silicon.BCSiliconBlocks;
import buildcraft.silicon.client.render.AdvDebuggerLaser;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileLaser
extends TileBC_Neptune
implements ITickable,
IDebuggable,
ILocalBlockUpdateSubscriber {
    private static final int TARGETING_RANGE = 6;
    private final SafeTimeTracker clientLaserMoveInterval = new SafeTimeTracker(5L, 10L);
    private final SafeTimeTracker serverTargetMoveInterval = new SafeTimeTracker(10L, 20L);
    private final List<BlockPos> targetPositions = new ArrayList<BlockPos>();
    private BlockPos targetPos;
    public Vec3d laserPos;
    private boolean worldHasUpdated = true;
    private final AverageLong avgPower = new AverageLong(100);
    private long averageClient;
    private final MjBattery battery = new MjBattery(1024L * MjAPI.MJ);

    public TileLaser() {
        this.caps.addProvider(new MjCapabilityHelper(new MjBatteryReceiver(this.battery)));
    }

    @Override
    public int getUpdateRange() {
        return 6;
    }

    @Override
    public BlockPos getSubscriberPos() {
        return this.func_174877_v();
    }

    @Override
    public void setWorldUpdated(World world, BlockPos eventPos, IBlockState oldState, IBlockState newState, int flags) {
        this.worldHasUpdated = true;
    }

    private void findPossibleTargets() {
        this.targetPositions.clear();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() != BCSiliconBlocks.laser) {
            return;
        }
        EnumFacing face = (EnumFacing)state.func_177229_b(BuildCraftProperties.BLOCK_FACING_6);
        VolumeUtil.iterateCone(this.field_145850_b, this.field_174879_c, face, 6, true, (w, s, p, visible) -> {
            TileEntity tileAt;
            if (!visible) {
                return;
            }
            IBlockState stateAt = this.field_145850_b.func_180495_p(p);
            if (stateAt.func_177230_c() instanceof ILaserTargetBlock && (tileAt = this.field_145850_b.func_175625_s(p)) instanceof ILaserTarget) {
                this.targetPositions.add(p);
            }
        });
    }

    private void randomlyChooseTargetPos() {
        ArrayList<BlockPos> targetsNeedingPower = new ArrayList<BlockPos>();
        for (BlockPos position : this.targetPositions) {
            if (!this.isPowerNeededAt(position)) continue;
            targetsNeedingPower.add(position);
        }
        if (targetsNeedingPower.isEmpty()) {
            this.targetPos = null;
            return;
        }
        this.targetPos = (BlockPos)targetsNeedingPower.get(this.field_145850_b.field_73012_v.nextInt(targetsNeedingPower.size()));
    }

    private boolean isPowerNeededAt(BlockPos position) {
        TileEntity tile;
        if (position != null && (tile = this.field_145850_b.func_175625_s(position)) instanceof ILaserTarget) {
            ILaserTarget target = (ILaserTarget)tile;
            return target.getRequiredLaserPower() > 0L;
        }
        return false;
    }

    private ILaserTarget getTarget() {
        if (this.targetPos != null && this.field_145850_b.func_175625_s(this.targetPos) instanceof ILaserTarget) {
            return (ILaserTarget)this.field_145850_b.func_175625_s(this.targetPos);
        }
        return null;
    }

    private void updateLaser() {
        this.laserPos = this.targetPos != null ? new Vec3d((Vec3i)this.targetPos).func_72441_c(((double)(5 + this.field_145850_b.field_73012_v.nextInt(6)) + 0.5) / 16.0, 0.5625, ((double)(5 + this.field_145850_b.field_73012_v.nextInt(6)) + 0.5) / 16.0) : null;
    }

    public long getAverageClient() {
        return this.averageClient;
    }

    public long getMaxPowerPerTick() {
        return 4L * MjAPI.MJ;
    }

    public void func_73660_a() {
        ILaserTarget target;
        if (this.field_145850_b.field_72995_K) {
            if (this.clientLaserMoveInterval.markTimeIfDelay(this.field_145850_b) || this.targetPos == null) {
                this.updateLaser();
            }
            return;
        }
        this.avgPower.tick();
        BlockPos previousTargetPos = this.targetPos;
        if (this.worldHasUpdated) {
            this.findPossibleTargets();
            this.worldHasUpdated = false;
        }
        if (!this.isPowerNeededAt(this.targetPos)) {
            this.targetPos = null;
        }
        if (this.serverTargetMoveInterval.markTimeIfDelay(this.field_145850_b) || !this.isPowerNeededAt(this.targetPos)) {
            this.randomlyChooseTargetPos();
        }
        if ((target = this.getTarget()) != null) {
            long max = this.getMaxPowerPerTick();
            max *= this.battery.getStored() + max;
            max /= this.battery.getCapacity() / 2L;
            long power = this.battery.extractPower(0L, max = Math.min(Math.min(max, this.getMaxPowerPerTick()), target.getRequiredLaserPower()));
            long excess = target.receiveLaserPower(power);
            if (excess > 0L) {
                this.battery.addPowerChecking(excess, false);
            }
            this.avgPower.push(power - excess);
        } else {
            this.avgPower.clear();
        }
        if (Objects.equals(previousTargetPos, this.targetPos)) {
            // empty if block
        }
        this.sendNetworkUpdate(NET_RENDER_DATA);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("battery", (NBTBase)this.battery.serializeNBT());
        if (this.laserPos != null) {
            nbt.func_74782_a("laser_pos", (NBTBase)NBTUtilBC.writeVec3d(this.laserPos));
        }
        if (this.targetPos != null) {
            nbt.func_74782_a("target_pos", (NBTBase)NBTUtilBC.writeBlockPos(this.targetPos));
        }
        this.avgPower.writeToNbt(nbt, "average_power");
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("mj_battery")) {
            nbt.func_74782_a("battery", nbt.func_74781_a("mj_battery"));
        }
        this.battery.deserializeNBT(nbt.func_74775_l("battery"));
        this.targetPos = NBTUtilBC.readBlockPos(nbt.func_74781_a("target_pos"));
        this.laserPos = NBTUtilBC.readVec3d(nbt.func_74781_a("laser_pos"));
        this.avgPower.readFromNbt(nbt, "average_power");
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER && id == NET_RENDER_DATA) {
            this.battery.writeToBuffer((ByteBuf)buffer);
            buffer.writeBoolean(this.targetPos != null);
            if (this.targetPos != null) {
                MessageUtil.writeBlockPos(buffer, this.targetPos);
            }
            buffer.writeLong((long)this.avgPower.getAverage());
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT && id == NET_RENDER_DATA) {
            this.battery.readFromBuffer((ByteBuf)buffer);
            this.targetPos = buffer.readBoolean() ? MessageUtil.readBlockPos(buffer) : null;
            this.averageClient = buffer.readLong();
        }
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("battery = " + this.battery.getDebugString());
        left.add("target = " + this.targetPos);
        left.add("laser = " + this.laserPos);
        left.add("average = " + LocaleUtil.localizeMjFlow(this.averageClient == 0L ? (long)this.avgPower.getAverage() : this.averageClient));
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            LocalBlockUpdateNotifier.instance(this.field_145850_b).registerSubscriberForUpdateNotifications(this);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            LocalBlockUpdateNotifier.instance(this.field_145850_b).removeSubscriberFromUpdateNotifications(this);
        }
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new Box(this).extendToEncompass(this.targetPos).getBoundingBox();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public DetachedRenderer.IDetachedRenderer getDebugRenderer() {
        return new AdvDebuggerLaser(this);
    }
}

