/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.plug;

import buildcraft.api.transport.IWireEmitter;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.api.transport.pluggable.PluggableDefinition;
import buildcraft.api.transport.pluggable.PluggableModelKey;
import buildcraft.lib.expression.DefaultContexts;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.info.ContextInfo;
import buildcraft.lib.expression.info.VariableInfo;
import buildcraft.lib.expression.node.value.NodeVariableBoolean;
import buildcraft.lib.expression.node.value.NodeVariableObject;
import buildcraft.lib.misc.data.ModelVariableData;
import buildcraft.lib.net.IPayloadWriter;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.silicon.BCSiliconGuis;
import buildcraft.silicon.BCSiliconItems;
import buildcraft.silicon.client.model.key.KeyPlugGate;
import buildcraft.silicon.gate.EnumGateLogic;
import buildcraft.silicon.gate.EnumGateMaterial;
import buildcraft.silicon.gate.EnumGateModifier;
import buildcraft.silicon.gate.GateLogic;
import buildcraft.silicon.gate.GateVariant;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PluggableGate
extends PipePluggable
implements IWireEmitter {
    public static final FunctionContext MODEL_FUNC_CTX_STATIC;
    public static final FunctionContext MODEL_FUNC_CTX_DYNAMIC;
    private static final NodeVariableObject<String> MODEL_MATERIAL;
    private static final NodeVariableObject<String> MODEL_MODIFIER;
    private static final NodeVariableObject<String> MODEL_LOGIC;
    private static final NodeVariableObject<EnumFacing> MODEL_SIDE;
    private static final NodeVariableBoolean MODEL_IS_ON;
    public static final ContextInfo MODEL_VAR_INFO;
    private static final AxisAlignedBB[] BOXES;
    public final GateLogic logic;
    public final ModelVariableData clientModelData = new ModelVariableData();

    public PluggableGate(PluggableDefinition def, IPipeHolder holder, EnumFacing side, GateVariant variant) {
        super(def, holder, side);
        this.logic = new GateLogic(this, variant);
    }

    public PluggableGate(PluggableDefinition def, IPipeHolder holder, EnumFacing side, NBTTagCompound nbt) {
        super(def, holder, side);
        this.logic = new GateLogic(this, nbt.func_74775_l("data"));
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        nbt.func_74782_a("data", (NBTBase)this.logic.writeToNbt());
        return nbt;
    }

    public PluggableGate(PluggableDefinition def, IPipeHolder holder, EnumFacing side, PacketBuffer buffer) {
        super(def, holder, side);
        this.logic = new GateLogic(this, PacketBufferBC.asPacketBufferBc((ByteBuf)buffer));
    }

    @Override
    public void writeCreationPayload(PacketBuffer buffer) {
        this.logic.writeCreationToBuf(PacketBufferBC.asPacketBufferBc((ByteBuf)buffer));
    }

    public void sendMessage(int id, IPayloadWriter writer) {
        IPipeHolder.PipeMessageReceiver to = IPipeHolder.PipeMessageReceiver.PLUGGABLES[this.side.ordinal()];
        this.holder.sendMessage(to, (PacketBuffer buffer) -> {
            buffer.writeByte(1);
            buffer.writeByte(id);
            writer.write(PacketBufferBC.asPacketBufferBc((ByteBuf)buffer));
        });
    }

    public void sendGuiMessage(int id, IPayloadWriter writer) {
        IPipeHolder.PipeMessageReceiver to = IPipeHolder.PipeMessageReceiver.PLUGGABLES[this.side.ordinal()];
        this.holder.sendGuiMessage(to, (PacketBuffer buffer) -> {
            buffer.writeByte(1);
            buffer.writeByte(id);
            writer.write(PacketBufferBC.asPacketBufferBc((ByteBuf)buffer));
        });
    }

    @Override
    public void writePayload(PacketBuffer buffer, Side side) {
        buffer.writeByte(0);
    }

    @Override
    public void readPayload(PacketBuffer b, Side side, MessageContext ctx) throws IOException {
        PacketBufferBC buffer = PacketBufferBC.asPacketBufferBc((ByteBuf)b);
        short id = buffer.readUnsignedByte();
        this.logic.readPayload(id, buffer, side, ctx);
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return BOXES[this.side.func_176745_a()];
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public ItemStack getPickStack() {
        return BCSiliconItems.plugGate.getStack(this.logic.variant);
    }

    @Override
    public PluggableModelKey getModelRenderKey(BlockRenderLayer layer) {
        if (layer == BlockRenderLayer.CUTOUT) {
            return new KeyPlugGate(this.side, this.logic.variant);
        }
        return null;
    }

    @Override
    public boolean onPluggableActivate(EntityPlayer player, RayTraceResult trace, float hitX, float hitY, float hitZ) {
        if (!player.field_70170_p.field_72995_K) {
            BlockPos pos = this.holder.getPipePos();
            BCSiliconGuis.GATE.openGui(player, pos, this.side.ordinal());
        }
        return true;
    }

    @Override
    public boolean isEmitting(EnumDyeColor colour) {
        return this.logic.isEmitting(colour);
    }

    @Override
    public void emitWire(EnumDyeColor colour) {
        this.logic.emitWire(colour);
    }

    @Override
    public void onTick() {
        this.logic.onTick();
        if (this.holder.getPipeWorld().field_72995_K) {
            this.clientModelData.tick();
        }
    }

    @Override
    public boolean canConnectToRedstone(@Nullable EnumFacing to) {
        return true;
    }

    public static void setClientModelVariables(EnumFacing side, GateVariant variant) {
        PluggableGate.MODEL_SIDE.value = side;
        PluggableGate.MODEL_MATERIAL.value = variant.material.tag;
        PluggableGate.MODEL_MODIFIER.value = variant.modifier.tag;
        PluggableGate.MODEL_LOGIC.value = variant.logic.tag;
        PluggableGate.MODEL_IS_ON.value = false;
    }

    public void setClientModelVariables() {
        PluggableGate.setClientModelVariables(this.side, this.logic.variant);
        PluggableGate.MODEL_IS_ON.value = this.logic.isOn;
    }

    static {
        BOXES = new AxisAlignedBB[6];
        double ll = 0.125;
        double lu = 0.25;
        double ul = 0.75;
        double uu = 0.875;
        double min = 0.3125;
        double max = 0.6875;
        PluggableGate.BOXES[EnumFacing.DOWN.func_176745_a()] = new AxisAlignedBB(min, ll, min, max, lu, max);
        PluggableGate.BOXES[EnumFacing.UP.func_176745_a()] = new AxisAlignedBB(min, ul, min, max, uu, max);
        PluggableGate.BOXES[EnumFacing.NORTH.func_176745_a()] = new AxisAlignedBB(min, min, ll, max, max, lu);
        PluggableGate.BOXES[EnumFacing.SOUTH.func_176745_a()] = new AxisAlignedBB(min, min, ul, max, max, uu);
        PluggableGate.BOXES[EnumFacing.WEST.func_176745_a()] = new AxisAlignedBB(ll, min, min, lu, max, max);
        PluggableGate.BOXES[EnumFacing.EAST.func_176745_a()] = new AxisAlignedBB(ul, min, min, uu, max, max);
        MODEL_FUNC_CTX_STATIC = DefaultContexts.createWithAll();
        MODEL_MATERIAL = MODEL_FUNC_CTX_STATIC.putVariableString("material");
        MODEL_MODIFIER = MODEL_FUNC_CTX_STATIC.putVariableString("modifier");
        MODEL_LOGIC = MODEL_FUNC_CTX_STATIC.putVariableString("logic");
        MODEL_SIDE = MODEL_FUNC_CTX_STATIC.putVariableObject("side", EnumFacing.class);
        MODEL_FUNC_CTX_DYNAMIC = new FunctionContext(MODEL_FUNC_CTX_STATIC);
        MODEL_IS_ON = MODEL_FUNC_CTX_DYNAMIC.putVariableBoolean("on");
        MODEL_VAR_INFO = new ContextInfo(MODEL_FUNC_CTX_DYNAMIC);
        VariableInfo.VariableInfoObject<String> infoMaterial = MODEL_VAR_INFO.createInfoObject(MODEL_MATERIAL);
        infoMaterial.cacheType = VariableInfo.CacheType.ALWAYS;
        infoMaterial.setIsComplete = true;
        infoMaterial.possibleValues.addAll(Arrays.stream(EnumGateMaterial.VALUES).map(m -> m.tag).collect(Collectors.toList()));
        VariableInfo.VariableInfoObject<String> infoModifier = MODEL_VAR_INFO.createInfoObject(MODEL_MODIFIER);
        infoModifier.cacheType = VariableInfo.CacheType.ALWAYS;
        infoModifier.setIsComplete = true;
        infoModifier.possibleValues.addAll(Arrays.stream(EnumGateModifier.VALUES).map(m -> m.tag).collect(Collectors.toList()));
        VariableInfo.VariableInfoObject<String> infoLogic = MODEL_VAR_INFO.createInfoObject(MODEL_LOGIC);
        infoLogic.cacheType = VariableInfo.CacheType.ALWAYS;
        infoLogic.setIsComplete = true;
        infoLogic.possibleValues.addAll(Arrays.stream(EnumGateLogic.VALUES).map(m -> m.tag).collect(Collectors.toList()));
        VariableInfo.VariableInfoObject<EnumFacing> infoSide = MODEL_VAR_INFO.createInfoObject(MODEL_SIDE);
        infoSide.cacheType = VariableInfo.CacheType.ALWAYS;
        infoSide.setIsComplete = true;
        Collections.addAll(infoSide.possibleValues, EnumFacing.field_82609_l);
        VariableInfo.VariableInfoBoolean infoIsOn = MODEL_VAR_INFO.createInfoBoolean(MODEL_IS_ON);
        infoIsOn.cacheType = VariableInfo.CacheType.ALWAYS;
        infoIsOn.setIsComplete = true;
        infoIsOn.possibleValues = VariableInfo.VariableInfoBoolean.BooleanPossibilities.FALSE_TRUE;
    }
}

