/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.registry;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.transport.pipe.IItemPipe;
import java.io.File;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class RegistryConfig {
    public static final boolean DEBUG = BCDebugging.shouldDebugLog("lib.registry");
    private static final Map<ModContainer, Configuration> modObjectConfigs = new IdentityHashMap<ModContainer, Configuration>();

    public static Configuration setRegistryConfig(String modid, File file) {
        Configuration cfg = new Configuration(file);
        return RegistryConfig.setRegistryConfig(modid, cfg);
    }

    public static Configuration setRegistryConfig(String modid, Configuration config) {
        modObjectConfigs.put(RegistryConfig.getMod(modid), config);
        return config;
    }

    public static Configuration useOtherModConfigFor(String from, String to) {
        Configuration config = modObjectConfigs.get(RegistryConfig.getMod(to));
        if (config == null) {
            throw new IllegalStateException("Didn't find a config for " + to);
        }
        modObjectConfigs.put(RegistryConfig.getMod(from), config);
        return config;
    }

    public static boolean isEnabled(Item item) {
        return RegistryConfig.isEnabled(RegistryConfig.getCategory(item), item.getRegistryName().func_110623_a(), item.func_77658_a() + ".name");
    }

    public static boolean isEnabled(Block block) {
        return RegistryConfig.isEnabled(RegistryConfig.getCategory(block), block.getRegistryName().func_110623_a(), block.func_149739_a() + ".name");
    }

    public static boolean isEnabled(String category, String resourcePath, String langKey) {
        return RegistryConfig.isEnabled(RegistryConfig.getActiveMod(), category, resourcePath, langKey);
    }

    private static String getCategory(Object obj) {
        if (obj instanceof IItemPipe) {
            return "pipes";
        }
        if (obj instanceof Block) {
            return "blocks";
        }
        return "items";
    }

    private static boolean isEnabled(ModContainer activeMod, String category, String resourcePath, String langKey) {
        Configuration config = modObjectConfigs.get(activeMod);
        if (config == null) {
            throw new RuntimeException("No config exists for the mod " + activeMod.getModId());
        }
        Property prop = config.get(category, resourcePath, true);
        prop.setLanguageKey(langKey);
        prop.setRequiresMcRestart(true);
        prop.setRequiresWorldRestart(true);
        return prop.getBoolean(true);
    }

    private static ModContainer getMod(String modid) {
        ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(modid);
        if (container == null) {
            throw new RuntimeException("No mod with an id of \"" + modid + "\" is loaded!");
        }
        return container;
    }

    private static ModContainer getActiveMod() {
        ModContainer container = Loader.instance().activeModContainer();
        if (container == null) {
            throw new RuntimeException("Was not called within the scope of an active mod!");
        }
        return container;
    }
}

