/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.recipe;

import java.util.Arrays;

public class ChangingObject<T> {
    protected final T[] options;
    private final int hash;
    private int timeGap = 1000;

    public ChangingObject(T[] options) {
        if (options.length == 0) {
            throw new IllegalStateException("Must provide at least 1 option!");
        }
        this.options = options;
        this.hash = this.computeHash();
    }

    protected int computeHash() {
        return Arrays.hashCode(this.options);
    }

    public T get() {
        return this.get(0);
    }

    public T get(int indexOffset) {
        long now = System.currentTimeMillis() / (long)this.timeGap % (long)this.options.length;
        int i = (int)now + indexOffset;
        return this.options[i % this.options.length];
    }

    public void setTimeGap(int timeGap) {
        this.timeGap = timeGap;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ChangingObject other = (ChangingObject)obj;
        if (this.hash != other.hash) {
            return false;
        }
        return Arrays.equals(this.options, other.options);
    }
}

