/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc.data;

import buildcraft.lib.misc.data.AxisOrder;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.util.EnumFacing;

public enum EnumAxisOrder {
    XYZ(EnumFacing.Axis.X, EnumFacing.Axis.Y, EnumFacing.Axis.Z),
    XZY(EnumFacing.Axis.X, EnumFacing.Axis.Z, EnumFacing.Axis.Y),
    YXZ(EnumFacing.Axis.Y, EnumFacing.Axis.X, EnumFacing.Axis.Z),
    YZX(EnumFacing.Axis.Y, EnumFacing.Axis.Z, EnumFacing.Axis.X),
    ZXY(EnumFacing.Axis.Z, EnumFacing.Axis.X, EnumFacing.Axis.Y),
    ZYX(EnumFacing.Axis.Z, EnumFacing.Axis.Y, EnumFacing.Axis.X);

    public static final EnumAxisOrder[] VALUES;
    private static final Map<String, EnumAxisOrder> orderMap;
    public final EnumFacing.Axis first;
    public final EnumFacing.Axis second;
    public final EnumFacing.Axis third;

    private EnumAxisOrder(EnumFacing.Axis a, EnumFacing.Axis b, EnumFacing.Axis c) {
        this.first = a;
        this.second = b;
        this.third = c;
    }

    public static EnumAxisOrder getOrder(String name) {
        EnumAxisOrder order = orderMap.get(name);
        if (order == null) {
            order = XZY;
        }
        return order;
    }

    public static EnumAxisOrder getOrder(EnumFacing.Axis first, EnumFacing.Axis b) {
        if (first == EnumFacing.Axis.X) {
            return b == EnumFacing.Axis.Y ? XYZ : XZY;
        }
        if (first == EnumFacing.Axis.Y) {
            return b == EnumFacing.Axis.X ? YXZ : YZX;
        }
        return b == EnumFacing.Axis.X ? ZXY : ZYX;
    }

    public AxisOrder getMinToMaxOrder() {
        return AxisOrder.getFor(this, AxisOrder.Inversion.PPP);
    }

    public AxisOrder getMaxToMinOrder() {
        return AxisOrder.getFor(this, AxisOrder.Inversion.NNN);
    }

    static {
        VALUES = EnumAxisOrder.values();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EnumAxisOrder order : EnumAxisOrder.values()) {
            builder.put((Object)order.name(), (Object)order);
        }
        orderMap = builder.build();
    }
}

