/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import java.util.Arrays;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;

public class ArrayUtil {
    public static <F, T> T[] map(F[] from, Function<F, T> mapper, IntFunction<T[]> arrayConstructor) {
        T[] array = arrayConstructor.apply(from.length);
        int i = from.length;
        while (i-- > 0) {
            array[i] = mapper.apply(from[i]);
        }
        return array;
    }

    public static <T> int[] mapToInt(T[] from, ToIntFunction<T> mapper) {
        int[] array = new int[from.length];
        int i = from.length;
        while (i-- > 0) {
            array[i] = mapper.applyAsInt(from[i]);
        }
        return array;
    }

    public static <T> boolean testForAny(T[] array, Predicate<T> predicate) {
        for (T t : array) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean testForAll(T[] array, Predicate<T> predicate) {
        for (T t : array) {
            if (predicate.test(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> int manualHash(T[] toHash, ToIntFunction<T> hasher) {
        int[] hashArray = ArrayUtil.mapToInt(toHash, hasher);
        return Arrays.hashCode(hashArray);
    }

    public static <T> boolean manualEquals(T[] a, T[] b, BiPredicate<T, T> equalityChecker) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        int i = a.length;
        while (i-- > 0) {
            if (equalityChecker.test(a[i], b[i])) continue;
            return false;
        }
        return true;
    }
}

