/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.api.core.BCLog;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class AdvancementUtil {
    private static final Set<ResourceLocation> UNKNOWN_ADVANCEMENTS = new HashSet<ResourceLocation>();

    public static void unlockAdvancement(EntityPlayer player, ResourceLocation advancementName) {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            AdvancementManager advancementManager = playerMP.func_71121_q().func_191952_z();
            if (advancementManager == null) {
                return;
            }
            Advancement advancement = advancementManager.func_192778_a(advancementName);
            if (advancement != null) {
                playerMP.func_192039_O().func_192750_a(advancement, "code_trigger");
            } else if (UNKNOWN_ADVANCEMENTS.add(advancementName)) {
                BCLog.logger.warn("[lib.advancement] Attempted to trigger undefined advancement: " + advancementName);
            }
        }
    }

    public static boolean unlockAdvancement(UUID player, ResourceLocation advancementName) {
        Entity entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(player);
        if (entity != null && entity instanceof EntityPlayerMP) {
            AdvancementUtil.unlockAdvancement((EntityPlayer)entity, advancementName);
            return true;
        }
        return false;
    }
}

