/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionBi;
import buildcraft.lib.expression.node.value.NodeConstantDouble;

public class NodeFuncObjectToDouble<A>
extends NodeFuncBase
implements INodeFunc.INodeFuncDouble {
    public final IFuncObjectToDouble<A> function;
    private final StringFunctionBi stringFunction;
    private final Class<A> argTypeA;

    public NodeFuncObjectToDouble(String name, Class<A> argTypeA, IFuncObjectToDouble<A> function) {
        this(argTypeA, function, (String a) -> "[ " + NodeTypes.getName(argTypeA) + " -> double ] " + name + "(" + a + ")");
    }

    public NodeFuncObjectToDouble(Class<A> argTypeA, IFuncObjectToDouble<A> function, StringFunctionBi stringFunction) {
        this.argTypeA = argTypeA;
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction.apply("{A}");
    }

    @Override
    public IExpressionNode.INodeDouble getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeObject<A> a = stack.popObject(this.argTypeA);
        return new Func(a);
    }

    @FunctionalInterface
    public static interface IFuncObjectToDouble<A> {
        public double apply(A var1);
    }

    private class Func
    implements IExpressionNode.INodeDouble {
        private final IExpressionNode.INodeObject<A> argA;

        public Func(IExpressionNode.INodeObject<A> argA) {
            this.argA = argA;
        }

        @Override
        public double evaluate() {
            return NodeFuncObjectToDouble.this.function.apply(this.argA.evaluate());
        }

        @Override
        public IExpressionNode.INodeDouble inline() {
            if (!NodeFuncObjectToDouble.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, a -> new Func(a), a -> new Func(a));
            }
            return NodeInliningHelper.tryInline(this, this.argA, a -> new Func(a), a -> NodeConstantDouble.of(NodeFuncObjectToDouble.this.function.apply(a.evaluate())));
        }

        public String toString() {
            return NodeFuncObjectToDouble.this.stringFunction.apply(this.argA.toString());
        }
    }
}

