/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionTri;
import buildcraft.lib.expression.node.value.NodeConstantObject;

public class NodeFuncObjectObjectToObject<A, B, R>
extends NodeFuncBase
implements INodeFunc.INodeFuncObject<R> {
    public final IFuncObjectObjectToObject<A, B, R> function;
    private final StringFunctionTri stringFunction;
    private final Class<A> argTypeA;
    private final Class<B> argTypeB;
    private final Class<R> returnType;

    public NodeFuncObjectObjectToObject(String name, Class<A> argTypeA, Class<B> argTypeB, Class<R> returnType, IFuncObjectObjectToObject<A, B, R> function) {
        this(argTypeA, argTypeB, returnType, function, (String a, String b) -> "[ " + NodeTypes.getName(argTypeA) + ", " + NodeTypes.getName(argTypeB) + " -> " + NodeTypes.getName(returnType) + " ] " + name + "(" + a + ", " + b + ")");
    }

    public NodeFuncObjectObjectToObject(Class<A> argTypeA, Class<B> argTypeB, Class<R> returnType, IFuncObjectObjectToObject<A, B, R> function, StringFunctionTri stringFunction) {
        this.argTypeA = argTypeA;
        this.argTypeB = argTypeB;
        this.returnType = returnType;
        this.function = function;
        this.stringFunction = stringFunction;
    }

    @Override
    public Class<R> getType() {
        return this.returnType;
    }

    public String toString() {
        return this.stringFunction.apply("{A}", "{B}");
    }

    @Override
    public IExpressionNode.INodeObject<R> getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeObject<B> b = stack.popObject(this.argTypeB);
        IExpressionNode.INodeObject<A> a = stack.popObject(this.argTypeA);
        return new Func(a, b);
    }

    @FunctionalInterface
    public static interface IFuncObjectObjectToObject<A, B, R> {
        public R apply(A var1, B var2);
    }

    private class Func
    implements IExpressionNode.INodeObject<R> {
        private final IExpressionNode.INodeObject<A> argA;
        private final IExpressionNode.INodeObject<B> argB;

        public Func(IExpressionNode.INodeObject<A> argA, IExpressionNode.INodeObject<B> argB) {
            this.argA = argA;
            this.argB = argB;
        }

        @Override
        public Class<R> getType() {
            return NodeFuncObjectObjectToObject.this.returnType;
        }

        @Override
        public R evaluate() {
            return NodeFuncObjectObjectToObject.this.function.apply(this.argA.evaluate(), this.argB.evaluate());
        }

        @Override
        public IExpressionNode.INodeObject<R> inline() {
            if (!NodeFuncObjectObjectToObject.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new Func(a, b), (a, b) -> new Func(a, b));
            }
            return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new Func(a, b), (a, b) -> new NodeConstantObject(NodeFuncObjectObjectToObject.this.returnType, NodeFuncObjectObjectToObject.this.function.apply(a.evaluate(), b.evaluate())));
        }

        public String toString() {
            return NodeFuncObjectObjectToObject.this.stringFunction.apply(this.argA.toString(), this.argB.toString());
        }
    }
}

