/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionTri;
import buildcraft.lib.expression.node.value.NodeConstantLong;

public class NodeFuncObjectLongToLong<A>
extends NodeFuncBase
implements INodeFunc.INodeFuncLong {
    public final IFuncObjectLongToLong<A> function;
    private final StringFunctionTri stringFunction;
    private final Class<A> argTypeA;

    public NodeFuncObjectLongToLong(String name, Class<A> argTypeA, IFuncObjectLongToLong<A> function) {
        this(argTypeA, function, (String a, String b) -> "[ " + NodeTypes.getName(argTypeA) + ", long -> long ] " + name + "(" + a + ", " + b + ")");
    }

    public NodeFuncObjectLongToLong(Class<A> argTypeA, IFuncObjectLongToLong<A> function, StringFunctionTri stringFunction) {
        this.argTypeA = argTypeA;
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction.apply("{A}", "{B}");
    }

    @Override
    public IExpressionNode.INodeLong getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeLong b = stack.popLong();
        IExpressionNode.INodeObject<A> a = stack.popObject(this.argTypeA);
        return new Func(a, b);
    }

    @FunctionalInterface
    public static interface IFuncObjectLongToLong<A> {
        public long apply(A var1, long var2);
    }

    private class Func
    implements IExpressionNode.INodeLong {
        private final IExpressionNode.INodeObject<A> argA;
        private final IExpressionNode.INodeLong argB;

        public Func(IExpressionNode.INodeObject<A> argA, IExpressionNode.INodeLong argB) {
            this.argA = argA;
            this.argB = argB;
        }

        @Override
        public long evaluate() {
            return NodeFuncObjectLongToLong.this.function.apply(this.argA.evaluate(), this.argB.evaluate());
        }

        @Override
        public IExpressionNode.INodeLong inline() {
            if (!NodeFuncObjectLongToLong.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new Func(a, (IExpressionNode.INodeLong)b), (a, b) -> new Func(a, (IExpressionNode.INodeLong)b));
            }
            return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new Func(a, (IExpressionNode.INodeLong)b), (a, b) -> NodeConstantLong.of(NodeFuncObjectLongToLong.this.function.apply(a.evaluate(), b.evaluate())));
        }

        public String toString() {
            return NodeFuncObjectLongToLong.this.stringFunction.apply(this.argA.toString(), this.argB.toString());
        }
    }
}

