/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionQuad;
import buildcraft.lib.expression.node.value.NodeConstantObject;

public class NodeFuncObjectLongLongToObject<A, R>
extends NodeFuncBase
implements INodeFunc.INodeFuncObject<R> {
    public final IFuncObjectLongLongToObject<A, R> function;
    private final StringFunctionQuad stringFunction;
    private final Class<A> argTypeA;
    private final Class<R> returnType;

    public NodeFuncObjectLongLongToObject(String name, Class<A> argTypeA, Class<R> returnType, IFuncObjectLongLongToObject<A, R> function) {
        this(argTypeA, returnType, function, (String a, String b, String c) -> "[ " + NodeTypes.getName(argTypeA) + ", long, long -> " + NodeTypes.getName(returnType) + " ] " + name + "(" + a + ", " + b + ", " + c + ")");
    }

    public NodeFuncObjectLongLongToObject(Class<A> argTypeA, Class<R> returnType, IFuncObjectLongLongToObject<A, R> function, StringFunctionQuad stringFunction) {
        this.argTypeA = argTypeA;
        this.returnType = returnType;
        this.function = function;
        this.stringFunction = stringFunction;
    }

    @Override
    public Class<R> getType() {
        return this.returnType;
    }

    public String toString() {
        return this.stringFunction.apply("{A}", "{B}", "{C}");
    }

    @Override
    public IExpressionNode.INodeObject<R> getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeLong c = stack.popLong();
        IExpressionNode.INodeLong b = stack.popLong();
        IExpressionNode.INodeObject<A> a = stack.popObject(this.argTypeA);
        return new Func(a, b, c);
    }

    @FunctionalInterface
    public static interface IFuncObjectLongLongToObject<A, R> {
        public R apply(A var1, long var2, long var4);
    }

    private class Func
    implements IExpressionNode.INodeObject<R> {
        private final IExpressionNode.INodeObject<A> argA;
        private final IExpressionNode.INodeLong argB;
        private final IExpressionNode.INodeLong argC;

        public Func(IExpressionNode.INodeObject<A> argA, IExpressionNode.INodeLong argB, IExpressionNode.INodeLong argC) {
            this.argA = argA;
            this.argB = argB;
            this.argC = argC;
        }

        @Override
        public Class<R> getType() {
            return NodeFuncObjectLongLongToObject.this.returnType;
        }

        @Override
        public R evaluate() {
            return NodeFuncObjectLongLongToObject.this.function.apply(this.argA.evaluate(), this.argB.evaluate(), this.argC.evaluate());
        }

        @Override
        public IExpressionNode.INodeObject<R> inline() {
            if (!NodeFuncObjectLongLongToObject.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, this.argB, this.argC, (a, b, c) -> new Func(a, (IExpressionNode.INodeLong)b, (IExpressionNode.INodeLong)c), (a, b, c) -> new Func(a, (IExpressionNode.INodeLong)b, (IExpressionNode.INodeLong)c));
            }
            return NodeInliningHelper.tryInline(this, this.argA, this.argB, this.argC, (a, b, c) -> new Func(a, (IExpressionNode.INodeLong)b, (IExpressionNode.INodeLong)c), (a, b, c) -> new NodeConstantObject(NodeFuncObjectLongLongToObject.this.returnType, NodeFuncObjectLongLongToObject.this.function.apply(a.evaluate(), b.evaluate(), c.evaluate())));
        }

        public String toString() {
            return NodeFuncObjectLongLongToObject.this.stringFunction.apply(this.argA.toString(), this.argB.toString(), this.argC.toString());
        }
    }
}

